#!/bin/sh
#export DISPLAY=:0
export scriptdir=`/usr/bin/dirname $0`
cd $scriptdir
dateprint_manifest="$(date +%Y-%m-%dT%H:%M:%S)"
dateprint="$(date +%Y-%m-%d__%H-%M-%S)"
mkdir -p ../Games/Chess_$dateprint
cp Icon_notes.png ../Games/Chess_$dateprint/Icon_notes.png
cp ChessNote.pdf ../Games/Chess_$dateprint/Chess_$dateprint.pdf
echo """<?xml version=\"1.0\" encoding=\"utf-8\"?>
<package>
	<metadata>
		<dc-metadata>
			<Title>Chess_$dateprint</Title>
			<Description>Chess_$dateprint</Description>
			<Date>$dateprint_manifest</Date>
		</dc-metadata>
		<y-metadata>
			<startpage>Chess_$dateprint.pdf</startpage>
			<image>Icon_notes.png</image>
			<version>000</version>
			<ItemSize>0</ItemSize>
		</y-metadata>
	</metadata>
	<last-location>
		<pagenumber>1</pagenumber>
	</last-location>
	<viewer-settings>
		<zoomfactor>zoomPage</zoomfactor>
		<rotation>90</rotation>
		<positionx>0</positionx>
		<positiony>0</positiony>
		<mode>page</mode>
	</viewer-settings>
</package>""" > ../Games/Chess_$dateprint/manifest.xml
cd ../Games/
