= DocTemplate ClipCode "xBook%0.2d.css"
/*THIS FILE WAS CREATED FOR USE WITH THE XBOOK FILE SPEC*/
/*CREATED BY THE XBOOK NOTETAB CLIP LIBRARY*/

/*********/
/*GENERAL*/
/*********/

/*BASIC COLORS AND IE FONT-SIZE WORKAROUND*/
body {
background-color:white;
color:black;
font-size:100%;
}

/*NEW PAGE AFTER EACH SECTION OF THE BOOK*/
/*WORKS FOR PRINTING, OR FOR EBOOKS!     */
/*ALSO, RUN A VISIBLE BORDER FOR BROWSERS*/
div {
page-break-after:always;
border-bottom:1px solid;
}

/*SPINE HEADINGS*/
h2 {
font-size:2.5em;
position:relative;
left:1.5em;
border-bottom:1px solid;
}

/*BODY HEADINGS*/
h3 {
text-align:right;
font-size:2em;
margin-bottom:0;
}

/*SECTION HEADINGS*/
h4 {
font-size:2em;
margin-top:0;
padding:0;
border:2px solid;
}

/*SUB-SECTION HEADINGS*/
h5 {}

/*NAVIGATION LINKS*/
ul.NavLinks {
width:auto;
float:left;
margin:0 .3em 0 0;
padding:0;
list-style-type:none;
border:2px solid;
}

/*****************/
/*LESSER ELEMENTS*/
/*****************/

/*Epigram*/
blockquote.Epigram {}

/*Verse*/
blockquote.Verse {}

/*Pull Quote*/
q.PullQuote {}

/*Written Note*/
blockquote.Writing {}

/*Commentary*/
blockquote.Commentary {}

/*Illustration*/
img.Illustration {}

/*Map*/
img.Map {}

/*Table*/
table {}

table caption {
margin-top:1em;
text-align:left;
font-weight:bold;
caption-side:top;
}

/*BASIC PARAGRAPHS*/
p {text-indent:1em;
margin:0;
text-align:justify;
}

/*FIRST PARAGRAPHS*/
p.FirstParagraph {
text-indent:0;
text-align:justify;
}

/*META PARAGRAPHS*/
p.Meta {
text-indent:0;
text-align:left;
}

/*FIRST WORD*/
span.FirstWord {
text-transform:uppercase;
font-weight:bold;
font-size:2em;
line-height:90%;
}

/*FIRST LETTER*/
p.FirstParagraph:first-letter {}

/*SCENE BREAK*/
hr.SceneBreak {
width:10em;
}

/*PAGE BREAK*/
hr.PageBreak {
height:1px;
page-break-after:always;
}

/*********************/
/*SPECIFIC SPINE DIVS*/
/*********************/

/*COVER*/
div#Cover {}

div#Cover img {
margin:0;
padding:0;
}

/*FRONTISPIECE*/
div#Frontispiece {
text-align:center;
}

div#Frontispiece h2 {
margin:0;
position:relative;
left:0;}

div#Frontispiece ul {
list-style-type:none;
font-family:serif;
font-variant:small-caps;
font-size:2em;
margin:0 0 1em 0;
padding:0;
}

div#Frontispiece ul em {
font-style:normal;
font-weight:bold;
}

div#Frontispiece img {}

/*FRONT MATTER*/
div#FrontMatter {}

div#FrontMatter h2 {display:none;}  /*Suppress the header*/

/*TITLE PAGE*/
div#TitlePage {
text-align:center;
font-family:Serif;
}

div#TitlePage h1 {
font-size:4em;
}

div#TitlePage p#SubTitle {
font-size:2em;
font-style:italic;
margin:0 0 2em 0;
text-align:center;
}

div#TitlePage p#Author {
font-size:3em;
font-weight:bold;
margin:0 0 4em 0;
text-align:center;
}

div#TitlePage p#Illustrator {
width:auto;
float:left;
font-family:Sans-Serif;
margin:0 0 1ex 0;
}

div#TitlePage p#CoverDesigner {
font-family:Sans-Serif;
text-align:right;
margin:0 0 1ex 0;
}

/*VERSO*/
div#Verso {}

div#Verso h2 {display:none;}  /*Suppress the header*/

div#Verso * img {
display:block;
margin-right:auto;
margin-top:1em;
margin-bottom:1em;
}

div#Verso * li {
margin-bottom:1ex;
}

div#Verso ul#VersoLeftColumn {
width:auto;
float:left;
margin:0;
padding:0;
list-style-type:none;
}

div#Verso ul#VersoLeftColumn li p strong {
display:block;
}

div#Verso ul#VersoRightColumn {
list-style-type:none;
display:inline;
margin:0;
padding:0;
}

div#Verso ul#VersoRightColumn li p {
text-align:right;
}

div#Verso ul#VersoRightColumn li p strong {
display:block;
}

div#Verso p#FileVersion {}

div#Verso p#FileRevisionDate {}

div#Verso p#FileSource {}

div#Verso p#FileScanner {}

div#Verso p#FileProofer {}

div#Verso p#ISBN {}

div#Verso p#Publisher {}

div#Verso p#PublicationDate {}

div#Verso p#PublicationCity {}

div#Verso p#CopyrightDate {}

div#Verso p#CopyrightHolder {}

div#Verso p#CopyrightCity {}

/*INSCRIPTION*/
div#Inscription {}

div#Inscription h2 {display:none;}  /*Suppress the header*/

div#Inscription p {
font-style:italic;
font-size:1.5em;
border-top:thick solid;
border-bottom:thick solid;
margin:40% 30% 10%;
padding:.5em;
text-align:center;
}

/*ACKNOWLEDGEMENT*/
div#Acknowledgement {}

div#Acknowledgement h2 {display:none;}  /*Suppress the header*/

/*PREFACE*/
div#Preface {}

/*TOI*/
div#TableOfIllustrations {}

div#TableOfIllustrations h2 {
display:inline;
}

div#TableOfIllustrations img {
position:absolute;
left:.5em;
margin-top:.5em;
}

div#TableOfIllustrations ol {
list-style-position:inside;
margin-left:4em;
}

/*TOM*/
div#TableOfMaps {}

div#TableOfMaps h2 {
display:inline;
}

div#TableOfMaps img {
position:absolute;
left:.5em;
margin-top:.5em;
}

div#TableOfMaps ol {
list-style-position:inside;
margin-left:4em;
}

/*TOT*/
div#TableOfTables {}

div#TableOfTables h2 {
display:inline;
}

div#TableOfTables img {
position:absolute;
left:.5em;
margin-top:.5em;
}

div#TableOfTables ol {
list-style-position:inside;
margin-left:4em;
}

/*TOC*/
div#TableOfContents {}

div#TableOfContents h2 {
display:inline;
}

div#TableOfContents img {
position:absolute;
left:.5em;
margin-top:.5em;
}

div#TableOfContents ol {
list-style-type:none;
margin-left:4em;
}

/*FOREWORD*/
div#Foreword {}

/*PART*/
div#Part {}

/*AFTERWORD*/
div#Afterword {}

/*ABOUT THE AUTHOR*/
div#AboutTheAuthor h2 {
display:block;
}

div#AboutTheAuthor img {
float:right;
margin:1em;
}

div#AboutTheAuthor h4 {
margin:1em;
border:none;
}

/*COLOPHON*/
div#Colophon {}

div#Colophon h2 {
}

div#Colophon p.FirstParagraph {
margin-top:1em;
}

div#Colophon img {
display:block;
margin-top:1em;
margin-bottom:1em;
margin-left:4em;
}

/*ENDNOTES*/
div#Endnotes {}

/*ACTUAL ENDNOTE*/
div#Endnotes ul {
list-style-type:none;
}

div#Endnotes ul li {}

div#Endnotes ul li a.EndNoteBackLink img {
margin-top:.25em;
margin-bottom:.25em;
display:block;
page-break-after:always;
}

/*GLOSSARY*/
div#Glossary {}

/*INDEX*/
div#Index {}

/*END MATTER*/
div#EndMatter {}
