#!/bin/bash

get_data() {
  OPF=$(sed -n -e '/<rootfile /s/.*full-path="\([^"]*\)".*/\1/p' META-INF/container.xml)
  BASEDIR=$(dirname $OPF)
  TITLE=$(sed -n -e '/<dc:title/s/.*<dc:title>\(.*\)<\/dc:title>/\1/p' $OPF)
  NCX=$(sed -n -e '/<spine/s/.*toc="\(.[^"]*\)".*/\1/p' $OPF)
  NCX=$(sed -n -e "/id=\"$NCX\"/s/.*href=\"\(.[^\"]*\)\".*/\1/p" $OPF)
  NCX=$BASEDIR/$NCX
}

write_css() {
cat > index.css << EOF
body {
  margin: auto auto;
  padding: 2%;
  max-width: 35em;
  text-align: justify;
  font-size: 12pt;
  font-family: serif;
}

div.pagebreak {
  border: dashed;
  border-width: 1px 0 0 0;
  margin: 0 -2.05% 0 -2.05%;
}
EOF
}

write_html() {
cat > index.html << EOF
<html>
<head>
  <title>$TITLE</title>
  <script lang="javascript" type="text/javascript">
  function AddCSS() {
    var NewStyle=book.document.createElement("link");
    NewStyle.setAttribute("rel","stylesheet");
    NewStyle.setAttribute("type","text/css");
    NewStyle.setAttribute("href","../index.css");
    book.document.getElementsByTagName("head")[0].appendChild(NewStyle);
  }
  function ChangeTitle() {
    document.title=book.document.title;
  }
  </script>
</head>
<frameset cols="25%,75%">
  <frame src="index.xhtml"/>
  <frame src="$BASEDIR/${files[0]}" name="book" onload="AddCSS(); ChangeTitle()"/>
</frameset>
</html>
EOF
}

write_xhtml() {
cat > index.xhtml << EOF
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:base="$BASEDIR/">
<head>
  <style>
body {
  margin-top: 4em;
}
div.top {
  position: fixed;
  top: 0;
  margin: 0 auto 0 auto;
  background-color: white;
  color: black;
}
div.top a {
  color: inherit;
  text-decoration: none;
  font-weight: bold;
}
div.top a.deact {
  opacity: 0.3;
}
div.top table {
  width: 100%;
}
div.top td {
  width: 25%;
  text-align: center;
}
.big {
  font-size: 150%;
  font-weight: bold;
}
.small {
  font-size: 80%;
  color: red;
}
.show {
  display: block;
}
.hide {
  display: none;
}
  </style>
  <script lang="javascript" type="text/javascript">
<![CDATA[
var num = 0;
var html = document.getElementsByTagName("html");
var basedir = html[0].getAttribute('base');
EOF

echo -n 'var files = [' >> index.xhtml
echo -n "'${files[0]}'" >> index.xhtml
for (( i=1; i<${#files[*]}; i++ )); do
  if [[ ${linears[$i]} -eq 1 ]]; then echo -n ", '${files[$i]}'" >> index.xhtml; fi
done
echo '];' >> index.xhtml

cat >> index.xhtml << EOF
function nextFile() {
  if (num < files.length-1) {
    num = Math.floor(num);
    num++;
    parent.book.location.href=basedir + files[num];
    setLinks(num);
  }
}
function prevFile() {
  if (num > 0) {
    num = Math.ceil(num);
    num--;
    parent.book.location.href=basedir + files[num];
    setLinks(num);
  }
}
function setLinks(number) {
  num = number;
  if (Math.floor(num) == Math.ceil(num)) {
    if (num <= 0) {
      document.getElementById('prev').setAttribute('class','deact');
      document.getElementById('prev').href=files[0];
    } else {
      document.getElementById('prev').setAttribute('class','act');
      document.getElementById('prev').href=files[num-1];
    }
    if (num >= files.length-1) {
      document.getElementById('next').setAttribute('class','deact');
      document.getElementById('next').href=files[files.length-1];
    } else {
      document.getElementById('next').setAttribute('class','act');
      document.getElementById('next').href=files[num+1];
    }
  } else {
    document.getElementById('prev').setAttribute('class','act');
    document.getElementById('prev').href=files[Math.floor(num)];
    if (Math.ceil(num) >= files.length-1) {
      document.getElementById('next').setAttribute('class','deact');
      document.getElementById('next').href=window.event.srcElement.href;
    } else {
      document.getElementById('next').setAttribute('class','act');
      document.getElementById('next').href=files[Math.ceil(num)+1];
    }
  }
}
function setSpine() {
  document.getElementById('current').innerHTML='SPINE';
  document.getElementById('change').innerHTML='TOC';
  document.getElementById('change').setAttribute('onclick','setToc()');
  document.getElementById('spine').setAttribute('class','show');
  document.getElementById('toc').setAttribute('class','hide');
}
function setToc() {
  document.getElementById('current').innerHTML='TOC';
  document.getElementById('change').innerHTML='SPINE';
  document.getElementById('change').setAttribute('onclick','setSpine()');
  document.getElementById('toc').setAttribute('class','show');
  document.getElementById('spine').setAttribute('class','hide');
}
]]>
  </script>
</head>
<body>

<div class="top">
<table><tr>
<td><a href="${files[0]}" target="book" onclick="setLinks(0);">&lt;&lt;&lt;</a></td>
<td><a class="deact" id="prev" href="${files[0]}" target="book" onclick="prevFile(); return false;">&lt;</a></td>
<td><a id="next" href="${files[1]}" target="book" onclick="nextFile(); return false;">&gt;</a></td>
<td><a href="${files[${#files[*]}-1]}" target="book" onclick="setLinks(files.length-1);">&gt;&gt;&gt;</a></td>
</tr><tr>
<td id="current" class="big" colspan="2">SPINE</td>
<td id="change" class="small" onclick="setToc();">TOC</td>
</tr></table>
</div>

<div id="spine" class="show">
EOF

j=-1
for (( i=0; i<${#ids[*]}; i++ )); do
  if [[ ${linears[$i]} -eq 0 ]]; then
    j=$(echo "scale=0; k=($j+1)/1-$j; scale=10; if ($j >= 0) $j+k/2 else 0" | bc)
    echo -n "* " >> index.xhtml
   else
    j=$(echo "scale=0; ($j+1)/1" | bc);
  fi
  echo "<a href=\"${files[$i]}\" target=\"book\" onclick=\"setLinks($j);\">${ids[$i]}</a><br/>" >> index.xhtml
done

cat >> index.xhtml << EOF
</div>

<div id="toc" class="hide">
The TOC is not yet implemented.
</div>

</body>
</html>
EOF
}

read_spine() {
  ORIGIFS=$IFS
  IFS=`echo -en "\n\b"`
  for id in $(sed -n -e '/<itemref/s/.*idref="\(.[^"]*\)".*/\1/p' $OPF); do
    file=$(sed -n -e "/id=\"$id\"/s/.*href=\"\(.[^\"]*\)\".*/\1/p" $OPF)
    linear=$(sed -n -e "/idref=\"$id\"/s/.*linear=\"\([^\"]*\)\".*/\1/p" $OPF)
    if [[ $linear == "no" ]]; then linear=0; else linear=1; fi
    ids[${#ids[*]}]=$id
    files[${#files[*]}]=$file
    linears[${#linears[*]}]=$linear
  done
}

#=================================================

DIR=$PWD
EPUB=$(readlink -f "$1")
TEMPDIR=$(mktemp -td epub.XXXXXX) || exit 1
[ -d $TEMPDIR ] || mkdir $TEMPDIR

cd $TEMPDIR
unzip -qo "$EPUB"

get_data
read_spine
write_css
write_html
write_xhtml

echo -e "\n$(readlink -f index.html)\n"

read -p "Press <ENTER> to delete the temporary files" END

cd $DIR
rm -r $TEMPDIR
exit
