#!/bin/sh

scriptdir=`/usr/bin/dirname $0`
cd $scriptdir

# Find out in what file system this script resides
MOUNTPOINT=`df . | grep dev | tr -s " " | cut -f6 -d" "`

# If /usr/local exists and is a symlink this script has probably already been
# run from another file system. In that case, remove the symlink and continue.
test -L /usr/local && rm /usr/local

# If /usr/local exists and is not a symlink, log an error and exit.
if [ -e /usr/local ]; then
	printf "%s\n" "/usr/local already exists, exiting" > ${scriptdir}/error_log.txt
	exit 1
fi

# Create directory structure in the current file system and make a symlink
# from /usr/local to point to it.
mkdir -p ${MOUNTPOINT}/local/additional_progs
mkdir -p ${MOUNTPOINT}/local/home
ln -s ${MOUNTPOINT}/local /usr/local

# Write common environment variables to /usr/local/home/environment.
printf "%s\n" "HOME=/usr/local/home" > /usr/local/home/environment
printf "%s\n" "export HOME" >> /usr/local/home/environment
printf "%s\n" "LD_LIBRARY_PATH=/usr/local/lib:$LD_LIBRARY_PATH" >> /usr/local/home/environment
printf "%s\n" "export LD_LIBRARY_PATH" >> /usr/local/home/environment
printf "%s\n" "PATH=/usr/local/bin:$PATH" >> /usr/local/home/environment
printf "%s\n" "export PATH" >> /usr/local/home/environment
 
