#!/bin/sh

scriptdir=`/usr/bin/dirname $0`
cd $scriptdir

LANG=`grep "language" /var/er_registry.txt |cut -d'=' -f 2 |cut -d'_' -f 1`
DIR=/usr/share/contentlister/mode/${LANG}
test -f ${scriptdir}/error_log && rm ${scriptdir}/error_log
test -f ${scriptdir}/original_order && rm ${scriptdir}/original_order

ls ${DIR} | sed -e "s!${DIR}!!g" | cut -d_ -f2 > ${scriptdir}/original_order

# Just in case, convert the file new_order from DOS to UNIX format.
cat ${scriptdir}/new_order.txt | tr -d \\r > ${scriptdir}/new_order

# Sanity check, is there the same number of entries in new_order and original_order

WCORIG=`wc -l < ${scriptdir}/original_order`
WCWANTED=`wc -l < ${scriptdir}/new_order.txt`

if [ ${WCORIG} -ne ${WCWANTED} ]; then
	printf "%s\ni%s\n" "LANG = \"${LANG}\"" > ${scriptdir}/error_log
	ls -l /usr/share/contentlister/mode/ >> ${scriptdir}/error_log
	ls -l ${DIR} >> ${scriptdir}/error_log
	printf "%s\n%d%s\n%d%s\n" "Number of lines in the file new_order differs from the number of entries in Device Manager menu." $WCORIG " entries in Device Manager menu." $WCWANTED " in the file new_order." >> ${scriptdir}/error_log
fi

# Sanity check, does the entries in new_order exist in original_order

NUM=0

sort ${scriptdir}/original_order > ${scriptdir}/original.sort
sort ${scriptdir}/new_order > ${scriptdir}/new.sort
test -f ${scriptdir}/diff.out && rm ${scriptdir}/diff.out

# Since the iLiad have no diff program this awk script is used instead
awk '
FILENAME == "${scriptdir}/new.sort" { arr[$0]++}
FILENAME == "${scriptdir}/original.sort" { if ( arr[$0] != 1 ) { delete arr[$0]}
                  else  delete arr[$0]
                }
END {
for ( key in arr ) print key
}' ${scriptdir}/new.sort ${scriptdir}/original.sort > ${scriptdir}/diff.out

rm ${scriptdir}/original.sort ${scriptdir}/new.sort
if [ -s ${scriptdir}/diff.out ]; then
	echo "The following line(s) does not exist in Device Manager menu." >> ${scriptdir}/error_log
	cat ${scriptdir}/diff.out >> ${scriptdir}/error_log
fi
rm ${scriptdir}/diff.out

if [ -s ${scriptdir}/error_log ]; then
	cat ${scriptdir}/error_log | sed -e "s/$/\\r/g" > ${scriptdir}/error_log.txt
	rm ${scriptdir}/new_order ${scriptdir}/error_log
	exit 1
fi

# OK, checks been done, now change the ordering

NUM=0
cat ${scriptdir}/new_order | while read Line
do
	let NUM=${NUM}+1
	OLD_FILE=`echo ${DIR}/*_${Line}`
	NEW_FILE="${DIR}/`printf %02d ${NUM}`_${Line}"
	if [ "${OLD_FILE}" != "${NEW_FILE}" ]; then
		mv "${OLD_FILE}" "${NEW_FILE}"
	fi
done
rm ${scriptdir}/new_order

# Update the manifest to reflect the new status
mv ${scriptdir}/manifest.xml ${scriptdir}/reorder.xml
mv ${scriptdir}/restore.xml ${scriptdir}/manifest.xml
