/*
 * Decompiled with CFR 0.152.
 */
package iliadmanifestcreator;

import iliadmanifestcreator.ILiadManifest;
import iliadmanifestcreator.ImageTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;

public class MainFrame
extends JFrame
implements DropTargetListener {
    final Color[] iLiadColors = new Color[]{new Color(0), new Color(0x111111), new Color(0x222222), new Color(0x333333), new Color(0x444444), new Color(0x555555), new Color(0x666666), new Color(0x777777), new Color(0x888888), new Color(0x999999), new Color(0xAAAAAA), new Color(0xBBBBBB), new Color(0xCCCCCC), new Color(0xDDDDDD), new Color(0xEEEEEE), new Color(0xFFFFFF)};
    ILiadManifest imCurrentManifest;
    String strCurrentManifest;
    boolean isExistingManifest;
    DropTarget dtSource;
    DropTarget dtImage;
    private JButton btnCreateManifest;
    private JButton btnExit;
    private JButton btnImage;
    private JButton btnSource;
    private JCheckBox chkFillBackground;
    private JCheckBox chkImageConvertToGray;
    private JCheckBox chkImageResize;
    private JCheckBox chkNegative;
    private JCheckBox chkResetPosition;
    private JComboBox cmbFillBackgroundColor;
    private JLabel lblDescription;
    private JLabel lblIcon;
    private JLabel lblImageExample;
    private JLabel lblImageExampleNote;
    private JLabel lblSource;
    private JLabel lblSourceNote;
    private JLabel lblTitle;
    private JLabel lblWarning;
    private JLabel lblWarningIcon;
    private JPanel pnlManifest;
    private JPanel pnlSource;
    private JScrollPane scrDescription;
    private JTextArea taDescription;
    private JTextField tfImage;
    private JTextField tfSource;
    private JTextField tfTitle;

    public MainFrame() {
        this.initComponents();
        this.showWarning(false);
        this.lblImageExampleNote.setVisible(false);
        this.btnCreateManifest.setEnabled(false);
        this.dtSource = new DropTarget(this.tfSource, this);
        this.dtImage = new DropTarget(this.tfImage, this);
    }

    protected void showWarning(boolean bShow) {
        this.lblWarningIcon.setVisible(bShow);
        this.lblWarning.setVisible(bShow);
        this.chkResetPosition.setVisible(!bShow);
    }

    private void initComponents() {
        this.pnlSource = new JPanel();
        this.lblSourceNote = new JLabel();
        this.lblSource = new JLabel();
        this.tfSource = new JTextField();
        this.btnSource = new JButton();
        this.pnlManifest = new JPanel();
        this.lblTitle = new JLabel();
        this.lblDescription = new JLabel();
        this.lblIcon = new JLabel();
        this.tfTitle = new JTextField();
        this.scrDescription = new JScrollPane();
        this.taDescription = new JTextArea();
        this.tfImage = new JTextField();
        this.btnImage = new JButton();
        this.chkImageResize = new JCheckBox();
        this.chkImageConvertToGray = new JCheckBox();
        this.chkFillBackground = new JCheckBox();
        this.cmbFillBackgroundColor = new JComboBox();
        this.chkNegative = new JCheckBox();
        this.lblImageExample = new JLabel();
        this.lblImageExampleNote = new JLabel();
        this.lblWarningIcon = new JLabel();
        this.lblWarning = new JLabel();
        this.chkResetPosition = new JCheckBox();
        this.btnCreateManifest = new JButton();
        this.btnExit = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("iLiad Manifest Creator");
        this.setResizable(false);
        this.pnlSource.setBorder(BorderFactory.createTitledBorder("Source"));
        this.lblSourceNote.setText("<html>Note: If you want to edit a manifest for a directory, make sure to select the directory containing the actual content (NOT the wrapping directory - or it will be wrapped again).</html>");
        this.lblSource.setLabelFor(this.tfSource);
        this.lblSource.setText("Source:");
        this.btnSource.setText("Browse...");
        this.btnSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnSourceActionPerformed(evt);
            }
        });
        GroupLayout pnlSourceLayout = new GroupLayout(this.pnlSource);
        this.pnlSource.setLayout(pnlSourceLayout);
        pnlSourceLayout.setHorizontalGroup(pnlSourceLayout.createParallelGroup(1).add(2, pnlSourceLayout.createSequentialGroup().addContainerGap().add(pnlSourceLayout.createParallelGroup(2).add(1, this.lblSourceNote, -1, 540, Short.MAX_VALUE).add(pnlSourceLayout.createSequentialGroup().add(this.lblSource).addPreferredGap(0).add(this.tfSource, -1, 414, Short.MAX_VALUE).addPreferredGap(0).add(this.btnSource))).addContainerGap()));
        pnlSourceLayout.setVerticalGroup(pnlSourceLayout.createParallelGroup(1).add(pnlSourceLayout.createSequentialGroup().add(this.lblSourceNote).addPreferredGap(0).add(pnlSourceLayout.createParallelGroup(3).add(this.tfSource, -2, -1, -2).add(this.btnSource).add(this.lblSource)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlManifest.setBorder(BorderFactory.createTitledBorder("Manifest"));
        this.lblTitle.setLabelFor(this.tfTitle);
        this.lblTitle.setText("Title:");
        this.lblDescription.setLabelFor(this.taDescription);
        this.lblDescription.setText("Description:");
        this.lblIcon.setLabelFor(this.tfImage);
        this.lblIcon.setText("Image:");
        this.scrDescription.setHorizontalScrollBarPolicy(31);
        this.taDescription.setColumns(20);
        this.taDescription.setFont(new Font("Tahoma", 0, 11));
        this.taDescription.setRows(3);
        this.taDescription.setMargin(new Insets(1, 5, 2, 4));
        this.scrDescription.setViewportView(this.taDescription);
        this.tfImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.tfImageActionPerformed(evt);
            }
        });
        this.btnImage.setText("Browse...");
        this.btnImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnImageActionPerformed(evt);
            }
        });
        this.chkImageResize.setSelected(true);
        this.chkImageResize.setText("Resize to 69 x 93 pixels");
        this.chkImageResize.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkImageResize.setMargin(new Insets(0, 0, 0, 0));
        this.chkImageConvertToGray.setSelected(true);
        this.chkImageConvertToGray.setText("Convert to ILiad grayscale");
        this.chkImageConvertToGray.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkImageConvertToGray.setMargin(new Insets(0, 0, 0, 0));
        this.chkImageConvertToGray.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.chkImageConvertToGrayActionPerformed(evt);
            }
        });
        this.chkFillBackground.setText("Fill background with");
        this.chkFillBackground.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkFillBackground.setMargin(new Insets(0, 0, 0, 0));
        this.chkFillBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.chkFillBackgroundActionPerformed(evt);
            }
        });
        this.cmbFillBackgroundColor.setModel(new DefaultComboBoxModel<String>(new String[]{"#000000 (Black)", "#111111", "#222222", "#333333", "#444444", "#555555 (Dark Grey)", "#666666", "#777777", "#888888", "#999999", "#AAAAAA (Light Grey)", "#BBBBBB", "#CCCCCC", "#DDDDDD", "#EEEEEE", "#FFFFFF (White)"}));
        this.cmbFillBackgroundColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmbFillBackgroundColorActionPerformed(evt);
            }
        });
        this.chkNegative.setText("Negative");
        this.chkNegative.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkNegative.setMargin(new Insets(0, 0, 0, 0));
        this.chkNegative.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.chkNegativeActionPerformed(evt);
            }
        });
        this.lblImageExample.setHorizontalAlignment(0);
        this.lblImageExample.setIcon(new ImageIcon(this.getClass().getResource("/iliadmanifestcreator/res/cross.png")));
        this.lblImageExample.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 255)));
        this.lblImageExample.setMaximumSize(new Dimension(69, 93));
        this.lblImageExample.setMinimumSize(new Dimension(69, 93));
        this.lblImageExample.setPreferredSize(new Dimension(69, 93));
        this.lblImageExampleNote.setText("<html>Note: the image preview is  the 69 x 93 px format.</html>");
        GroupLayout pnlManifestLayout = new GroupLayout(this.pnlManifest);
        this.pnlManifest.setLayout(pnlManifestLayout);
        pnlManifestLayout.setHorizontalGroup(pnlManifestLayout.createParallelGroup(1).add(pnlManifestLayout.createSequentialGroup().addContainerGap().add(pnlManifestLayout.createParallelGroup(1).add(this.lblTitle).add(this.lblDescription).add(this.lblIcon)).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(1).add(2, this.scrDescription, -1, 477, Short.MAX_VALUE).add(this.tfTitle, -1, 477, Short.MAX_VALUE).add(2, pnlManifestLayout.createSequentialGroup().add(pnlManifestLayout.createParallelGroup(2).add(1, pnlManifestLayout.createSequentialGroup().add(this.lblImageExample, -2, 69, -2).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(1).add(this.chkNegative).add(pnlManifestLayout.createSequentialGroup().add(this.chkFillBackground).addPreferredGap(0).add(this.cmbFillBackgroundColor, -2, 111, -2)).add(this.chkImageResize).add(this.chkImageConvertToGray)).add(47, 47, 47)).add(this.tfImage, -1, 392, Short.MAX_VALUE)).addPreferredGap(0).add(this.btnImage)).add(this.lblImageExampleNote, -2, 254, -2)).addContainerGap()));
        pnlManifestLayout.setVerticalGroup(pnlManifestLayout.createParallelGroup(1).add(pnlManifestLayout.createSequentialGroup().add(pnlManifestLayout.createParallelGroup(3).add(this.lblTitle).add(this.tfTitle, -2, -1, -2)).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(1).add(this.lblDescription).add(this.scrDescription, -2, 54, -2)).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(3).add(this.tfImage, -2, -1, -2).add(this.lblIcon).add(this.btnImage)).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(1).add(pnlManifestLayout.createSequentialGroup().add(this.chkImageResize).addPreferredGap(0).add(this.chkImageConvertToGray).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(3).add(this.chkFillBackground).add(this.cmbFillBackgroundColor, -2, -1, -2)).addPreferredGap(0).add(this.chkNegative)).add(this.lblImageExample, -2, 93, -2)).addPreferredGap(0).add(this.lblImageExampleNote, -1, -1, Short.MAX_VALUE)));
        this.lblWarningIcon.setIcon(new ImageIcon(this.getClass().getResource("/iliadmanifestcreator/res/exclamation.png")));
        this.lblWarning.setText("This will cause the file/directory to be moved to a subdirectory!");
        this.chkResetPosition.setText("Reset current position");
        this.chkResetPosition.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkResetPosition.setMargin(new Insets(0, 0, 0, 0));
        this.btnCreateManifest.setText("Create manifest");
        this.btnCreateManifest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnCreateManifestActionPerformed(evt);
            }
        });
        this.btnExit.setText("Exit");
        this.btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnExitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.pnlManifest, -1, -1, Short.MAX_VALUE).add(this.pnlSource, -1, -1, Short.MAX_VALUE).add(layout.createSequentialGroup().add(layout.createParallelGroup(2).add(layout.createSequentialGroup().add(10, 10, 10).add(this.lblWarningIcon).addPreferredGap(0).add(this.lblWarning).addPreferredGap(0).add(this.chkResetPosition).addPreferredGap(0, -1, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(this.btnCreateManifest).addPreferredGap(0))).add(this.btnExit))).addContainerGap()));
        layout.linkSize(new Component[]{this.btnCreateManifest, this.btnExit}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.pnlSource, -2, -1, -2).addPreferredGap(0).add(this.pnlManifest, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.lblWarningIcon).add(this.lblWarning).add(this.chkResetPosition)).addPreferredGap(0, 20, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.btnExit).add(this.btnCreateManifest)).addContainerGap()));
        this.pack();
    }

    private void tfImageActionPerformed(ActionEvent evt) {
        this.setImage(this.tfImage.getText());
    }

    private void cmbFillBackgroundColorActionPerformed(ActionEvent evt) {
        if (this.chkFillBackground.isSelected()) {
            this.setImage(this.tfImage.getText());
        }
    }

    private void chkNegativeActionPerformed(ActionEvent evt) {
        this.setImage(this.tfImage.getText());
    }

    private void chkFillBackgroundActionPerformed(ActionEvent evt) {
        this.setImage(this.tfImage.getText());
    }

    private void chkImageConvertToGrayActionPerformed(ActionEvent evt) {
        this.setImage(this.tfImage.getText());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void btnCreateManifestActionPerformed(ActionEvent evt) {
        if (this.imCurrentManifest == null || this.isExistingManifest && this.strCurrentManifest == null) {
            return;
        }
        File fileSource = new File(this.tfSource.getText());
        if (!fileSource.exists()) {
            return;
        }
        String strContentSrc = fileSource.isFile() ? this.imCurrentManifest.strStartPage : this.imCurrentManifest.strDirectoryContent;
        File dirWithContent = null;
        if (!this.isExistingManifest) {
            if (fileSource.isFile()) {
                dirWithContent = new File(fileSource.getParent() + File.separator + this.getFileTitle(fileSource) + File.separator);
                strContentSrc = fileSource.getName();
            } else {
                dirWithContent = new File(fileSource.getAbsolutePath() + File.separator);
                strContentSrc = "dir_content";
                File fileTempDir = new File(dirWithContent.getParentFile(), "__temp_dir_ILiadManifestCreator");
                if (!fileSource.renameTo(fileTempDir)) {
                    JOptionPane.showMessageDialog(this, "Error while moving the directory", "Error", 0);
                    return;
                }
                fileSource = fileTempDir;
            }
            this.strCurrentManifest = new File(dirWithContent, "manifest.xml").getAbsolutePath();
            File fileSourceMoved = new File(dirWithContent, strContentSrc);
            if (!fileSourceMoved.getParentFile().mkdirs()) {
                JOptionPane.showMessageDialog(this, "Error while creating the new directory", "Error", 0);
                return;
            }
            if (!fileSource.renameTo(fileSourceMoved)) {
                JOptionPane.showMessageDialog(this, "Error while moving directory", "Error", 0);
                return;
            }
            this.showWarning(false);
            this.tfSource.setText(fileSourceMoved.getAbsolutePath());
            fileSource = fileSourceMoved;
        } else {
            dirWithContent = new File(this.strCurrentManifest).getParentFile();
        }
        File fileImage = new File(this.tfImage.getText());
        String strImage = null;
        if (fileImage != null && fileImage.exists()) {
            String strImageDest;
            strImage = fileImage.getName();
            BufferedImage img = ImageTools.readImage(fileImage);
            if (this.chkImageResize.isSelected()) {
                img = ImageTools.scaleImage(img, 69, 93);
            }
            if (this.chkNegative.isSelected()) {
                img = ImageTools.negative(img);
            }
            if (this.chkFillBackground.isSelected()) {
                img = ImageTools.replaceAlphaByColor(img, this.iLiadColors[this.cmbFillBackgroundColor.getSelectedIndex()]);
            }
            if (this.chkImageConvertToGray.isSelected()) {
                img = ImageTools.convertTo4bitGrayScale(img);
            }
            if (!ImageTools.writeImage(img, "png", strImageDest = new File(dirWithContent, strImage).getAbsolutePath())) {
                strImage = null;
            }
        }
        this.imCurrentManifest.strTitle = this.tfTitle.getText();
        this.imCurrentManifest.strDescription = this.taDescription.getText();
        this.imCurrentManifest.strImage = strImage;
        if (fileSource.isFile()) {
            this.imCurrentManifest.strStartPage = strContentSrc;
        } else {
            this.imCurrentManifest.strDirectoryContent = strContentSrc;
        }
        if (this.isExistingManifest && this.chkResetPosition.isSelected()) {
            this.imCurrentManifest.resetCurrentPosition();
        }
        if (!this.imCurrentManifest.save(this.strCurrentManifest)) {
            JOptionPane.showMessageDialog(this, "Error while writing manifest file", "Error", 0);
            return;
        }
    }

    private void btnImageActionPerformed(ActionEvent evt) {
        File fileSource = new File(this.tfImage.getText());
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(2);
        fc.setSelectedFile(fileSource);
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".png") || f.getName().toLowerCase().endsWith(".bmp") || f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".gif");
            }

            public String getDescription() {
                return "Supported icon files";
            }
        };
        fc.setFileFilter(ff);
        int nReturnValue = fc.showOpenDialog(this);
        if (nReturnValue == 0 && fc.getSelectedFile().isFile()) {
            this.setImage(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void btnSourceActionPerformed(ActionEvent evt) {
        File fileSource = new File(this.tfSource.getText());
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(2);
        fc.setSelectedFile(fileSource);
        int nReturnValue = fc.showOpenDialog(this);
        if (nReturnValue == 0) {
            this.setSource(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        Toolkit t = Toolkit.getDefaultToolkit();
        EventQueue eq = t.getSystemEventQueue();
        eq.postEvent(new WindowEvent(this, 201));
    }

    private void setSource(String strSource) {
        File fileSource = new File(strSource);
        if (!fileSource.exists()) {
            this.showWarning(false);
            this.setImage("");
            this.btnCreateManifest.setEnabled(false);
            return;
        }
        this.tfSource.setText(fileSource.getAbsolutePath());
        String strManifestInSameDir = fileSource.getParent() + File.separator + "manifest.xml";
        boolean bManifestExists = false;
        if (new File(strManifestInSameDir).isFile()) {
            ILiadManifest imCheck = new ILiadManifest(strManifestInSameDir);
            bManifestExists = fileSource.isFile() ? imCheck.strStartPage.equalsIgnoreCase(fileSource.getName()) : imCheck.strDirectoryContent.equalsIgnoreCase(fileSource.getName());
        }
        if (bManifestExists) {
            this.strCurrentManifest = strManifestInSameDir;
            this.isExistingManifest = true;
            this.showWarning(false);
            this.imCurrentManifest = new ILiadManifest(strManifestInSameDir);
            this.tfTitle.setText(this.imCurrentManifest.strTitle);
            this.taDescription.setText(this.imCurrentManifest.strDescription);
            this.setImage(fileSource.getParent() + File.separator + this.imCurrentManifest.strImage);
            this.btnCreateManifest.setText("Save Manifest");
        } else {
            this.isExistingManifest = false;
            this.showWarning(true);
            this.imCurrentManifest = new ILiadManifest();
            this.tfTitle.setText(this.getFileTitle(fileSource));
            this.taDescription.setText("");
            this.setImage("");
            this.btnCreateManifest.setText("Create Manifest");
        }
        this.btnCreateManifest.setEnabled(true);
    }

    private String getFileTitle(File file) {
        if (file == null) {
            return null;
        }
        String strFile = file.getName();
        int nExtPos = strFile.lastIndexOf(46);
        if (nExtPos >= 0) {
            return strFile.substring(0, nExtPos);
        }
        return strFile;
    }

    private void setImage(String strImage) {
        boolean bResize = false;
        if (new File(strImage).isFile()) {
            this.tfImage.setText(strImage);
            bResize = !this.lblWarningIcon.isVisible();
            this.lblImageExampleNote.setVisible(true);
            BufferedImage imgOrg = ImageTools.readImage(new File(strImage));
            BufferedImage imgPreview = ImageTools.scaleImage(imgOrg, 69, 93);
            if (this.chkNegative.isSelected()) {
                imgPreview = ImageTools.negative(imgPreview);
            }
            if (this.chkFillBackground.isSelected()) {
                imgPreview = ImageTools.replaceAlphaByColor(imgPreview, this.iLiadColors[this.cmbFillBackgroundColor.getSelectedIndex()]);
            }
            if (this.chkImageConvertToGray.isSelected()) {
                imgPreview = ImageTools.convertTo4bitGrayScale(imgPreview);
            }
            this.lblImageExample.setIcon(new ImageIcon(imgPreview));
        } else {
            this.tfImage.setText("");
            this.lblImageExample.setIcon(new ImageIcon(this.getClass().getResource("/iliadmanifestcreator/res/cross.png")));
            bResize = this.lblWarningIcon.isVisible();
            this.lblImageExampleNote.setVisible(false);
        }
        if (bResize) {
            this.pnlManifest.invalidate();
            this.invalidate();
            this.pack();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.pack();
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(1);
                File file = (File)((List)tr.getTransferData(DataFlavor.javaFileListFlavor)).get(0);
                if (file != null) {
                    if (dtde.getSource() == this.dtSource) {
                        this.setSource(file.getAbsolutePath());
                    } else if (dtde.getSource() == this.dtImage) {
                        this.setImage(file.getAbsolutePath());
                    }
                }
                dtde.dropComplete(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }
}

