#!/usr/bin/perl

# html2imp.pl v0.1 - Copyright (C) 2009 Nick Rapallo (nrapallo)
#
# Requires eBook Publisher installed (for .imp/.rb/.opf)
#    http://www.ebooktechnologies.com/support_publisher_download.htm
#
#######################################################################
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#######################################################################

use Getopt::Mixed;
use Win32::OLE;
use Win32::OLE qw(EVENTS);
Win32::OLE->Initialize(Win32::OLE::COINIT_APARTMENTTHREADED);

my $h2iversion  = "version 0.1";

use vars qw ($opt_a $opt_author $opt_t $opt_title $opt_c $opt_category
	$opt_1200 $opt_1150 $opt_1100);

Getopt::Mixed::getOptions ("a=s author>a t=s title>t c=s category>c
	1200 1150 1100 epub");

my ($htmlfile) = @ARGV;

print "Html2IMP ($h2iversion) Copyright (C) 2009 Nick Rapallo (nrapallo)\n";

$usage='Html2imp.pl -a Authorname -t Title -c Category htmlfilename';
die "Usage: $htmlfile $usage\n" if $#ARGV != 0;

###################################################################
#
# get the interfaces, complain and quit if we cannot
#
$project = Win32::OLE->new("SBPublisher.Project") or
	die "Unable to get IProject interface. Please install eBook Publisher.\n";

$builder = Win32::OLE->new("SBPublisher.Builder") or
	die "Unable to get IBuilder interface. Please re-install eBook Publisher.\n";

# Setup the event handling.
#
Win32::OLE->WithEvents($builder, 'EventHandlers');

###################################################################
#
# Create a new project and add our document file with optional cover.
#
$project->ClearAll();
#$project->AddSourceFile("cover_nr.htm");
$project->AddSourceFile($htmlfile);
 

###################################################################
#
# Set the various "metadata" items for the publication
#
$project->{AuthorFirstName} = $opt_a;
$project->{BookTitle}       = $opt_t;
$project->{Category}        = $opt_c;
$project->{Publisher}       = "GuteBook by nrapallo";
#$project->{ISBN} = $project->CanonicalizeISBN("0448163004 ");
#$project->{BISAC} = "FIC004000";

###################################################################
#
# Now build the OEBFF output
#
$project->{OutputDirectory} = ".";
$project->{Compress}        = 1;   #True
$project->{Encrypt}         = 0;   #False
$project->{KeepAnchors}     = 1;   #True
$project->{Language}        = "en";
$project->{RequireISBN}     = 0;   #False
$project->{Zoom}            = 2;
$project->{BookFileName}    = $opt_a . " - " . $opt_t;

$project->Save($opt_a . " - " . $opt_t . ".opf");

###################################################################
#
# Now build the EBW/GEB 1150 (gray HalfVga) .IMP output
#
if ($opt_1150)
{
	$project->{BookFileName}    = $opt_a . " - " . $opt_t;
	$project->Save($opt_a . " - " . $opt_t . ".opf");

	$project->{BuildTarget} = 2;

	# Now generate both the OEBFF and/or .IMP output
	#$builder->GenerateOEBFF($project, 1);
	$builder->Build($project);
	if (Win32::OLE->LastError() != 0)
	{
		print "ERROR: Build method failed for EBW 1150.\n";
	}
	else
	{
		print "EBW 1150 ebook created!\n";
	}
}

###################################################################
#
# Now build the REB 1100 (mono HalfVGA) .RB output
#
if ($opt_1100) {
	$project->{BookFileName}    = $opt_a . " - " . $opt_t;
	$project->Save($opt_a . " - " . $opt_t . ".opf");

	$project->{BuildTarget} = 3;

	# Now generate the .RB output
	$builder->Build($project);
	if (Win32::OLE->LastError() != 0)
	{
		print "ERROR: Build method failed for REB 1100.\n";
	}
	else
	{
		print "REB 1100 ebook created!\n";
	}
}

###################################################################
#
# Now build the REB 1200 (FullVga) .IMP output
if ($opt_1200)
{
	$project->{BookFileName}    = $opt_a . " - " . $opt_t . "_1200";
	$project->Save($opt_a . " - " . $opt_t . "_1200.opf");

	$project->{BuildTarget}     = 1;

	# Now generate both the OEBFF and/or .IMP output
	#$builder->GenerateOEBFF($project, 1);
	$builder->Build($project);
	if (Win32::OLE->LastError() != 0)
	{
		print "ERROR: Build method failed for REB 1200.\n";
	}
	else
	{
		print "REB 1200 ebook created!\n";
	}
}

Win32::OLE->Uninitialize();
print "All Done!\n";


#not yet implemented	
sub create_cover_htm {     
    if ($coverimageid < 0)
    {   
        return 0;
    }
    else
    {
        my $coverimagefilename = $image_index_to_filename{$coverimageid+1};

        open TEMPFILE, ">$outdir/cover_nr.htm" or die "Cannot create cover.htm file";
        binmode (TEMPFILE);

        my $coverhtm = "<HTML><HEAD><STYLE type=\"text/css\">p {text-indent:0em; margin-left:2px; margin-right:2px}</STYLE></HEAD>\n<BODY>\n";
        $coverhtml .= "<p align=center><center><img src=\"$coverimagefilename\"></center></p>\n</body>\n</html>\n";

        print TEMPFILE $coverhtm;
        close TEMPFILE;
        print "Adding cover image: '$outdir/$coverimagefilename'\n";
        return 1;
    }
}

###################################################################
#
# Event Handlers
#
package EventHandlers;

sub OnBuildStart()
{
	my ($builder, $project, @args) = @_;
#	print "Beginning validation...\n";
}

sub OnSourceStart()
{
	my ($builder, $filename, @args) = @_;
#	if ( $filename ne "") { print "Parsing $filename...\n"; }
}

sub OnError()
{
	# Get the arguments
	my ($builder,
		$filename, 
		$msg, 
		$line, 
		$col, 
		$severity, 
		@args) = @_;

	my @severities = ("NOTE", "FATAL ERROR", "ERROR", "WARNING");

	if ($filename =~ m/^.+[\\|\/](.+?)$/) { $filename = $1; }

	# Print out the error message including any NOTE feedback.
	# if ($severity >= 0)
	# To ignore Warnings, change below to: if ($severity < 3)
	if (!$severity)
	{
		printf(" %-15s (L:%6d, C:%6d) %-7s:",
			$filename,
			$line,
			$col,
			$severities[$severity]);

		print " $msg\n";
	}
}