; Copyright (c) 2009 Nick Rapallo - May 2009
; Copyright (c) 2007 Ashish Kulkarni
;
; Permission is hereby granted, free of charge, to any person obtaining a
; copy of this software and associated documentation files (the "Software"),
; to deal in the Software without restriction, including without limitation
; the rights to use, copy, modify, merge, publish, distribute, sublicense,
; and/or sell copies of the Software, and to permit persons to whom the
; Software is furnished to do so, subject to the following conditions:

; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.

; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
; DEALINGS IN THE SOFTWARE.

!include "MUI.nsh"

;--------------------------------
;General

!define VERSION 0.5
!define GUI "GuteBook GUI ${VERSION}"
Name    "${GUI}"
OutFile "..\GuteBook-gui.exe"
InstallButtonText "Convert"
AutoCloseWindow true
BrandingText "${GUI}"
Caption "${GUI}"
MiscButtonText '<  Back' 'Convert'

;--------------------------------
;Pages

Page custom GetParams
Page custom GetCustomParams

!insertmacro MUI_PAGE_INSTFILES
  
!insertmacro MUI_LANGUAGE "English"

ReserveFile "GuteBook1-gui.ini"
ReserveFile "GuteBook2-gui.ini"
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

;--------------------------------
;Variables
Var F4
Var F5
Var F6
Var F8
Var F10
Var F12
Var F14
Var F15
Var F16
Var F17
Var F18
Var F19
Var F20
Var F21
Var F22
Var F23
Var F24
Var F25
Var F26
Var F27
Var F28
Var F29
Var F30
Var F31
Var F32
Var F33
Var F34
Var F35
Var F36
Var F38
Var F40
Var F41
Var F42

;--------------------------------
;Installer Sections

Section "Main Section"
  ReadIniStr $R2 "$EXEDIR\GuteBook2.ini" "config" "commandline"
  Exec '"$EXEDIR\gutebook-run.cmd" $R2'
SectionEnd

!macro LoadParam num
  ReadIniStr $F${num} "$EXEDIR\GuteBook1.ini"  "Field ${num}"  "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "GuteBook1-gui.ini" "Field ${num}"  "State" $F${num}
!macroend

!macro LoadCustomParam num
  ReadIniStr $F${num} "$EXEDIR\GuteBook2.ini"  "Field ${num}"  "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "GuteBook2-gui.ini" "Field ${num}"  "State" $F${num}
!macroend

!macro OptionalParam num param
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "GuteBook1-gui.ini" "Field ${num}" "State"
  StrCmp $R9 "" +2
  StrCpy $R2 '$R2 ${param} "$R9"'
!macroend

!macro OptionalCustomParam num param
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "GuteBook2-gui.ini" "Field ${num}" "State"
  StrCmp $R9 "" +2
  StrCpy $R2 '$R2 ${param} "$R9"'
!macroend

!macro DefaultParam num param def
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "GuteBook1-gui.ini" "Field ${num}" "State"
  StrCmp $R9 "" +3
  StrCmp $R9 "${def}" +2
  StrCpy $R2 '$R2 ${param} "$R9"'
!macroend

!macro DefaultCustomParam num param def
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "GuteBook2-gui.ini" "Field ${num}" "State"
  StrCmp $R9 "" +3
  StrCmp $R9 "${def}" +2
  StrCpy $R2 '$R2 ${param} "$R9"'
!macroend

!macro Flag num name
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "GuteBook1-gui.ini" "Field ${num}" "State"
  WriteIniStr "$EXEDIR\GuteBook1.ini" "Field ${num}" "State" $R9
  IntCmpU $R9 0 +2
  StrCpy $R2 '$R2 ${name}'
!macroend

!macro FlagCustom num name
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "GuteBook2-gui.ini" "Field ${num}" "State"
  WriteIniStr "$EXEDIR\GuteBook2.ini" "Field ${num}" "State" $R9
  IntCmpU $R9 0 +2
  StrCpy $R2 '$R2 ${name}'
!macroend

!macro Tip num tooltip
  FindWindow $3 "#32770" "" $HWNDPARENT
  IntOp $5 1199 + ${num}
  GetDlgItem $1 $3 $5
  ToolTips::Modern $1 0 "" "${tooltip}"
!macroend

;--------------------------------
;Installer Functions

Function .onInit
  IfFileExists "$EXEDIR\GuteBook1.ini" skip 0
  WriteIniStr "$EXEDIR\GuteBook1.ini" "Field 31" "State" "1"
  !insertmacro LoadParam 31

skip:
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "GuteBook1-gui.ini"

  ReadIniStr $F4 "$EXEDIR\GuteBook1.ini"  "Field 10"  "State"
  StrCmp $F4 "" nooptfile
  
  !insertmacro LoadParam 5
  !insertmacro LoadParam 8
  !insertmacro LoadParam 10
  !insertmacro LoadParam 12
  !insertmacro LoadParam 14
  !insertmacro LoadParam 16
  !insertmacro LoadParam 17
  !insertmacro LoadParam 18
  !insertmacro LoadParam 19
  !insertmacro LoadParam 20
  !insertmacro LoadParam 21
  !insertmacro LoadParam 22
  !insertmacro LoadParam 23
  !insertmacro LoadParam 24
  !insertmacro LoadParam 25
  !insertmacro LoadParam 26
  !insertmacro LoadParam 27
  !insertmacro LoadParam 28
  !insertmacro LoadParam 29
  !insertmacro LoadParam 31

  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "GuteBook2-gui.ini"

  ReadIniStr $F4 "$EXEDIR\GuteBook2.ini"  "Field 4"  "State"
  StrCmp $F4 "" nooptfile
  
  !insertmacro LoadCustomParam 4
  !insertmacro LoadCustomParam 6
  !insertmacro LoadCustomParam 8
  !insertmacro LoadCustomParam 10
  !insertmacro LoadCustomParam 12
  !insertmacro LoadCustomParam 14
  !insertmacro LoadCustomParam 15
  !insertmacro LoadCustomParam 16
  !insertmacro LoadCustomParam 17
  !insertmacro LoadCustomParam 18
  !insertmacro LoadCustomParam 19
  !insertmacro LoadCustomParam 20
  !insertmacro LoadCustomParam 21
  !insertmacro LoadCustomParam 22
  !insertmacro LoadCustomParam 23
  !insertmacro LoadCustomParam 24
  !insertmacro LoadCustomParam 25
  !insertmacro LoadCustomParam 26
  !insertmacro LoadCustomParam 27
  !insertmacro LoadCustomParam 28
  !insertmacro LoadCustomParam 29
  !insertmacro LoadCustomParam 30
  !insertmacro LoadCustomParam 31
  !insertmacro LoadCustomParam 32
  !insertmacro LoadCustomParam 33
  !insertmacro LoadCustomParam 34
  !insertmacro LoadCustomParam 35
  !insertmacro LoadCustomParam 36
  !insertmacro LoadCustomParam 38
  !insertmacro LoadCustomParam 40
  !insertmacro LoadCustomParam 41
  !insertmacro LoadCustomParam 42

nooptfile:
  Call GetParameters
  Pop  $R0
  StrCmp $R0 "" options
  IfFileExists $R0 0 options
  !insertmacro MUI_INSTALLOPTIONS_WRITE "GuteBook1-gui.ini" "Field 5" "State" $R0
options:

FunctionEnd

Function GetParams
  !insertmacro MUI_HEADER_TEXT "${GUI}" "Please enter the conversion details."
  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "GuteBook1-gui.ini"

  ; tooltips
  !insertmacro Tip 2  "Enter the PG EText-No. for the HTML ebook you want to convert."
  !insertmacro Tip 3  "This is the http/local source file that you want to convert."
  !insertmacro Tip 7  "Browse to output conversion location."
  !insertmacro Tip 8  "Title of the generated eBook usually extracted from the source file."
  !insertmacro Tip 9  "Author of the generated eBook usually extracted from the source file."
  !insertmacro Tip 10 "Category of the generated eBook usually unspecified; Default is PG."
  !insertmacro Tip 11 "Create the Sony .epub version using calibre."
  !insertmacro Tip 12 "Create the Sony .lrf version using calibre."
  !insertmacro Tip 13 "Create the Mobipocket .mobi version using calibre."
  !insertmacro Tip 14 "Create the Microsoft .lit version using calibre."
  !insertmacro Tip 15 "Create a Source .epub version using calibre."
  !insertmacro Tip 16 "Create the REB1200 .imp version using eBook Publisher."
  !insertmacro Tip 17 "Create the EBE1150 .imp version using eBook Publisher."
  !insertmacro Tip 18 "Create the REB1100 .rp version using eBook Publisher."
  !insertmacro Tip 19 "Reserved for ereader .pdb."
  !insertmacro Tip 20 "Reserved for html/images in .zip."
  !insertmacro Tip 21 "Keep the Project Gutenberg .htm extracted from downloaded file."
  !insertmacro Tip 22 "Keep the Project Gutenberg .zip downloaded as a loca/cached copy."
  !insertmacro Tip 23 "Convert .txt to .htm internally using GutenMark; no other options available."
  !insertmacro Tip 24 "Created by Nick Rapallo (nrapallo at www.MobileRead.com)."
  !insertmacro Tip 25 "Select this to see More HTML Options/Fixes/Filters."

  StrCpy $R2 ' '

  !insertmacro MUI_INSTALLOPTIONS_READ $R3 "GuteBook1-gui.ini" "Field 5" "State"
  !insertmacro MUI_INSTALLOPTIONS_READ $R4 "GuteBook1-gui.ini" "Field 8" "State"
  
  StrCmp $R3 "" no_etext
  StrCmp $R4 "" no_file
  StrCpy $R2 '$R2 --PGnum $R3 "$R4"'
  Goto more_params
no_etext:
  StrCpy $R2 '$R2 "$R4"'
  Goto more_params
no_file:
  StrCpy $R2 '$R2 $R3'
more_params:

  !insertmacro DefaultParam 10 '--outdir' 'Default'
  WriteIniStr "$EXEDIR\GuteBook1.ini" "Field 10" "State" $R9

  !insertmacro DefaultParam 12 '--title' 'Extracted'
  WriteIniStr "$EXEDIR\GuteBook1.ini" "Field 12" "State" $R9
  
  !insertmacro DefaultParam 14 '--author' 'Extracted'
  WriteIniStr "$EXEDIR\GuteBook1.ini" "Field 14" "State" $R9

  !insertmacro DefaultParam 16 '--category' 'Extracted'
  WriteIniStr "$EXEDIR\GuteBook1.ini" "Field 16" "State" $R9

  !insertmacro Flag 17 '--epub'
  !insertmacro Flag 18 '--lrf'
  !insertmacro Flag 19 '--mobi'
  !insertmacro Flag 20 '--lit'
  !insertmacro Flag 21 '--srcepub'
  !insertmacro Flag 22 '--1200'
  !insertmacro Flag 23 '--1150'
  !insertmacro Flag 24 '--1100'
  !insertmacro Flag 25 '--pdb'
  !insertmacro Flag 26 '--zip'
  !insertmacro Flag 27 '--keephtm'
  !insertmacro Flag 28 '--keepzip'
  !insertmacro Flag 29 '--usegm'
  
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "GuteBook1-gui.ini" "Field 31" "State"
  WriteIniStr "$EXEDIR\GuteBook1.ini" "Field 31" "State" $R9

  WriteIniStr "$EXEDIR\GuteBook1.ini" "config" "commandline" $R2
FunctionEnd

Function GetCustomParams

  ReadIniStr $R0 "$EXEDIR\GuteBook1.ini" "Field 31" "State"
  IntCmp $R0 0 skip_custom
  
  !insertmacro MUI_HEADER_TEXT "${GUI}" "Please enter the custom parameters."
  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "GuteBook2-gui.ini"

    ; tooltips
  !insertmacro Tip 4 "Use left-right margins of 2px,0 instead of default 2%."
  !insertmacro Tip 5 "Set small (2em) indent or no (0em) indent. Useful when select 'nopara' option."
  !insertmacro Tip 6 "Fix the <pre> tag by adding a suffix that displays/works better."
  !insertmacro Tip 7 "Fix the </pre> tag by prepending a prefix; in reserve order of <pre> fix."
  !insertmacro Tip 8 "Enter up to 2 HTML tags (separated b a space) that will force pagebreaks."
  !insertmacro Tip 9 "Reserved tag."
  !insertmacro Tip 11 "Printout more detailed messages about conversion."
  !insertmacro Tip 12 "Printout debug information about this conversion."
  !insertmacro Tip 13 "Do not 'justify' body text (i.e. left-aligned; no full justification)."
  !insertmacro Tip 14 "Do not use 'blank line' (1em) paragraph separation (i.e no paragraph separation)."
  !insertmacro Tip 15 "don't 'fix' images; default is to re-save images for better compatibility."
  !insertmacro Tip 16 "Add cover image page using the (first) extracted cover images embedded in source file."
  !insertmacro Tip 17 "Place a pagebreak CSS tag within anchors (for .mobi)."
  !insertmacro Tip 18 "Do not allow pagebreak on first pagebreak tag encountered."
  !insertmacro Tip 19 "Force a pagebreak on the firt <h1> encountered."
  !insertmacro Tip 20 "Place a pagebreak CSS tag just before the Table of Contents ('TOC')."
  !insertmacro Tip 21 "Don't place the PG ebook details on last (pagebroken) page."
  !insertmacro Tip 22 "Force all heading/chapter <h1> to <h6> tags to be centered."
  !insertmacro Tip 23 "Strip all extranneous entitites within the <img> tag leaving just the 'src='."
  !insertmacro Tip 24 "Keep the PG preamble (header) at the start of the source file; default is to strip it."
  !insertmacro Tip 25 "Keep the PG legales (footer) at the end of the source file; default is to strip it."
  !insertmacro Tip 26 "Keep the Page Numbers (displayable) throughtout; default is to leave in their href's."
  !insertmacro Tip 27 "Do not add the 'toc' anchor name; default is to add it (for .mobi/.imp)."
  !insertmacro Tip 28 "Not yet functional - Create a TOC and place it near beginning of the source file."
  !insertmacro Tip 29 "Not yet functional - Create a TOC and place at the end of the source file."
  !insertmacro Tip 30 "Use a one pt smaller font size for body text than the default font size."
  !insertmacro Tip 31 "Use a one pt larger font size for body text than the default font size."
  !insertmacro Tip 32 "Enter custom (Perl) RegEx expression to search for; done as the last substitution."
  !insertmacro Tip 33 "Enter custom (Perl) RegEx expression to replace with; done as the last substitution."
  !insertmacro Tip 34 "Indicate that the custom (Perl) RegEx search is case insensitive."
  !insertmacro Tip 35 "indicate that the custom (Perl) RegEx search is done gobally."
  
  !insertmacro MUI_INSTALLOPTIONS_SHOW
  StrCmp $MUI_TEMP1 "cancel" finish
  
  !insertmacro DefaultCustomParam 4 '--LRmargins' '2%'
  WriteIniStr "$EXEDIR\GuteBook2.ini" "Field 4" "State" $R9   

  !insertmacro DefaultCustomParam 6 '--indent' '2em'
  WriteIniStr "$EXEDIR\GuteBook2.ini" "Field 6" "State" $R9   

  !insertmacro DefaultCustomParam 8 '--fixpre1' '<small><tt>'
  WriteIniStr "$EXEDIR\GuteBook2.ini" "Field 8" "State" $R9

  !insertmacro DefaultCustomParam 10 '--fixpre2' '</tt></small>'
  WriteIniStr "$EXEDIR\GuteBook2.ini" "Field 10" "State" $R9

  !insertmacro DefaultCustomParam 12 '--pb' 'h2'
  WriteIniStr "$EXEDIR\GuteBook2.ini" "Field 12" "State" $R9

  !insertmacro FlagCustom 15 '--nobatch'
  !insertmacro FlagCustom 16 '--verbose'
  !insertmacro FlagCustom 17 '--debug'
  !insertmacro FlagCustom 18 '--nojustify'
  !insertmacro FlagCustom 19 '--nopara'
  !insertmacro FlagCustom 20 '--noimagefix'
  !insertmacro FlagCustom 21 '--cover'
  !insertmacro FlagCustom 22 '--pbwithin'
  !insertmacro FlagCustom 23 '--pbnofirst'
  !insertmacro FlagCustom 24 '--pbfirsth1'
  !insertmacro FlagCustom 25 '--pbtoc'
  !insertmacro FlagCustom 26 '--noPGtrailer'
  !insertmacro FlagCustom 27 '--centerh'
  !insertmacro FlagCustom 28 '--imgsrc'
  !insertmacro FlagCustom 29 '--PGheader'
  !insertmacro FlagCustom 30 '--PGfooter'
  !insertmacro FlagCustom 31 '--PGpagenum'
  !insertmacro FlagCustom 32 '--tocname'
  !insertmacro FlagCustom 33 '--addtoc'
  !insertmacro FlagCustom 34 '--addtocend'
  !insertmacro FlagCustom 35 '--smallerfont'
  !insertmacro FlagCustom 36 '--largerfont'
  
  !insertmacro DefaultCustomParam 38 '--search' ''
  WriteIniStr "$EXEDIR\GuteBook2.ini" "Field 38" "State" $R9

  !insertmacro DefaultCustomParam 40 '--replace' ''
  WriteIniStr "$EXEDIR\GuteBook2.ini" "Field 40" "State" $R9

  !insertmacro FlagCustom 41 '--modi'
  !insertmacro FlagCustom 42 '--modg'
  
  IfFileExists "$EXEDIR\GuteBook2.ini" 0 display
display:

skip_custom:
  WriteIniStr "$EXEDIR\GuteBook2.ini" "config" "commandline" $R2

finish:

FunctionEnd

Function GetParameters
 
  Push $R0
  Push $R1
  Push $R2
  Push $R3
  
  StrCpy $R2 1
  StrLen $R3 $CMDLINE
  
  ;Check for quote or space
  StrCpy $R0 $CMDLINE $R2
  StrCmp $R0 '"' 0 +3
    StrCpy $R1 '"'
    Goto loop
  StrCpy $R1 " "
  
  loop:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 $R1 get
    StrCmp $R2 $R3 get
    Goto loop
  
  get:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 " " get
    StrCpy $R0 $CMDLINE "" $R2
  
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0
 
FunctionEnd