﻿Imports System.Collections.ObjectModel

Public Class MainForm

    Private EBProj As New SBPUBXLib.Project
    Private WithEvents EBBuild As New SBPUBXLib.Builder
    Dim SplitPathArray(4) As String
    Dim SourceFileFullPathName, SourceDirName, SourceFileFullName, SourceFileNameNoExt, SourceFileExt As String
    Dim BuildTarget As Integer
    Dim ImpFile As String
    Dim Categories As ComboBox.ObjectCollection

    Private Sub ConvertButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ConvertButton.Click
        My.Settings.LastCategory = Category_ComboBox.Text
        My.Settings.Save()
        ConvertButton.Enabled = False
        ProgressBar1.Visible = True
        EBBuild.TargetDevice = My.Settings.LastBuildTarget
        Select Case SourceFileExt
            Case "doc", "rtf"
                MessagesLabel.Text = "Converting .doc/.rtf ... Please wait"
                Me.Update()
                EBBuild.BuildFromWordDoc(SourceFileFullPathName, SourceFileNameNoExt)
            Case "htm", "html"
                MessagesLabel.Text = "Converting .html ... Please wait"
                Me.Update()
                EBBuild.BuildFromHTMLFile(SourceFileFullPathName)
            Case "txt"
                MessagesLabel.Text = "Converting .txt ... Please wait"
                Me.Update()
                EBBuild.BuildFromTextFile(SourceFileFullPathName, SourceFileNameNoExt)
            Case "pps", "ppt"
                MessagesLabel.Text = "Converting .pps/.ppt ... Please wait"
                Me.Update()
                EBBuild.BuildFromPowerPoint(SourceFileFullPathName, SourceFileNameNoExt)
            Case "opf"
                MessagesLabel.Text = "Converting .opf ... Please wait"
                Me.Update()
                EBBuild.BuildFromProject(SourceFileFullPathName)
        End Select
        MessagesLabel.Text = "Conversion completed"
        ConvertButton.Enabled = True
        ProgressBar1.Visible = False
    End Sub

    Private Sub EBBuild_OnBuildStart(ByVal pInfo As SBPUBXLib.IProject) Handles EBBuild.OnBuildStart
        Dim NumSource As Integer
        Dim TempFileFullPathName, TempDirName, TempFileFullName, TempFileNoExt, TempFileExt As String
        pInfo.AuthorFirstName = AuthorTextBox.Text
        pInfo.AuthorLastName = ""
        pInfo.AuthorMiddleName = ""
        pInfo.BookFileName = SourceFileNameNoExt
        pInfo.BookID = ""
        pInfo.BookTitle = TitleTextBox.Text
        pInfo.CSS = 2
        pInfo.Category = Category_ComboBox.Text
        pInfo.Compress = 1                          'True
        pInfo.ContentFeedID = ""
        pInfo.CurrentIssue = ""
        pInfo.DeleteFallbacks = 0
        pInfo.Encrypt = 0                          'False
        pInfo.ErrorDirectory = ""
        pInfo.ErrorFeedback = 0
        pInfo.HasChanged = 0
        pInfo.Implode = 1
        pInfo.IsPeriodical = 0
        pInfo.OrphanLines = 0
        pInfo.OutputDirectory = "."
        pInfo.ProjectFile = ""
        pInfo.SubCategory = ""
        pInfo.UnderlineLinks = 1
        pInfo.WidowLines = 0
        pInfo.Zoom = 2
        NumSource = pInfo.NumSourceFiles    'should be 1
        TempFileFullPathName = pInfo.SourceFile(NumSource - 1)  'should be 0
        SplitPath(TempFileFullPathName)
        TempDirName = SplitPathArray(1)
        TempFileFullName = SplitPathArray(2)
        TempFileNoExt = SplitPathArray(3)
        TempFileExt = SplitPathArray(4)
        If SourceFileExt <> "htm" Or SourceFileExt <> "html" Or SourceFileExt <> "opf" Then
            Try
                My.Computer.FileSystem.CopyFile(TempFileFullPathName, SourceDirName + TempFileFullName)
            Catch e As Exception
                MessageBox.Show(e.Message)
            End Try
        End If
        If SourceFileExt = "doc" Or SourceFileExt = "rtf" Then
            Try
                My.Computer.FileSystem.CopyDirectory(TempDirName + "images", SourceDirName + "images")
            Catch e As Exception
                MessageBox.Show(e.Message)
            End Try
        End If
        If SourceFileExt = "ppt" Or SourceFileExt = "pps" Then
            Try
                For Each FoundFile As String In My.Computer.FileSystem.GetFiles(TempDirName, FileIO.SearchOption.SearchTopLevelOnly, "Slide*.jpg")
                    SplitPath(FoundFile)
                    My.Computer.FileSystem.CopyFile(FoundFile, SourceDirName + SplitPathArray(2))
                Next
            Catch e As Exception
                MessageBox.Show(e.Message)
            End Try
        End If
        Try
            Dim bt As String
            bt = Str$(BuildTarget)
            pInfo.Save(SourceDirName + SourceFileNameNoExt + "_" + bt + ".opf")
        Catch e As Exception
            MessageBox.Show(e.Message)
        End Try
        MessagesLabel.Text = "Project file saved"
        Me.Update()
    End Sub

    Private Function SplitPath(ByVal OpenedFile As String) As Array
        Dim TestPoz As Integer
        Dim TempString As String
        TempString = LCase(OpenedFile)
        SplitPathArray(0) = TempString
        TestPoz = InStrRev(TempString, "\")
        SplitPathArray(1) = Mid(TempString, 1, TestPoz)
        SplitPathArray(2) = Mid(TempString, TestPoz + 1, Len(TempString))
        TestPoz = InStrRev(SplitPathArray(2), ".")
        SplitPathArray(3) = Mid(SplitPathArray(2), 1, TestPoz - 1)
        SplitPathArray(4) = Mid(SplitPathArray(2), TestPoz + 1, Len(SplitPathArray(2)))
        Return SplitPathArray
    End Function

    Private Sub ETIRadioButton_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ETIRadioButton.CheckedChanged
        If ETIRadioButton.Checked = True Then
            BuildTarget = 0
            My.Settings.LastBuildTarget = BuildTarget
            My.Settings.Save()
        End If
    End Sub

    Private Sub REB1200RadioButton_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles REB1200RadioButton.CheckedChanged
        If REB1200RadioButton.Checked = True Then
            BuildTarget = 1
            My.Settings.LastBuildTarget = BuildTarget
            My.Settings.Save()
        End If
    End Sub

    Private Sub EBW1150RadioButton_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles EBW1150RadioButton.CheckedChanged
        If EBW1150RadioButton.Checked = True Then
            BuildTarget = 2
            My.Settings.LastBuildTarget = BuildTarget
            My.Settings.Save()
        End If
    End Sub

    Private Sub REB1100RadioButton_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles REB1100RadioButton.CheckedChanged
        If REB1100RadioButton.Checked = True Then
            BuildTarget = 3
            My.Settings.LastBuildTarget = BuildTarget
            My.Settings.Save()
        End If
    End Sub

    Private Sub EBBuild_OnLayoutFeedback(ByVal msg As String) Handles EBBuild.OnLayoutFeedback
        MessagesLabel.Text = msg
        Me.Update()
    End Sub

    Private Sub EBBuild_OnParserFeedback(ByVal cur_byte As Integer, ByVal tot_bytes As Integer) Handles EBBuild.OnParserFeedback
        ProgressBar1.Maximum = tot_bytes
        ProgressBar1.Step = 1024
        ProgressBar1.PerformStep()
        Me.Update()
    End Sub

    Private Sub MainForm_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Select Case My.Settings.LastBuildTarget
            Case 0
                ETIRadioButton.Checked = True
            Case 1
                REB1200RadioButton.Checked = True
            Case 2
                EBW1150RadioButton.Checked = True
            Case 3
                REB1100RadioButton.Checked = True
        End Select
        ConvertButton.Enabled = False
        ProgressBar1.Visible = False
        Dim strings(My.Settings.Categories.Count - 1) As String
        My.Settings.Categories.CopyTo(strings, 0)
        Category_ComboBox.Items.AddRange(strings)
        Category_ComboBox.Text = My.Settings.LastCategory
    End Sub

    Private Sub OpenToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles OpenToolStripMenuItem.Click
        If My.Settings.LastDirectory = "" Then
            OpenFileDialog1.InitialDirectory = My.Computer.FileSystem.SpecialDirectories.MyDocuments
        Else
            OpenFileDialog1.InitialDirectory = My.Settings.LastDirectory
        End If
        OpenFileDialog1.Filter = "MS Word .doc files|*.doc|MS Word .rtf files|*.rtf|MS PPT .ppt files|*.pp*|HTML .htm files|*.htm*|TEXT .txt files|*.txt|OPF .opf files|*.opf|All Files|*.*"
        'OpenFileDialog1.FilterIndex = 2
        If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
            SourceFileFullPathName = OpenFileDialog1.FileName
            SplitPath(SourceFileFullPathName)
            SourceDirName = SplitPathArray(1)
            SourceFileFullName = SplitPathArray(2)
            SourceFileNameNoExt = SplitPathArray(3)
            SourceFileExt = SplitPathArray(4)
            ToolTip1.SetToolTip(MessagesLabel, SourceFileFullPathName)
            My.Settings.LastDirectory = SourceDirName
            My.Settings.Save()
            MessagesLabel.Text = SourceFileFullPathName
            ConvertButton.Enabled = True
        End If
    End Sub

    Private Sub ExitToolStripMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class

