#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'
'''
en.wikipedia.org
'''

class Wikipedia(BasicNewsRecipe):
    title                 = 'Wikipedia'
    __author__            = 'Darko Miletic'
    description           = 'Wikipedia articles'
    category              = 'data, world'
    oldest_article        = 7
    max_articles_per_feed = 100
    publisher             = 'Wiki'
    no_stylesheets        = True
    use_embedded_content  = False
    encoding              = 'utf-8'
    remove_javascript     = True
    language              = _('English')
    INDEX                 = 'http://en.wikipedia.org/'
    
    html2lrf_options = [
                          '--comment', description
                        , '--category', category
                        , '--publisher', publisher
                        ]
    
    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"' 

    keep_only_tags = [ 
                        dict(name='h1', attrs={'id':'firstHeading'}) 
                       ,dict(name='div', attrs={'id':'bodyContent'}) 
                     ]
    
    remove_tags = [
                    dict(name=['link','sup'])
                   ,dict(name='div',attrs={'id':['printfooter','catlinks','footer']})
                   ,dict(name='div',attrs={'class':['thumb left','thumb right']})
                  ]

    def parse_index(self):
        articles = []
        articles.append({
                         'title':'Tree',
                         'date':'',
                         'url':self.INDEX + 'wiki/Tree',
                         'description':'Tree'
                        })
         
        return [('Articles', articles)]
        
    def print_version(self, url):
        rest, sep, article_id  = url.rpartition('/')
        return self.INDEX + 'w/index.php?title=' + article_id + '&printable=yes'

        