/*
 * ScribbleStroke.java
 *
 * Created on 13 januari 2007, 23:33
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package iliadpdfscribblemerger;

import com.lowagie.text.Rectangle;
import java.awt.Color;
import java.util.HashMap;
import org.w3c.dom.Element;
import com.lowagie.text.pdf.PdfContentByte;

/**
 *
 * @author Bert
 */
public class ScribbleStroke {
    //constants
    public static final float SCALE_FACTOR = 35.0f;
    public static final float PEN_SCALE_FACTOR = 0.02f;
    //attributes
    String strColor;
    int nLayer;
    int nPenSize;
    String strLineStyle;
    float fZoom;
    int[][] nStrokes;
    
    /** Creates a new instance of ScribbleStroke */
    public ScribbleStroke(Element elStroke) {
        strColor = elStroke.getAttribute("color");
        nLayer = Integer.parseInt(elStroke.getAttribute("layer"));
        nPenSize = Integer.parseInt(elStroke.getAttribute("penSize"));
        strLineStyle = elStroke.getAttribute("linestyle");
        fZoom = Float.parseFloat(elStroke.getAttribute("zoom"));
        String strValue = elStroke.getChildNodes().item(0).getNodeValue();
        //strokes
        String[] strStrokeLines = strValue.split("\n");
        nStrokes = new int[strStrokeLines.length][3];
        for (int nStrokeLine = 0; nStrokeLine < strStrokeLines.length; nStrokeLine++) {
            String[] strStrokeData = strStrokeLines[nStrokeLine].split(" ");
            if (strStrokeData.length != 3)
                continue;
            nStrokes[nStrokeLine][0] = Integer.parseInt(strStrokeData[0]);
            nStrokes[nStrokeLine][1] = Integer.parseInt(strStrokeData[1]);
            nStrokes[nStrokeLine][2] = Integer.parseInt(strStrokeData[2]);
        }
    }
    
    void DrawStroke(PdfContentByte cb, int nOrientation, float fTop, float fLeft, HashMap mapColors) {
        if (nStrokes.length<2)
            return;

        //set properties
        Color colStroke = null;
        if (mapColors==null || !mapColors.containsKey(strColor))
            colStroke = Color.decode(strColor);
        else
            colStroke = (Color)mapColors.get(strColor);
        cb.setColorStroke(colStroke);
        float fScaleFactor = fZoom / 100;
        cb.setLineWidth( nPenSize / fScaleFactor);
        
        //it seems nOrientation is always 0 (I couldn't get it to be something else)
        //so we ignore it for now.
        
        //create lines
        float x = fLeft + (nStrokes[0][0] / fScaleFactor);
        float y = fTop - (nStrokes[0][1] / fScaleFactor);
        cb.moveTo(x, y);
        for (int nStrokeLine = 1; nStrokeLine<nStrokes.length; nStrokeLine++) {
            x = fLeft + (nStrokes[nStrokeLine][0] / fScaleFactor);
            y = fTop - (nStrokes[nStrokeLine][1] / fScaleFactor);
            cb.lineTo(x, y);
        }
        
        //draw stroke
        cb.stroke();
    }
    
}
