/*
 * Decompiled with CFR 0.152.
 */
package Catalog.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Viewer<T>
implements Cloneable {
    private static final String VERSION = "0.1";
    String suffix;
    String program;
    List<String> args = new ArrayList<String>();

    public void setSuffix(String s) {
        this.suffix = s;
    }

    public void setProgram(String c) {
        this.program = c;
    }

    public void setArgs(List<String> a) {
        this.args = a;
    }

    public void addArg(String a) {
        this.args.add(a);
    }

    public void setArg(int i, String a) {
        this.args.set(i, a);
    }

    public String getArg(int i) {
        if (i < 0 || i >= this.args.size()) {
            return null;
        }
        return this.args.get(i);
    }

    public void remove(int i) {
        if (i < 0 || i > this.args.size()) {
            return;
        }
        this.args.remove(i);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getProgram() {
        return this.program;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String[] getArgsArray() {
        int n = this.args.size();
        if (n == 0) {
            return null;
        }
        String[] sArray = new String[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = this.getArg(i);
        }
        return sArray;
    }

    public int argsSize() {
        return this.args.size();
    }

    public int argc() {
        return this.args.size();
    }

    public String toString() {
        return this.program + ":" + this.suffix;
    }

    public Viewer clone() {
        Viewer<T> v = new Viewer<T>();
        v.setSuffix(new String(this.suffix));
        v.setProgram(new String(this.program));
        for (int i = 0; i < this.args.size(); ++i) {
            v.addArg(new String(this.args.get(i)));
        }
        return v;
    }

    public boolean read(BufferedReader f) {
        try {
            this.suffix = f.readLine().trim();
            this.program = f.readLine().trim();
            String line = f.readLine().trim();
            while (!line.equals("<<<END")) {
                this.args.add(line);
                line = f.readLine().trim();
            }
        }
        catch (Exception e) {
            System.err.println("WARNING: Program corrupt!!!\n" + this);
            return false;
        }
        return true;
    }

    public void write(BufferedWriter f) throws IOException {
        f.write(this.suffix);
        f.newLine();
        f.write(this.program);
        f.newLine();
        for (int i = 0; i < this.args.size(); ++i) {
            f.write(this.args.get(i));
            f.newLine();
        }
        f.write("<<<END");
        f.newLine();
    }
}

