/*
 * Decompiled with CFR 0.152.
 */
package Catalog.util;

import Catalog.Book;
import Catalog.prefs.CatalogPrefs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;

public abstract class LaunchBase {
    private static final String VERSION = "0.2";
    LaunchBase instance = null;
    static String[] tokens = new String[]{"%file", "%path", "%base", "%/", "%author", "%title", "%image", "%description"};
    static String[] methods = new String[]{"getFileName", "getPathName", "getBaseName", "getSeparator", "getAuthor", "getTitle", "getImageName", "getDescription"};
    Runtime runtime = Runtime.getRuntime();
    String outputLog;
    String errorLog;

    public static LaunchBase getInstance() {
        return null;
    }

    public String getFileName(Book book) {
        if (book == null) {
            return null;
        }
        return book.getFileName();
    }

    public String getPathName(Book book) {
        if (book == null) {
            return null;
        }
        String name = book.getFileName();
        if (name == null || name.length() == 0) {
            return null;
        }
        int startPos = name.lastIndexOf(File.separator);
        if (startPos < 0) {
            return "";
        }
        return name.substring(0, startPos);
    }

    public String getBaseName(Book book) {
        if (book == null) {
            return null;
        }
        String name = book.getFileName();
        if (name == null || name.length() == 0) {
            return null;
        }
        int startPos = name.lastIndexOf(File.separator);
        int stopPos = name.lastIndexOf(".");
        if (startPos < 0) {
            startPos = 0;
        }
        if (stopPos < startPos) {
            stopPos = name.length();
        }
        return name.substring(startPos + 1, stopPos);
    }

    public String getSeparator(Book book) {
        return File.separator;
    }

    public String getAuthor(Book book) {
        if (book == null) {
            return null;
        }
        return book.getAuthor();
    }

    public String getTitle(Book book) {
        if (book == null) {
            return null;
        }
        return book.getTitle();
    }

    public String getImageName(Book book) {
        if (book == null) {
            return null;
        }
        return book.getImageName();
    }

    public String getDescription(Book book) {
        if (book == null) {
            return null;
        }
        return book.getDescription();
    }

    String getSuffix(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        int startPos = name.lastIndexOf(".");
        return name.substring(startPos + 1, name.length()).toLowerCase();
    }

    String getSuffix(Book book) {
        if (book == null) {
            return null;
        }
        return this.getSuffix(book.getFileName());
    }

    public boolean hasOutput() {
        return this.outputLog != null;
    }

    public String getOutput() {
        return this.outputLog;
    }

    public boolean hasErrors() {
        return this.errorLog != null;
    }

    public String getErrors() {
        return this.errorLog;
    }

    void execute(String[] cmd) {
        this.outputLog = null;
        this.errorLog = null;
        if (cmd == null || cmd.length < 1) {
            return;
        }
        System.out.println("command:");
        for (int i = 0; i < cmd.length; ++i) {
            System.out.println("\t" + cmd[i]);
        }
        StringBuffer buffer = null;
        try {
            String s;
            buffer = new StringBuffer();
            Process p = this.runtime.exec(cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((s = reader.readLine()) != null) {
                buffer.append(s + "\n");
            }
            reader.close();
            this.outputLog = buffer.toString();
            if (this.outputLog.length() == 0) {
                this.outputLog = null;
            }
            System.out.println(this.outputLog);
            buffer = new StringBuffer();
            reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while (reader.ready()) {
                buffer.append(reader.readLine());
            }
            reader.close();
            this.errorLog = buffer.toString();
            if (this.errorLog.length() == 0) {
                this.errorLog = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String replace(String s, Book book, int i) {
        if (s == null || book == null || i >= methods.length) {
            return null;
        }
        String token = tokens[i];
        String method = methods[i];
        String out = book.getFileName();
        if (method != null) {
            Class<?> c = this.getClass();
            Method m = null;
            try {
                m = c.getMethod(method, Book.class);
            }
            catch (NoSuchMethodException e) {
                System.err.println("method '" + method + "' not found");
                e.printStackTrace();
                return out;
            }
            try {
                out = (String)m.invoke((Object)this, book);
            }
            catch (IllegalAccessException e) {
                System.err.println("\nmethod '" + method + "' called illegally");
            }
            catch (InvocationTargetException e) {
                System.err.println("InvocationTargetException");
            }
            out = s.replace(token, out);
        }
        return out;
    }

    String parse(String arg, Book book) {
        if (arg == null || book == null) {
            return null;
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (!arg.contains(tokens[i])) continue;
            arg = this.replace(arg, book, i);
        }
        return arg;
    }

    void startPrefs() {
        this.startPrefs(-1);
    }

    void startPrefs(int i) {
        CatalogPrefs prefs = CatalogPrefs.getInstance();
        if (i != -1) {
            prefs.selectTab(i);
        }
        prefs.show();
    }

    String getStringChoice(String[] labels, Object[] options) {
        return (String)JOptionPane.showInputDialog(null, labels[0], labels[1], 3, null, options, options[0]);
    }

    boolean getBooleanChoice(String[] labels, Object[] options) {
        return JOptionPane.showOptionDialog(null, labels[4], labels[5], 0, 3, null, options, options[0]) == 0;
    }

    public abstract void launch(Book var1, Object var2);

    public abstract Object findProgram(Book var1);
}

