/*
 * Decompiled with CFR 0.152.
 */
package Catalog.prefs;

import Catalog.util.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BasePrefs
implements ActionListener,
ListSelectionListener,
DropTargetListener {
    private static final String VERSION = "0.4";
    JList list;
    static String lang;
    static ResourceBundle msgs;
    JTextField programText;
    JTextField suffixText;
    JButton newButton;
    JButton argButton;
    JButton delButton;
    JPanel mainPanel;
    JPanel listPanel;
    JPanel actionPanel;
    JPanel inputPanel;
    JPanel adminPanel;
    JPanel buttonPanel;
    String[] labels = new String[]{"Program", "Fileformat", "To", "New", "Arguments", "Delete", "OK", "Cancel", "List", "Title"};

    public void initGUI() {
        String osType = System.getProperty("os.name").toLowerCase();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Oops!");
            e.printStackTrace();
        }
        this.mainPanel = new JPanel(new BorderLayout());
        this.actionPanel = new JPanel(new BorderLayout());
        this.inputPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.adminPanel = new JPanel(new BorderLayout());
        this.listPanel = new JPanel(new BorderLayout());
        this.list = new JList();
        this.list.addListSelectionListener(this);
        this.programText = UIFactory.newTextField(20, "", this.labels[0], this, null);
        this.suffixText = UIFactory.newTextField(20, "", this.labels[1], this, null);
        this.newButton = UIFactory.newButton(this.labels[3], "BT:" + this.labels[3], 'n', this);
        this.argButton = UIFactory.newButton(this.labels[4], "BT:" + this.labels[4], 'a', this);
        this.delButton = UIFactory.newButton(this.labels[5], "BT:" + this.labels[5], 'd', this);
        this.listPanel.setBorder(BorderFactory.createTitledBorder(this.labels[8]));
        this.listPanel.add((Component)new JScrollPane(this.list), "Center");
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 1));
        this.inputPanel.add(UIFactory.addElements(this.labels[0], this.programText));
        this.inputPanel.add(UIFactory.addElements(this.labels[1], this.suffixText));
        this.buttonPanel.add(this.newButton);
        this.buttonPanel.add(this.argButton);
        this.buttonPanel.add(this.delButton);
        this.adminPanel.add((Component)this.buttonPanel, "North");
        this.actionPanel.add((Component)this.inputPanel, "North");
        this.actionPanel.add((Component)this.adminPanel, "South");
        this.mainPanel.add((Component)this.listPanel, "Center");
        this.mainPanel.add((Component)this.actionPanel, "South");
        new DropTarget(this.programText, this);
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public void enableUI(boolean b) {
        this.newButton.setEnabled(b);
        this.argButton.setEnabled(b);
        this.delButton.setEnabled(b);
        this.list.setEnabled(b);
    }

    void setListData(int i) {
    }

    void setListData() {
        this.setListData(this.list.getSelectedIndex());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.newButton) {
            this.newButton.setEnabled(false);
            this.programText.grabFocus();
        } else if (src.equals(this.programText)) {
            this.suffixText.grabFocus();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable tr = null;
        DataFlavor[] flavors = null;
        List fileList = null;
        try {
            tr = e.getTransferable();
            flavors = tr.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                e.acceptDrop(3);
                fileList = (List)tr.getTransferData(flavors[i]);
                e.dropComplete(true);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            e.rejectDrop();
            return;
        }
        String file = "";
        Component src = ((DropTarget)e.getSource()).getComponent();
        if (fileList.size() > 1) {
            System.out.println("Only one file expected and thus accepted");
        }
        File f = (File)fileList.get(0);
        try {
            file = f.getCanonicalPath();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (file == null || file.length() == 0) {
            return;
        }
        this.programText.setText(file);
    }
}

