/*
 * Decompiled with CFR 0.152.
 */
package iliadpdfscribblemerger;

import com.lowagie.text.pdf.PdfContentByte;
import iliadpdfscribblemerger.ScribbleStroke;
import java.awt.Color;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScribblePage {
    Color colBackground;
    int nPageId;
    int nOrientation;
    int nHeight;
    int nWidth;
    ScribbleStroke[] arrStrokes;

    public ScribblePage(Element elPage) {
        String strBgColor = elPage.getAttribute("backgroundcolor");
        this.colBackground = Color.decode(strBgColor);
        String strId = elPage.getAttribute("id");
        this.nPageId = Integer.parseInt(strId);
        NodeList nlstOrientation = elPage.getElementsByTagName("orientation");
        Node nodeOrientation = nlstOrientation.item(0).getChildNodes().item(0);
        this.nOrientation = Integer.parseInt(nodeOrientation.getNodeValue());
        NodeList nlstHeight = elPage.getElementsByTagName("height");
        Node nodeHeight = nlstHeight.item(0).getChildNodes().item(0);
        this.nHeight = Integer.parseInt(nodeHeight.getNodeValue());
        NodeList nlstWidth = elPage.getElementsByTagName("width");
        Node nodeWidth = nlstWidth.item(0).getChildNodes().item(0);
        this.nWidth = Integer.parseInt(nodeWidth.getNodeValue());
        NodeList nlstStrokes = elPage.getElementsByTagName("stroke");
        int nStrokeCount = nlstStrokes.getLength();
        this.arrStrokes = new ScribbleStroke[nStrokeCount];
        for (int nStroke = 0; nStroke < nStrokeCount; ++nStroke) {
            Node nodeStroke = nlstStrokes.item(nStroke);
            if (nodeStroke == null || nodeStroke.getNodeType() != 1) continue;
            Element elStroke = (Element)nodeStroke;
            this.arrStrokes[nStroke] = new ScribbleStroke(elStroke);
        }
    }

    public void AddScribbles(PdfContentByte cb, float fPageTop, float fPageLeft, HashMap mapColors) {
        for (int nStroke = 0; nStroke < this.arrStrokes.length; ++nStroke) {
            this.arrStrokes[nStroke].DrawStroke(cb, this.nOrientation, fPageTop, fPageLeft, mapColors);
        }
    }
}

