/*
 * Decompiled with CFR 0.152.
 */
package iliadpdfscribblemerger;

import iliadpdfscribblemerger.ScribbleMergeForm;
import iliadpdfscribblemerger.ScribbleMerger;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Main {
    public static void main(String[] args) {
        if (args.length == 0) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (UnsupportedLookAndFeelException usfe) {
                // empty catch block
            }
            ScribbleMergeForm dlg = new ScribbleMergeForm();
            dlg.setLocationRelativeTo(null);
            SwingUtilities.updateComponentTreeUI(dlg);
            dlg.setVisible(true);
        } else {
            ArrayList<String> saArgs = new ArrayList<String>(Arrays.asList(args));
            if (saArgs.contains("-?") || saArgs.contains("/?")) {
                System.out.println("This utility allows merging from iLiad iRex scribbles \nwith the oringinal pdf file");
                System.out.println();
                System.out.println("Possible arguments:");
                System.out.println("-i:<path>        ->  iRex-pdf input folder");
                System.out.println("-o:<path>        ->  pdf output (ignored in some cases)");
                System.out.println("-m:<merge-type>  ->  merge type (see below for details)");
                System.out.println("-c<index>:<color>->  color mapping (see below for details)");
                System.out.println("-?               ->  this help");
                System.out.println("notes: - if <path> contains spaces, it must be enclosed in double quotes");
                System.out.println("       - output path must be different from input path");
                System.out.println();
                System.out.println("possible merge types:");
                System.out.println("n  ->  new iRex pdf folder, manifest will be omitted (output path required)");
                System.out.println("m  ->  new iRex pdf folder, manifest will be kept (output path required)");
                System.out.println("s  ->  scribble only (output path required)");
                System.out.println("e  ->  existing pdf will be replaced");
                System.out.println("r  ->  replace all (iRex folder will be replaced by pdf file)");
                System.out.println();
                System.out.println("possible (scribble) colors to map:");
                System.out.println("c1  ->  #000000 = black");
                System.out.println("c2  ->  #555555 = dark grey");
                System.out.println("c3  ->  #AAAAAA = light grey");
                System.out.println("c4  ->  #FFFFFF = white");
                System.out.println("the <color> in the color mapping must be of the form #hhhhhh (h = hex number)");
                return;
            }
            String strInputPath = "";
            String strOutputPath = "";
            String strColor1 = "#000000";
            String strColor2 = "#555555";
            String strColor3 = "#AAAAAA";
            String strColor4 = "#FFFFFF";
            char cMergeType = 'n';
            for (int nArg = 0; nArg < saArgs.size(); ++nArg) {
                if (args[nArg].startsWith("-i:") || args[nArg].startsWith("/i:")) {
                    strInputPath = args[nArg].substring(3);
                    continue;
                }
                if (args[nArg].startsWith("-o:") || args[nArg].startsWith("/o:")) {
                    strOutputPath = args[nArg].substring(3);
                    continue;
                }
                if (args[nArg].startsWith("-c1:") || args[nArg].startsWith("/c1:")) {
                    strColor1 = args[nArg].substring(4);
                    continue;
                }
                if (args[nArg].startsWith("-c2:") || args[nArg].startsWith("/c2:")) {
                    strColor2 = args[nArg].substring(4);
                    continue;
                }
                if (args[nArg].startsWith("-c3:") || args[nArg].startsWith("/c3:")) {
                    strColor3 = args[nArg].substring(4);
                    continue;
                }
                if (args[nArg].startsWith("-c4:") || args[nArg].startsWith("/c4:")) {
                    strColor4 = args[nArg].substring(4);
                    continue;
                }
                if (!args[nArg].startsWith("-m:") && !args[nArg].startsWith("/m:") || args[nArg].length() < 4) continue;
                cMergeType = args[nArg].charAt(3);
            }
            HashMap<String, Color> mapColors = new HashMap<String, Color>();
            try {
                mapColors.put("#000000", Color.decode(strColor1));
                mapColors.put("#555555", Color.decode(strColor2));
                mapColors.put("#AAAAAA", Color.decode(strColor3));
                mapColors.put("#FFFFFF", Color.decode(strColor4));
            }
            catch (NumberFormatException nfe) {
                System.err.println("Invalid color: " + nfe.getMessage());
                return;
            }
            ScribbleMerger.Merge(strInputPath, strOutputPath, cMergeType, mapColors);
        }
    }
}

