// MainForm.cs
//
// Copyright (C) 2005  librie guy
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Xml;
using System.IO;

namespace EditLrfMetaGUI
{
	public class MainForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button cmdClose;
		private System.Windows.Forms.TextBox txtFilename;
		private System.Windows.Forms.Label lblFilename;
		private System.Windows.Forms.Button cmdBrowse;
		private System.Windows.Forms.Label lblTitle;
		private System.Windows.Forms.TextBox txtTitle;
		private System.Windows.Forms.TextBox txtTitleReading;
		private System.Windows.Forms.Label lblTitleReading;
		private System.Windows.Forms.TextBox txtAuthorReading;
		private System.Windows.Forms.Label lblAuthorReading;
		private System.Windows.Forms.TextBox txtAuthor;
		private System.Windows.Forms.Label lblAuthor;
		private System.Windows.Forms.TextBox txtBookId;
		private System.Windows.Forms.Label lblBookId;
		private System.Windows.Forms.TextBox txtPublisher;
		private System.Windows.Forms.Label lblPublisher;
		private System.Windows.Forms.TextBox txtDescription;
		private System.Windows.Forms.Label lblDescription;
		private System.Windows.Forms.TextBox txtCreationDate;
		private System.Windows.Forms.Label lblCreationDate;
		private System.Windows.Forms.TextBox txtImage;
		private System.Windows.Forms.Label lblImage;
		private System.Windows.Forms.Button cmdSave;
		private System.Windows.Forms.Button cmdLoad;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button cmdGenerateBookID;

		private LrfFile _lfrFile = null;

		public MainForm()
		{
			// Required for Windows Form Designer support
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.cmdClose = new System.Windows.Forms.Button();
			this.txtFilename = new System.Windows.Forms.TextBox();
			this.lblFilename = new System.Windows.Forms.Label();
			this.cmdBrowse = new System.Windows.Forms.Button();
			this.lblTitle = new System.Windows.Forms.Label();
			this.txtTitle = new System.Windows.Forms.TextBox();
			this.txtTitleReading = new System.Windows.Forms.TextBox();
			this.lblTitleReading = new System.Windows.Forms.Label();
			this.txtAuthorReading = new System.Windows.Forms.TextBox();
			this.lblAuthorReading = new System.Windows.Forms.Label();
			this.txtAuthor = new System.Windows.Forms.TextBox();
			this.lblAuthor = new System.Windows.Forms.Label();
			this.txtBookId = new System.Windows.Forms.TextBox();
			this.lblBookId = new System.Windows.Forms.Label();
			this.txtPublisher = new System.Windows.Forms.TextBox();
			this.lblPublisher = new System.Windows.Forms.Label();
			this.txtDescription = new System.Windows.Forms.TextBox();
			this.lblDescription = new System.Windows.Forms.Label();
			this.txtCreationDate = new System.Windows.Forms.TextBox();
			this.lblCreationDate = new System.Windows.Forms.Label();
			this.txtImage = new System.Windows.Forms.TextBox();
			this.lblImage = new System.Windows.Forms.Label();
			this.cmdSave = new System.Windows.Forms.Button();
			this.cmdLoad = new System.Windows.Forms.Button();
			this.cmdGenerateBookID = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// cmdClose
			// 
			this.cmdClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdClose.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.cmdClose.Location = new System.Drawing.Point(488, 284);
			this.cmdClose.Name = "cmdClose";
			this.cmdClose.Size = new System.Drawing.Size(84, 24);
			this.cmdClose.TabIndex = 23;
			this.cmdClose.Text = "Close";
			this.cmdClose.Click += new System.EventHandler(this.cmdClose_Click);
			// 
			// txtFilename
			// 
			this.txtFilename.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFilename.Location = new System.Drawing.Point(116, 12);
			this.txtFilename.Name = "txtFilename";
			this.txtFilename.ReadOnly = true;
			this.txtFilename.Size = new System.Drawing.Size(324, 20);
			this.txtFilename.TabIndex = 1;
			this.txtFilename.Text = "";
			// 
			// lblFilename
			// 
			this.lblFilename.Location = new System.Drawing.Point(12, 12);
			this.lblFilename.Name = "lblFilename";
			this.lblFilename.Size = new System.Drawing.Size(104, 20);
			this.lblFilename.TabIndex = 0;
			this.lblFilename.Text = "LRF file:";
			this.lblFilename.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// cmdBrowse
			// 
			this.cmdBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdBrowse.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.cmdBrowse.Location = new System.Drawing.Point(440, 12);
			this.cmdBrowse.Name = "cmdBrowse";
			this.cmdBrowse.Size = new System.Drawing.Size(44, 20);
			this.cmdBrowse.TabIndex = 2;
			this.cmdBrowse.Text = ". . .";
			this.cmdBrowse.Click += new System.EventHandler(this.cmdBrowse_Click);
			// 
			// lblTitle
			// 
			this.lblTitle.Location = new System.Drawing.Point(12, 68);
			this.lblTitle.Name = "lblTitle";
			this.lblTitle.Size = new System.Drawing.Size(104, 20);
			this.lblTitle.TabIndex = 6;
			this.lblTitle.Text = "Title:";
			this.lblTitle.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtTitle
			// 
			this.txtTitle.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTitle.Location = new System.Drawing.Point(116, 68);
			this.txtTitle.Name = "txtTitle";
			this.txtTitle.Size = new System.Drawing.Size(456, 20);
			this.txtTitle.TabIndex = 7;
			this.txtTitle.Text = "";
			// 
			// txtTitleReading
			// 
			this.txtTitleReading.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTitleReading.Location = new System.Drawing.Point(116, 44);
			this.txtTitleReading.Name = "txtTitleReading";
			this.txtTitleReading.Size = new System.Drawing.Size(456, 20);
			this.txtTitleReading.TabIndex = 5;
			this.txtTitleReading.Text = "";
			// 
			// lblTitleReading
			// 
			this.lblTitleReading.Location = new System.Drawing.Point(12, 44);
			this.lblTitleReading.Name = "lblTitleReading";
			this.lblTitleReading.Size = new System.Drawing.Size(104, 20);
			this.lblTitleReading.TabIndex = 4;
			this.lblTitleReading.Text = "Title (kana):";
			this.lblTitleReading.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtAuthorReading
			// 
			this.txtAuthorReading.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAuthorReading.Location = new System.Drawing.Point(116, 92);
			this.txtAuthorReading.Name = "txtAuthorReading";
			this.txtAuthorReading.Size = new System.Drawing.Size(456, 20);
			this.txtAuthorReading.TabIndex = 9;
			this.txtAuthorReading.Text = "";
			// 
			// lblAuthorReading
			// 
			this.lblAuthorReading.Location = new System.Drawing.Point(12, 92);
			this.lblAuthorReading.Name = "lblAuthorReading";
			this.lblAuthorReading.Size = new System.Drawing.Size(104, 20);
			this.lblAuthorReading.TabIndex = 8;
			this.lblAuthorReading.Text = "Author (kana):";
			this.lblAuthorReading.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtAuthor
			// 
			this.txtAuthor.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAuthor.Location = new System.Drawing.Point(116, 116);
			this.txtAuthor.Name = "txtAuthor";
			this.txtAuthor.Size = new System.Drawing.Size(456, 20);
			this.txtAuthor.TabIndex = 11;
			this.txtAuthor.Text = "";
			// 
			// lblAuthor
			// 
			this.lblAuthor.Location = new System.Drawing.Point(12, 116);
			this.lblAuthor.Name = "lblAuthor";
			this.lblAuthor.Size = new System.Drawing.Size(104, 20);
			this.lblAuthor.TabIndex = 10;
			this.lblAuthor.Text = "Author:";
			this.lblAuthor.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtBookId
			// 
			this.txtBookId.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtBookId.Location = new System.Drawing.Point(116, 140);
			this.txtBookId.Name = "txtBookId";
			this.txtBookId.Size = new System.Drawing.Size(372, 20);
			this.txtBookId.TabIndex = 13;
			this.txtBookId.Text = "";
			// 
			// lblBookId
			// 
			this.lblBookId.Location = new System.Drawing.Point(12, 140);
			this.lblBookId.Name = "lblBookId";
			this.lblBookId.Size = new System.Drawing.Size(104, 20);
			this.lblBookId.TabIndex = 12;
			this.lblBookId.Text = "Book ID:";
			this.lblBookId.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtPublisher
			// 
			this.txtPublisher.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPublisher.Location = new System.Drawing.Point(116, 164);
			this.txtPublisher.Name = "txtPublisher";
			this.txtPublisher.Size = new System.Drawing.Size(456, 20);
			this.txtPublisher.TabIndex = 15;
			this.txtPublisher.Text = "";
			// 
			// lblPublisher
			// 
			this.lblPublisher.Location = new System.Drawing.Point(12, 164);
			this.lblPublisher.Name = "lblPublisher";
			this.lblPublisher.Size = new System.Drawing.Size(104, 20);
			this.lblPublisher.TabIndex = 14;
			this.lblPublisher.Text = "Publisher:";
			this.lblPublisher.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtDescription
			// 
			this.txtDescription.AcceptsReturn = true;
			this.txtDescription.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDescription.Location = new System.Drawing.Point(116, 188);
			this.txtDescription.Multiline = true;
			this.txtDescription.Name = "txtDescription";
			this.txtDescription.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtDescription.Size = new System.Drawing.Size(456, 60);
			this.txtDescription.TabIndex = 17;
			this.txtDescription.Text = "";
			// 
			// lblDescription
			// 
			this.lblDescription.Location = new System.Drawing.Point(12, 188);
			this.lblDescription.Name = "lblDescription";
			this.lblDescription.Size = new System.Drawing.Size(104, 20);
			this.lblDescription.TabIndex = 16;
			this.lblDescription.Text = "Description:";
			this.lblDescription.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtCreationDate
			// 
			this.txtCreationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtCreationDate.Location = new System.Drawing.Point(116, 252);
			this.txtCreationDate.Name = "txtCreationDate";
			this.txtCreationDate.Size = new System.Drawing.Size(456, 20);
			this.txtCreationDate.TabIndex = 19;
			this.txtCreationDate.Text = "";
			// 
			// lblCreationDate
			// 
			this.lblCreationDate.Location = new System.Drawing.Point(12, 252);
			this.lblCreationDate.Name = "lblCreationDate";
			this.lblCreationDate.Size = new System.Drawing.Size(104, 20);
			this.lblCreationDate.TabIndex = 18;
			this.lblCreationDate.Text = "Creation date:";
			this.lblCreationDate.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtImage
			// 
			this.txtImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtImage.Location = new System.Drawing.Point(116, 276);
			this.txtImage.Name = "txtImage";
			this.txtImage.Size = new System.Drawing.Size(456, 20);
			this.txtImage.TabIndex = 21;
			this.txtImage.Text = "";
			this.txtImage.Visible = false;
			// 
			// lblImage
			// 
			this.lblImage.Location = new System.Drawing.Point(12, 276);
			this.lblImage.Name = "lblImage";
			this.lblImage.Size = new System.Drawing.Size(104, 20);
			this.lblImage.TabIndex = 20;
			this.lblImage.Text = "Thumbnail image:";
			this.lblImage.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.lblImage.Visible = false;
			// 
			// cmdSave
			// 
			this.cmdSave.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdSave.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.cmdSave.Location = new System.Drawing.Point(400, 284);
			this.cmdSave.Name = "cmdSave";
			this.cmdSave.Size = new System.Drawing.Size(84, 24);
			this.cmdSave.TabIndex = 22;
			this.cmdSave.Text = "Save";
			this.cmdSave.Click += new System.EventHandler(this.cmdSave_Click);
			// 
			// cmdLoad
			// 
			this.cmdLoad.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdLoad.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.cmdLoad.Location = new System.Drawing.Point(488, 12);
			this.cmdLoad.Name = "cmdLoad";
			this.cmdLoad.Size = new System.Drawing.Size(84, 24);
			this.cmdLoad.TabIndex = 3;
			this.cmdLoad.Text = "Load";
			this.cmdLoad.Click += new System.EventHandler(this.cmdLoad_Click);
			// 
			// cmdGenerateBookID
			// 
			this.cmdGenerateBookID.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdGenerateBookID.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.cmdGenerateBookID.Location = new System.Drawing.Point(488, 140);
			this.cmdGenerateBookID.Name = "cmdGenerateBookID";
			this.cmdGenerateBookID.Size = new System.Drawing.Size(84, 20);
			this.cmdGenerateBookID.TabIndex = 24;
			this.cmdGenerateBookID.Text = "Generate";
			this.cmdGenerateBookID.Click += new System.EventHandler(this.cmdGenerateBookID_Click);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(584, 322);
			this.Controls.Add(this.cmdGenerateBookID);
			this.Controls.Add(this.cmdLoad);
			this.Controls.Add(this.cmdBrowse);
			this.Controls.Add(this.cmdSave);
			this.Controls.Add(this.cmdClose);
			this.Controls.Add(this.txtImage);
			this.Controls.Add(this.txtCreationDate);
			this.Controls.Add(this.txtDescription);
			this.Controls.Add(this.txtPublisher);
			this.Controls.Add(this.txtBookId);
			this.Controls.Add(this.txtAuthor);
			this.Controls.Add(this.txtAuthorReading);
			this.Controls.Add(this.txtTitleReading);
			this.Controls.Add(this.txtTitle);
			this.Controls.Add(this.txtFilename);
			this.Controls.Add(this.lblImage);
			this.Controls.Add(this.lblCreationDate);
			this.Controls.Add(this.lblDescription);
			this.Controls.Add(this.lblPublisher);
			this.Controls.Add(this.lblBookId);
			this.Controls.Add(this.lblAuthor);
			this.Controls.Add(this.lblAuthorReading);
			this.Controls.Add(this.lblTitleReading);
			this.Controls.Add(this.lblTitle);
			this.Controls.Add(this.lblFilename);
			this.Name = "MainForm";
			this.Text = "Edit LRF Metadata";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private void cmdClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void cmdBrowse_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog dialog = new OpenFileDialog();
			dialog.RestoreDirectory = true;
			dialog.Multiselect = false;
			dialog.CheckFileExists = true;
			dialog.DefaultExt = "lrf";
			dialog.Filter = "LRF files (*.lrf)|*.lrf|All files (*.*)|*.*";
			dialog.FilterIndex = 1;

			if( dialog.ShowDialog(this) == DialogResult.OK )
			{
				this.txtFilename.Text = dialog.FileName;
				this.LoadLrfFile();
			}
		}

		private void LoadLrfFile()
		{
			Cursor oldCursor = this.Cursor;
			this.Cursor = Cursors.WaitCursor;

			try 
			{
				this.ClearUI();

				// Display the meta info from a LRF file
				this._lfrFile = new LrfFile( this.txtFilename.Text );
	    
				XmlTextReader textReader = new XmlTextReader(new MemoryStream(this._lfrFile.XMLInfoBlock));
				textReader.MoveToContent();

				while (textReader.Read()) 
				{
					// Only bother with this node if it's an element containing data
					if ((textReader.NodeType == XmlNodeType.Element) && (! textReader.IsEmptyElement)) 
					{
						switch(textReader.Name) 
						{
							case "BookID":
								this.txtBookId.Text = textReader.ReadElementString();
								break;

							case "Author":
								if (textReader.GetAttribute("reading") != null) 
								{
									this.txtAuthorReading.Text = textReader.GetAttribute("reading");
								}
								this.txtAuthor.Text = textReader.ReadElementString();
								break;

							case "Title":
								if (textReader.GetAttribute("reading") != null) 
								{
									this.txtTitleReading.Text = textReader.GetAttribute("reading");
								}
								this.txtTitle.Text = textReader.ReadElementString();
								break;

							case "CreationDate":
								this.txtCreationDate.Text = textReader.ReadElementString().Trim();
								break;
							case "Publisher":
								this.txtPublisher.Text = textReader.ReadElementString().Trim();
								break;
							case "FreeText":
								this.txtDescription.Text = textReader.ReadElementString().Trim();
								break;
						}
					}
				} 
			} 
			catch( Exception e )
			{
				MessageBox.Show( this, e.ToString() );
			}
			finally
			{
				this.Cursor = oldCursor;
			}
		}

		private void SaveLrfFile()
		{
			Cursor oldCursor = this.Cursor;
			this.Cursor = Cursors.WaitCursor;

			try 
			{
				if( this._lfrFile == null )
				{
					MessageBox.Show(
						this,
						"You must load an LRF file first.",
						"Error" );
					return;
				}

				// Sets the thumbnail if necessary
				string imageFile = this.txtImage.Text.Trim();
				if ( imageFile.Length > 0 ) 
				{
					if (! File.Exists( imageFile )) 
					{
						MessageBox.Show(
							this,
							string.Format( "'{0}' does not exist, or is not a file.", imageFile ),
							"Error" );
						return;
					}

					// Read the entire thumbnail file into thumbBytes
					byte[] thumbBytes = new byte[new FileInfo( imageFile ).Length];
					byte[] tempBuffer = new byte[4096];
					FileStream thumbfs = new FileStream( imageFile, FileMode.Open );
					int numBytesRead = 0;
					int curPosition = 0;

					while( (numBytesRead = thumbfs.Read(tempBuffer, 0, 4096)) != 0 ) 
					{
						Buffer.BlockCopy(tempBuffer, 0, thumbBytes, curPosition, numBytesRead);
						curPosition += numBytesRead;
					}

					thumbfs.Close ();
					tempBuffer = null;
					this._lfrFile.GIFData = thumbBytes;
				}
	
				MemoryStream outputStream = new MemoryStream();
				XmlTextWriter textWriter = new XmlTextWriter(outputStream, new System.Text.UnicodeEncoding());
				textWriter.Formatting = Formatting.Indented;
				textWriter.WriteStartDocument();
				textWriter.WriteStartElement("Info");
				textWriter.WriteAttributeString("version", "1.0");
				XmlTextReader textReader = new XmlTextReader(new MemoryStream(this._lfrFile.XMLInfoBlock));
				textReader.MoveToContent();
	
				while (textReader.Read()) 
				{
					if ((textReader.NodeType == XmlNodeType.Element) && (! textReader.IsEmptyElement)) 
					{
						if (textReader.Name == "BookInfo") 
						{
							textWriter.WriteStartElement("BookInfo");
							continue;
						} 
						else if (textReader.Name == "DocInfo") 
						{
							textWriter.WriteStartElement("DocInfo");
							continue;
						} 
						else 
						{
							switch(textReader.Name) 
							{
								case "BookID":
									if ( this.txtBookId.Text.Trim().Length > 0 ) 
									{
										textWriter.WriteStartElement("BookID");
										textWriter.WriteString( this.txtBookId.Text.Trim() );
										textWriter.WriteEndElement(); 
									} 
									else 
									{
										textWriter.WriteNode(textReader, false);
									}
									break;
								case "Author":
									if( this.txtAuthor.Text.Trim().Length > 0 ) 
									{
										textWriter.WriteStartElement("Author");
										if( this.txtAuthorReading.Text.Trim().Length > 0 ) 
										{
											textWriter.WriteAttributeString("reading", this.txtAuthorReading.Text.Trim() );
										}
										textWriter.WriteString( this.txtAuthor.Text.Trim() );
										textWriter.WriteEndElement(); 
									} 
									else 
									{
										textWriter.WriteNode(textReader, false);
									}
									break;
								case "Title":
									if( this.txtTitle.Text.Trim().Length > 0 ) 
									{
										textWriter.WriteStartElement("Title");
										if( this.txtTitleReading.Text.Trim().Length > 0 ) 
										{
											textWriter.WriteAttributeString("reading", this.txtTitleReading.Text.Trim() );
										}
										textWriter.WriteString( this.txtTitle.Text.Trim() );
										textWriter.WriteEndElement(); 
									} 
									else 
									{
										textWriter.WriteNode(textReader, false);
									}
									break;
								case "Publisher":
									if( this.txtPublisher.Text.Trim().Length > 0 ) 
									{
										textWriter.WriteStartElement("Publisher");
										textWriter.WriteString( this.txtPublisher.Text.Trim() );
										textWriter.WriteEndElement(); 
									} 
									else 
									{
										textWriter.WriteNode(textReader, false);
									}
									break;
								case "CreationDate":
									if(  this.txtCreationDate.Text.Trim().Length > 0  ) 
									{
										textWriter.WriteStartElement("CreationDate");
										textWriter.WriteString( this.txtCreationDate.Text.Trim() );
										textWriter.WriteEndElement(); 
									} 
									else 
									{
										textWriter.WriteNode(textReader, false);
									}
									break;
								case "FreeText":
									if(  this.txtDescription.Text.Trim().Length > 0  )
									{
										textWriter.WriteStartElement("FreeText");
										textWriter.WriteString( this.txtDescription.Text.Trim() );
										textWriter.WriteEndElement(); 
									} 
									else 
									{
										textWriter.WriteNode(textReader, false);
									}
									break;
								default:
									textWriter.WriteNode(textReader, false);
									break;
							}
						}
					} 
					else if ((textReader.NodeType == XmlNodeType.EndElement) && (textReader.Name == "BookInfo") || (textReader.Name == "DocInfo" ))  
					{
						textWriter.WriteNode(textReader, false);
					}
				}
	
				textWriter.WriteEndDocument();
				textWriter.Close();
				textReader.Close();
				this._lfrFile.XMLInfoBlock = outputStream.GetBuffer();

				// Save the LRF file again
				FileStream fs = File.Create( this.txtFilename.Text );
				byte[] lrfData = this._lfrFile.GetBytes();
				fs.Write(lrfData, 0, lrfData.Length);
				fs.Close();
			}
			catch( Exception xc )
			{
				MessageBox.Show( this, xc.ToString() );
			}
			finally
			{
				this.Cursor = oldCursor;
			}
		}

		private void ClearUI()
		{
			this.txtTitleReading.Text = string.Empty;
			this.txtTitle.Text = string.Empty;
			this.txtAuthorReading.Text = string.Empty;
			this.txtAuthor.Text = string.Empty;
			this.txtBookId.Text = string.Empty;
			this.txtPublisher.Text = string.Empty;
			this.txtDescription.Text = string.Empty;
			this.txtCreationDate.Text = string.Empty;
			this.txtImage.Text = string.Empty;
		}

		private void cmdLoad_Click(object sender, System.EventArgs e)
		{
			this.LoadLrfFile();
		}

		private void cmdSave_Click(object sender, System.EventArgs e)
		{
			this.SaveLrfFile();
		}

		private void cmdGenerateBookID_Click(object sender, System.EventArgs e)
		{
			Random random = new Random();

			// Format: 4 capital Latin letters + 12 digits
			string bookId =
				Convert.ToChar( random.Next( 65, 91 ) ).ToString()
				+ Convert.ToChar( random.Next( 65, 91 ) ).ToString()
				+ Convert.ToChar( random.Next( 65, 91 ) ).ToString()
				+ Convert.ToChar( random.Next( 65, 91 ) ).ToString()
				+ random.Next( 0, 1000000 ).ToString("000000")
				+ random.Next( 0, 1000000 ).ToString("000000");

			this.txtBookId.Text = bookId;
		}
	}
}
