<?xml version="1.0" encoding="utf-8" ?>
<!-- [[CHECKSUM:XXXXXXXX]] -->
<xsl:stylesheet xmlns:mbp="http://www.mobipocket.com/mbp" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:idx="http://www.mobipocket.com/mbp">

<xsl:output method="xml" />



<xsl:template match="toc">
<html>
<body topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0">
<a name="list" external="yes"/>
<h2 align="left"><img src="album32.gif" align="middle"/> Browse Photos</h2>
<div align="left">
<ul>
<xsl:for-each select="item[@ui-item-type='photo']">
<li><a href="#{position()}"><xsl:value-of select="name"/></a></li>		
</xsl:for-each>
</ul>
</div>

<mbp:pagebreak/>

<a name="thumb" external="yes"/>
<div align="center">
<xsl:for-each select="item[@ui-item-type='photo']">
<a href="#{position()}"><img src="{photo}" width="60" height="60" thumbnail="yes" hspace="4" vspace="4" border="0"/></a><xsl:text> </xsl:text>
</xsl:for-each>
</div>

<xsl:for-each select="item[@ui-item-type='photo']">
<mbp:frameset name="{position()}">
<idx:entry>
<idx:orth orth="{name}"/>
<idx:key type="keyword" each-word="true" key="{name}"/>
</idx:entry>
<mbp:slave-frame device="all" display="top" breadth="auto" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0">
<table width="100%"><tr><td bgcolor="#DDDDDD" align="left"><p width="0"/><b><xsl:call-template name="format_trunc"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template></b></td>
<td bgcolor="#DDDDDD" align="right"><xsl:if test="photo-date != ''"><span title="{photo-date}"><img align="middle" src="date.gif"/> </span></xsl:if>
<xsl:if test="desc != ''"><span title="{desc}"><img align="middle" src="comment.gif"/></span></xsl:if></td></tr></table>
</mbp:slave-frame>

<xsl:call-template name="bottom_nav"/>

<center><img src="{photo}"/></center>
</mbp:frameset>
</xsl:for-each>

<xsl:call-template name="about"/>

</body>
</html>
</xsl:template>



<xsl:template match="item[@ui-item-type='photo']">
<html><body></body></html>
</xsl:template>




<xsl:template name="about">
<mbp:frameset id="about" crossable="no">
<h1>About this photo album</h1>

<p>This photo album was created with the Mobipocket Creator software, and can be viewed on all PDA/smartphones supported by the Mobipocket Reader.</p>

<h3>Mobi Reader Tips</h3>
<div align="left">
<b><u>Slideshow</u></b><br/>
Click on the scroll icon in the Mobi Reader to start a slide show (requires Mobi Reader Pro version).<br/>
<br/>
<b><u>Rotate screen</u></b><br/>
You can change the screen orientation to go from/to landscape/portrait mode, by clicking on the screen rotation icon in the Mobi Reader (requires Mobi Reader Pro version).<br/>
<br/>
<b><u>Fullscreen</u></b><br/>
Use the Mobi Reader fullscreen mode to allow for more space to display your pictures on the screen. (see Help menu on how to goto fullscreen mode on your device)<br/>
<br/>
<b><u>Image Viewer</u></b><br/>
Click on the photo to open it in the built-in Image Viewer, and zoom in and out or scroll picture.
</div>
</mbp:frameset>

</xsl:template>



<xsl:template name="bottom_nav">
<mbp:slave-frame device="all" display="bottom" breadth="auto" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0">
<div bgcolor="#DDDDDD" align="right">
<a onclick="document.location.hash = '1'"><img src="nav_first.gif" border="0"/></a>
<xsl:choose>
<xsl:when test="position() &gt; 1">
<a onclick="document.location.hash = '{position()-1}'"><img src="nav_prev.gif" border="0"/></a>
</xsl:when>
<xsl:otherwise>
<span title="First picture!"><img src="nav_prev.gif" border="0"/></span>
</xsl:otherwise>
</xsl:choose>
<xsl:choose>
<xsl:when test="position() &lt; last()">
<a onclick="document.location.hash = '{position()+1}'"><img src="nav_next.gif" border="0"/></a>
</xsl:when>
<xsl:otherwise>
<span title="Last picture!"><img src="nav_next.gif" border="0"/></span>
</xsl:otherwise>
</xsl:choose>
<xsl:text> </xsl:text>
<form name="{position()}">
<select name="nav" onchange="document.location.hash=this.value">
<option value="none" >Select a View</option>
<option value="list" >List View</option>
<option value="thumb" >Thumbnail View</option>
</select>
</form>
<xsl:text> </xsl:text><a onclick="filtered_index_search('', 'keyword', 'Search on any word in the title of photo:', 'List of Photos:', '', 'none')"><img src="search.gif" border="0" align="middle"/></a>
</div>
</mbp:slave-frame>
</xsl:template>



<xsl:template name="format_trunc">
<xsl:param name="string"/>
<xsl:choose>
<xsl:when test="string-length($string) > 20">
<xsl:value-of select="substring($string, 1, 20)"/><span title="{$string}" color="blue"><b>[...]</b></span>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$string"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>


</xsl:stylesheet>

