// Copyright (C) 2008 Simon Mendoza
// This file is part of gtk-sudoku.
// Modified for mxSudoku
//
// gtk-sudoku is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// gtk-sudoku is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with gtk-sudoku.  If not, see <http://www.gnu.org/licenses/>.

// TODO: well .... try to understand the code

#include "config.h"

#include "generator.h"
#include "log.h"

#include <time.h>
#include <stdlib.h>

static int N, N2, N4;
static int *A, *Ur, *Uc, *V;
static int *Rows, *Cols, **Row, **Col;
static int *C, *I, *Node, *Two, *C0, *P;
static int **M1, **N1, **Z1;
static int s1,i1,i4,c0,m0,m1,i,j,k,l,r,r1,c,c1,n,m,x,y,s;
static int min,clues,nodes,guesses,solutions;
static unsigned zr=362436069, wr=521288629;
static char L[18]=".123456789ABCDEFG";

#define MWC ( (zr=36969*(zr&65535)+(zr>>16)) ^ (wr=18000*(wr&65535)+(wr>>16)) )

static int reduce(int c);
static int unreduce(int c);

static int gen_solve(int smax)
{
	for(i = 0; i <= N4>>4; ++i)
	for(j = 1; j <= m; ++j) {
		N1[i][j] = 0;
		Z1[i][j] = 0;
	}
	for(i = 0; i <= n; ++i)
		Ur[i] = 0;
	for(i = 0; i <= m; ++i)
		Uc[i]=0;
	clues = 0;
	for(x = 1; x <= N2; ++x)
	for(y = 1; y <= N2; ++y)
		if(A[x*N2-N2+y]) {
			++clues;
			r = x*N4-N4+y*N2-N2+A[x*N2-N2+y];
			for(j = 1; j <= Cols[r]; ++j) {
				c1 = Col[r][j];
				if(Uc[c1])
					return -1;
				Uc[c1]++;
				for(k = 1; k <= Rows[c1]; ++k) {
					r1 = Row[c1][k];
					Ur[r1]++;
		} } }
	for(c = 1; c<=m; ++c) {
		V[c] = 0;
		for(r = 1; r <= Rows[c]; ++r)
			if(Ur[Row[c][r]] == 0)
				V[c]++;
	}
	
	m0=0;
	m1=0;
	guesses=0;
	i=clues;
	solutions=0;
m2:	i++;
	I[i] = 0;
	min=n+1;
	if(i>N4 || m0)
		goto m4;
	if(m1) {
		C[i]=m1;
		goto m3;
	}
	
	c0=0;
	for(c = 1; c<=m; ++c)
		if(!Uc[c]) {
			if(V[c]<=min) {
				c0++;
				C0[c0]=c;
			}
			if(V[c]<min) {
				min=V[c];
				c0=1;
				C[i]=c;
				C0[c0]=c;
				if(min<2) goto m3;
		} }
	if(min>1)guesses++;

m2a:c1=MWC&Two[c0];
	if(c1>=c0)
		goto m2a;
	++c1;
	C[i]=C0[c1];
	
	min=999999;
	i4=i>>4;
	for(j = c1; j <= c0; ++j) {
		c=C0[j];
		if(N1[i4][c]<min*Z1[i4][c]) {
			min=N1[i4][c]/Z1[i4][c];
			C[i]=c;
	} }
	for(j = 1; j < c1; ++j) {
		c=C0[j];
		if(N1[i4][c]<min*Z1[i4][c]) {
			min=N1[i4][c]/Z1[i4][c];
			C[i]=c;
	} }

m3:	c=C[i];
	I[i]++;
	if(I[i]>Rows[c])
		goto m4;
	r=Row[c][I[i]];
	if(Ur[r])
		goto m3;
	m0=0;
	m1=0;
	if(smax==1) {
		j=N2;
		k=N4;
		x=(r-1)/k+1;
		y=((r-1)%k)/j+1;
		s=(r-1)%j+1;
		A[x*N2-N2+y]=s;
	}
	for(j = 1; j<= Cols[r]; ++j) {
		c1=Col[r][j];
		Uc[c1]++;
	}
	for(j = 1; j <= Cols[r]; ++j)
		reduce(Col[r][j]);
	Node[i]++;
	++nodes;
	M1[i][c]=nodes; //~ remember nodes
	if(i == N4) {
		++solutions;
		if(smax==1)
			return 1;
	}
	if(solutions>1)
		return 2;
	goto m2;
m4:	c=C[i];
	N1[i>>4][c]+=nodes-M1[i][c];
	Z1[i>>4][c]++; //~ column-statistics
	i--;
	c=C[i];
	r=Row[c][I[i]];
	for(j = 1; j <= Cols[r]; ++j)
		unreduce(Col[r][j]);
	if(i>clues)
		goto m3;
	return solutions;
}

// deletes c and N[c], updates V[],m0,m1
static int reduce(int c)
{
	int r,c2,k,l;
	for(k = 1; k <= Rows[c]; ++k) {
		r=Row[c][k];
		Ur[r]++;
		if(Ur[r]==1)
			for(l = 1; l <= Cols[r]; ++l) {
				c2=Col[r][l];
				V[c2]--;
				if(Uc[c2]+V[c2]<1)
					m0=c2;
				if(Uc[c2]==0 && V[c2]<2)
					m1=c2;
	} }
	return 0;
}

static int unreduce(int c)
{
	int r,c2,k,l;
	Uc[c]--;
	for(k = 1; k <= Rows[c]; ++k) {
		r=Row[c][k];
		Ur[r]--;
		if(Ur[r]==0)
			for(l = 1; l <= Cols[r]; ++l) {
				c2 = Col[r][l];
				V[c2]++;
	} }
	return 0;
} 

static int init_all(int block_size)
{
	register size_t row;
	N = block_size; // block_size:  3,   4, ...
	N2 = block_size*block_size; //  9,  16
	N4 = N2*N2;                 // 81, 256
	n = N4*N2;
	m = 4*N4;

	if( (A = (int*)malloc(sizeof(int)*(N4+9))) == NULL ) return 0;
	if( (Ur = (int*)malloc(sizeof(int)*(N2*N4+1))) == NULL ) return 0;
	if( (Uc = (int*)malloc(sizeof(int)*(4*N4+1))) == NULL ) return 0;
	if( (V = (int*)malloc(sizeof(int)*(N2*N4+1))) == NULL ) return 0;

	if( (Rows = (int*)malloc(sizeof(int)*(4*N4+1))) == NULL ) return 0;
	if( (Cols = (int*)malloc(sizeof(int)*(N2*N4+1))) == NULL ) return 0;

	if( (Row = malloc(sizeof(int*)*(4*N4+1))) == NULL ) return 0;
	for(row = 0; row < 4*N4+1; ++row)
		if( (Row[row] = (int*)malloc(sizeof(int)*(N2+1))) == NULL )
			return 0;

	if( (Col = malloc(sizeof(int*)*(N2*N4+1))) == NULL ) return 0;
	for(row = 0; row < N2*N4+1; ++row)
		if( (Col[row] = (int*)malloc(sizeof(int)*5)) == NULL )
			return 0;

	// generator depends on default value of 0 within C
	if( (C = (int*)calloc((N4+2),sizeof(int))) == NULL ) return 0;
	if( (I = (int*)malloc(sizeof(int)*(N4+2))) == NULL ) return 0;
	if( (Node = (int*)malloc(sizeof(int)*(N4+1))) == NULL ) return 0;
	if( (Two = (int*)malloc(sizeof(int)*(N4*4+9))) == NULL ) return 0;
	if( (C0 = (int*)malloc(sizeof(int)*(N4*4+9))) == NULL ) return 0;
	if( (P = (int*)malloc(sizeof(int)*(N4+9))) == NULL ) return 0;

	if( (M1 = malloc(sizeof(int*)*(N4+9))) == NULL ) return 0;
	for(row = 0; row < N4+9; ++row)
		if( (M1[row] = (int*)malloc(sizeof(int)*(4*N4+9))) == NULL )
			return 0;

	if( (N1 = malloc((N4+9)*sizeof(int*))) == NULL ) return 0;
	for(row = 0; row < N4+9; ++row)
		if( (N1[row] = (int*)malloc((4*N4+9)*sizeof(int))) == NULL )
			return 0;

	if( (Z1 = malloc((N4+9)*sizeof(int*))) == NULL ) return 0;
	for(row = 0; row < N4+9; ++row)
		if( (Z1[row] = (int*)malloc((4*N4+9)*sizeof(int))) == NULL )
			return 0;

	return 1;
}

static void free_all(void)
{
	register int row;
	free(C); free(I); free(Node); free(Two); free(C0); free(P);
	free(A); free(Ur); free(Uc); free(V);
	free(Rows); free(Cols);
	for(row = 0; row < 4*N4+1; ++row)
		free(Row[row]); free(Row);
	for(row = 0; row < N2*N4+1; ++row)
		free(Col[row]); free(Col);
	for(row = 0; row < N4+9; ++row) {
		free(M1[row]); free(N1[row]); free(Z1[row]);
	}
	free(M1); free(N1); free(Z1);
}

static void mxmodel_gen_soduku_get_game(p_mxmodel_game_data game_data)
{
	register int row;
	register int col;
	register int idx;
	int value;

    LOGPRINTF("entry");

	game_data->game.empty_squares = 0;

	idx = 1;
	for(row = 0; row < game_data->game.horizontal; ++row)
	{
		for(col = 0; col < game_data->game.vertical; ++col, ++idx) 
		{
			//LOGPRINTF("Cell: idx:%d value:%d", idx, A[idx]);
			if(L[A[idx]] != '.')      // if a value is provided
			{
				game_data->cells[idx-1].flags = MXMODEL_CELL_READONLY;
				game_data->cells[idx-1].must_value = A[idx];
				value = (L[A[idx]] == 'G')? 0: A[idx]; // exception 'G' = 0
				game_data->cells[idx-1].value = value;
			}
			else
			{
				game_data->cells[idx-1].flags = 0; //editable
				game_data->cells[idx-1].must_value = -1; // unknown
				game_data->cells[idx-1].value = -1;      // no value
				// empty cell
				game_data->game.empty_squares++;
			}
		}
	}
}

void mxmodel_gen_soduku_random_game(p_mxmodel_game_data game_data)
{
	int block_size=3; // default
		
    LOGPRINTF("entry");

	switch (game_data->game.type)
	{
		case mxmodel_sudoku3x3:
			// generate data for soduku
			block_size = 3;
			break;
		case mxmodel_sudoku4x4:
			// generate data for soduku
			block_size = 4;
			break;
		default:
		    // do not know what to do?
			break;
	}

	if(!init_all(block_size)) {
		fputs("  * Insufficient memory!\n", stderr);
		return;
	}
	x = time(0);
	zr += x; wr ^= x;
	
	for(i = 1; i <= m; ++i) {
		j=1;
		while(j < i) j += j;
		Two[i] = j-1;
	}
	
	r=0;
	k=N;
	l=N2;
	for(x = 1; x <= N2; ++x)
	for(y = 1; y <= N2; ++y)
	for(s = 1; s <= N2; ++s) {
		++r;
		Cols[r]=4;
		Col[r][1]=x*N2-N2+y;
		Col[r][2]=(k*((x-1)/k)+(y-1)/k)*l+s+N4;
		Col[r][3]=x*N2-N2+s+N4*2;
		Col[r][4]=y*N2-N2+s+N4*3;
	}
	for(i = 1; i <= m; ++i)
		Rows[i]=0;
	for(r = 1; r <= n; ++r)
	for(i = 1; i <= Cols[r]; ++i) {
		c=Col[r][i];
		Rows[c]++;
		Row[c][Rows[c]]=r;
	}
	
	for(i = 1; i <= N4; ++i)
		A[i]=0;
	gen_solve(1);

	for(i = 1; i <= N4; ++i) {
mr4:	x=MWC&255;
		if(x >= i)
			goto mr4;
		++x;
		P[i]=P[x];
		P[x]=i;
	}
	for(i1 = 1; i1 <= N4; ++i1)
		if(A[P[i1]]) {
			s1 = A[P[i1]];
			A[P[i1]] = 0;
			if(gen_solve(2)>1) A[P[i1]] = s1;
		}

	// copy data to game structure 
	mxmodel_gen_soduku_get_game(game_data);
	
	free_all();
}
