#ifndef __SCRIBBLES_H__
#define __SCRIBBLES_H__

/**
 * File Name  : template.h
 *
 * Description: 
 */

/*
 * This file is part of mxSudoku
 *
 * mxSudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * mxSudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 Marcel Hendrickx
 * All rights reserved.
 */


//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------
#include <gtk/gtk.h>

G_BEGIN_DECLS


//----------------------------------------------------------------------------
// Definitions
//---------------------------------------------------------------------------- 

//----------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Global Variables
//----------------------------------------------------------------------------


//============================================================================
// Public Functions
//============================================================================

// initialise scribbles
void scribble_init(void);

// close scribblings
void scribble_close(void);

// reset the internal list of positions and start at first position
void scribble_start(int posx, int posy);

// add a position to the list
void scribble_add(int posx, int posy);

// add last position to the list
void scribble_end(int posx, int posy);

// convert list to number
int scribble_get_number();

// draw the last scribbles (for test purposes)
void scribble_draw_last(GdkDrawable *drawable, GdkGC *gc);

G_END_DECLS

#endif /* __SCRIBBLES_H__ */
