#ifndef __MXMODEL_H__
#define __MXMODEL_H__

/**
 * File Name  : mxModel.h
 *
 * Description: 
 */

/*
 * This file is part of mxSudoku
 *
 * mxSudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * mxSudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 Marcel Hendrickx
 * All rights reserved.
 */


//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#include <gtk/gtk.h>

G_BEGIN_DECLS


//----------------------------------------------------------------------------
// Definitions
//---------------------------------------------------------------------------- 

//----------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------

// The list of models that are supported
// ...well ... ehhh .. only 3x3 is supported
typedef enum _mxmodel_type{
	mxmodel_unknown   = -1,
	mxmodel_sudoku3x3 = 0,
	mxmodel_sudoku4x4,
	mxmodel_sudoku5x5,
	mxmodel_kakuro5x5,
	mxmodel_kakuro6x6,
	mxmodel_kakuro8x8,
	mxmodel_kakuro10x10,
	mxmodel_kakuro12x12,
	mxmodel_kakuro15x15,
	mxmodel_kakuro11x17,
	mxmodel_kakuro13x17
} mxmodel_type, *p_mxmodel_type;

// model data
typedef struct _mxmodel_game {
	mxmodel_type type;
	int          horizontal;
	int          vertical;
	int          empty_squares;
	char         id[10];
	char         game_type[3];
} mxmodel_game, *p_mxmodel_game;

// cell can not be changed
#define MXMODEL_CELL_READONLY   1
// cell can be modified in construct mode
#define MXMODEL_CELL_MODIFYABLE 2

// info per cell of the game
typedef struct _mxmodel_cell {
	int flags;              // see MXMODEL_CELLL_* above
	int must_value;			// the value the cell should eventually have (-1=unknown)
	int value;              // current assigned value (-1 = not assigned)
} mxmodel_cell, *p_mxmodel_cell;

// TODO: move this to local include file (should not be public!)
typedef struct _mxmodel_game_data
{
	mxmodel_game	game;
	p_mxmodel_cell  cells; // pointer to array of cells
	char            **pp_ornaments;
} mxmodel_game_data, *p_mxmodel_game_data;


//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Global Variables
//----------------------------------------------------------------------------


//============================================================================
// Public Functions
//============================================================================
// TODO: Doxygen

// create a new model for a game, returns instance to model
int mxmodel_create(mxmodel_type type);

// delete data of the model (release all resources)
int mxmodel_delete(int model);

// is there a generator available
int mxmodel_can_generate(int model);

// generate a new game for the instance with the indicated difficulty level
int mxmodel_generate(int model, int level);

// verifies the game and returns number of incorrect answers
int mxmodel_verify(int model);

// returns the number of solutions that can be found in the current game
// and sets the must_values to a correct value
int mxmodel_solve(p_mxmodel_game_data game_data);

// check if the must values for a model are complete
int mxmodel_check_complete(int model);

// get info on the game (into supplied structure)
int mxmodel_get_info(int model, p_mxmodel_game game);

// get cell info (into supplied structure)
int mxmodel_get_cell_info(int model, int cell_nr, p_mxmodel_cell cell);

// can change call (0=no)
int mxmodel_can_change_cell(int model, int cell_nr);

// set cell value
int mxmodel_set_cell_value(int model, int cell_nr, int value);

// set cell must_value
int mxmodel_set_cell_must_value(int model, int cell_nr, int value);

// get type of a game file
mxmodel_type mxmodel_file_get_type(char *filename);

// load game from file
int mxmodel_file_load(int model, char *filename, int flags);

// save game to file
int mxmodel_file_save(int model, char *filename);

// return number of empty cells
int mxmodel_get_empty_cells(int model);

// return the ornaments for the game
char **mxmodel_get_ornaments(int model);

// check if model is a sudoku
int mxmodel_is_sudoku(int model);

// check if model is a kakuro
int mxmodel_is_kakuro(int model);

G_END_DECLS

#endif /* __MXMODEL_H__ */
