#ifndef __MXCONTROL_H__
#define __MXCONTROL_H__

/**
 * File Name  : mxControl.h
 *
 * Description: 
 */

/*
 * This file is part of mxSudoku
 *
 * mxSudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * mxSudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 Marcel Hendrickx
 * All rights reserved.
 */


//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------
#include <gtk/gtk.h>
#include "mxModel.h"

G_BEGIN_DECLS


//----------------------------------------------------------------------------
// Definitions
//---------------------------------------------------------------------------- 

#define MXCTRL_DEMO_MODE_SCRIBBLE 1

//----------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------

// the event that the controller handles
typedef enum _mxcontrol_event_type
{
	mxcontrol_event_set_value,
	mxcontrol_event_cmd_verify
} mxcontrol_event_type, *p_mxcontrol_event_type;

// the event structure
typedef struct _mxcontrol_event
{
	mxcontrol_event_type type;
	int cell_nr;
	int value;
} mxcontrol_event, *p_mxcontrol_event;

//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Global Variables
//----------------------------------------------------------------------------


//============================================================================
// Public Functions
//============================================================================

// TODO: Doxygen
int mxcontrol_handle_view_event(p_mxcontrol_event event);
void mxcontrol_create_game(GtkWidget *window, mxmodel_type type);
void mxcontrol_quit_game();
// set the demo mode for the game
void mxcontrol_set_demo_mode(int mode);

G_END_DECLS

#endif /* __MXCONTROL_H__ */
