#!/bin/sh

scriptdir=`/usr/bin/dirname $0`
cd $scriptdir

LANG=`grep "language" /var/er_registry.txt |cut -d'=' -f 2 |cut -d'_' -f 1`
DIR=/usr/share/contentlister/mode/${LANG}
test -f error_log && rm error_log

ls ${DIR} | sed -e "s!${DIR}!!g" | cut -d_ -f2 > ${scriptdir}/original_order

# Just in case, convert the file new_order from DOS to UNIX format.
cat new_order.txt | tr -d \\r > new_order

# Sanity check, is there the same number of entries in new_order and original_order

WCORIG=`wc -l < original_order`
WCWANTED=`wc -l < new_order.txt`

if [ ${WCORIG} -ne ${WCWANTED} ]; then
	printf "%s\n%d%s\n%d%s\n" "Number of lines in the file new_order differs from the number of entries in Device Manager menu." $WCORIG " entries in Device Manager menu." $WCWANTED " in the file new_order." > error_log
fi

# Sanity check, does the entries in new_order exist in original_order

NUM=0

sort original_order > original.sort
sort new_order > new.sort
test -f diff.out && rm diff.out

# Since the iLiad have no diff program this awk script is used instead
awk '
FILENAME == "new.sort" { arr[$0]++}
FILENAME == "original.sort" { if ( arr[$0] != 1 ) { delete arr[$0]}
                  else  delete arr[$0]
                }
END {
for ( key in arr ) print key
}' new.sort original.sort > diff.out

rm original.sort new.sort
if [ -s diff.out ]; then
	echo "The following line(s) does not exist in Device Manager menu." >> error_log
	cat diff.out >> error_log
fi
rm diff.out

if [ -s error_log ]; then
	cat error_log | sed -e "s/$/\\r/g" > error_log.txt
	rm new_order error_log
	exit 1
fi

# OK, checks been done, now change the ordering

NUM=0
cat ${scriptdir}/new_order | while read Line
do
	let NUM=${NUM}+1
	OLD_FILE=`echo ${DIR}/*_${Line}`
	NEW_FILE="${DIR}/`printf %02d ${NUM}`_${Line}"
	if [ "${OLD_FILE}" != "${NEW_FILE}" ]; then
		mv "${OLD_FILE}" "${NEW_FILE}"
	fi
done
rm new_order

# Update the manifest to reflect the new status
mv manifest.xml reorder.xml
mv restore.xml manifest.xml
