/*
 * Decompiled with CFR 0.152.
 */
package iliadpdfscribblemerger;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import iliadpdfscribblemerger.ScribblePage;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScribbleMerger {
    String strPdfSource;
    String strScribbleXmlPath;
    HashMap<String, Color> mapColors;
    ArrayList<ScribblePage> arrScribblePages;
    HashMap<Integer, ScribblePage> mapScribblePages;

    public ScribbleMerger(String strPdfSource, String strScribbleXmlPath) {
        this.strPdfSource = strPdfSource;
        this.strScribbleXmlPath = strScribbleXmlPath;
        this.arrScribblePages = new ArrayList();
        this.mapScribblePages = new HashMap();
        this.mapColors = null;
    }

    public boolean Merge(String strOutput, HashMap<String, Color> mapColors, boolean bScribblePagesOnly) {
        if (strOutput == null) {
            return false;
        }
        this.mapColors = mapColors;
        if (!strOutput.toLowerCase().endsWith(".pdf")) {
            strOutput = strOutput + ".pdf";
        }
        if (strOutput.equals(this.strPdfSource)) {
            return false;
        }
        if (!this.ParseXml()) {
            return false;
        }
        return this.MergeScribbles(strOutput, bScribblePagesOnly);
    }

    protected boolean ParseXml() {
        this.arrScribblePages.clear();
        this.mapScribblePages.clear();
        try {
            File file = new File(this.strScribbleXmlPath);
            if (!file.exists()) {
                return false;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            org.w3c.dom.Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodePages = doc.getElementsByTagName("page");
            int nPageCount = nodePages.getLength();
            this.arrScribblePages.ensureCapacity(nPageCount);
            for (int nScribblePage = 0; nScribblePage < nPageCount; ++nScribblePage) {
                Node nodePage = nodePages.item(nScribblePage);
                if (nodePage == null || nodePage.getNodeType() != 1) continue;
                Element elPage = (Element)nodePage;
                ScribblePage sp = new ScribblePage(elPage);
                this.arrScribblePages.add(sp);
                this.mapScribblePages.put(sp.nPageId, sp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean MergeScribbles(String strPdfDestination, boolean bScribblePagesOnly) {
        try {
            PdfReader reader = new PdfReader(this.strPdfSource);
            int nPageCount = reader.getNumberOfPages();
            Rectangle rSize = reader.getPageSize(1);
            float fWidth = rSize.width();
            float fHeight = rSize.height();
            Document document = new Document(rSize, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(strPdfDestination));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            if (bScribblePagesOnly) {
                for (int nPage = 0; nPage < this.arrScribblePages.size(); ++nPage) {
                    ScribblePage spPage = this.arrScribblePages.get(nPage);
                    document.newPage();
                    PdfImportedPage pageOrg = writer.getImportedPage(reader, spPage.nPageId);
                    cb.addTemplate(pageOrg, 0.0f, 0.0f);
                    Rectangle rectCropBox = reader.getCropBox(spPage.nPageId);
                    spPage.AddScribbles(cb, rectCropBox.top(), rectCropBox.left(), this.mapColors);
                    BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", false);
                    cb.beginText();
                    cb.setFontAndSize(bf, 11.0f);
                    cb.showTextAligned(1, spPage.nPageId + " / " + nPageCount, fWidth / 2.0f, 10.0f, 0.0f);
                    cb.endText();
                }
            } else {
                for (int nPage = 1; nPage <= reader.getNumberOfPages(); ++nPage) {
                    ScribblePage spPage = this.mapScribblePages.get(nPage);
                    document.newPage();
                    PdfImportedPage pageOrg = writer.getImportedPage(reader, nPage);
                    cb.addTemplate(pageOrg, 0.0f, 0.0f);
                    Rectangle rectCropBox = reader.getCropBox(nPage);
                    if (spPage == null) continue;
                    spPage.AddScribbles(cb, rectCropBox.top(), rectCropBox.left(), this.mapColors);
                }
            }
            document.close();
        }
        catch (Exception de) {
            de.printStackTrace();
            return false;
        }
        return true;
    }
}

