#!/bin/sh
#
# Idea of igorsk, script by Corwin & igorsk

PATH="/usr/local/bin:/usr/bin:/sbin:/bin:/usr/bin/X11:/usr/games:/usr/local/sony/bin:/usr/sbin"
LD_LIBRARY_PATH="/opt/sony/ebook/application:/lib:/usr/lib:/usr/local/sony/lib:/opt/sony/ebook/lib"
export PATH LD_LIBRARY_PATH


# Temp Working Filesystem
W_FS=/tmp
W_DIR=/tmp/self_upgrade
W_LOG=/tmp/make_fs.log
RESFILE=/tmp/result.log
M_CARD=`cat /tmp/cardroot`
PRS_VER=`cat /tmp/prsver`

# Binaries
stat_fs=/tmp/bin/stat_fs
date=/bin/date
mkdir=/bin/mkdir
rm=/bin/rm
tar=/bin/tar
mkcramfs=/usr/bin/mkcramfs
mcopy=/tmp/mcopy
#mcopy=/usr/bin/mcopy
chmod=/bin/chmod
du=/usr/bin/du
cut=/usr/bin/cut
nblsdm=/usr/local/sony/bin/nblsdm
umount=/bin/umount
mtdmount=/usr/local/sony/bin/mtdmount

# Max Image Size
if [ "$PRS_VER" = "500" ]; then 
  OPT_IMG_SIZE=7340032
else 
  OPT_IMG_SIZE=8650752
fi

echo -n "Begin make_opt -> " > $W_LOG
$date >> $W_LOG
echo "Card root: $M_CARD PRS version: $PRS_VER" >> $W_LOG

$mkdir -p /tmp/bin >> $W_LOG 2>&1
echo "Copying helper binaries" >> $W_LOG
$chmod -R ugo+rx /tmp/bin/* >> $W_LOG 2>&1

if [ ! -x $stat_fs ]; then
  echo "No stat_fs found!" >> $W_LOG
  echo -n "1 stat_fs not found." > $RESFILE
  exit 1;
fi

if [ -d $W_DIR ]; then
  echo "$W_DIR found! Cleaning ..." >> $W_LOG
  $rm -rf $W_DIR
fi

$mkdir -p $W_DIR/new_opt
echo "$W_DIR Created!" >> $W_LOG
$stat_fs -u /opt/ >>$W_LOG 2>&1

# Checking avaliable space
W_A_SIZE=`$stat_fs -a $W_FS`
OPT_U_SIZE=`$stat_fs -u /opt/`

# approximate needed space
N_SPACE=`expr $OPT_U_SIZE \* 2`

echo "Free space in $W_FS: $W_A_SIZE, used space in /opt: $OPT_U_SIZE" >> $W_LOG

if [ `expr $W_A_SIZE - $N_SPACE` -lt 1048576 ]; then
  echo "No space avaliable for making images!" >> $W_LOG
  echo -n "2 No space avaliable for making images. Try deleting some books." > $RESFILE
  exit 1
fi 

# Copy /opt/ -> working directory
echo "Begin copy of /opt" >> $W_LOG
if ! $tar -clf - -C /opt/ . | $tar xvpf - -C $W_DIR/new_opt/ >> $W_LOG 2>&1; then
  echo -n "2 Error copying /opt to $W_DIR/new_opt/" > $RESFILE
  exit 1
fi
echo "/opt copied to $W_DIR/new_opt/" >> $W_LOG

# Copy new files
echo "Begin copy of new files" >> $W_LOG
if ! $mcopy -pvns $M_CARD/files.$PRS_VER/opt/* $W_DIR/new_opt/ >> $W_LOG 2>&1; then
  echo -n "3 Error copying new files from $M_CARD/files.$PRS_VER/opt" > $RESFILE
  exit 1
fi
echo "New files copied" >> $W_LOG

# Creating cramfs
echo "Creating new cramfs image" >> $W_LOG
if ! $mkcramfs $W_DIR/new_opt/ $W_DIR/new_opt.img  >> $W_LOG 2>&1; then
  echo -n "4 Error creating new cramfs image. Not enough space?" > $RESFILE
  exit 1
fi
echo "Created cramfs $W_DIR/new_opt.img" >> $W_LOG

echo "Checking cramfs image size ...." >> $W_LOG
NEW_IMG_SIZE=`$du -b $W_DIR/new_opt.img | $cut -f 1`
echo "Cramfs image size: $NEW_IMG_SIZE" >> $W_LOG

if [ NEW_IMG_SIZE -gt OPT_IMG_SIZE ]; then
  echo "Opt image size is too big!" >> $W_LOG
  echo -n "5 The new cramfs image is too big for flashing." > $RESFILE
  exit 1
fi

# Flashing !!!
# $nblsdm create -i $W_DIR/new_opt.img Fsk
# $nblsdm cmp -i $W_DIR/new_opt.img Fsk
# $umount /opt
# $mtdmount -t cramfs Fsk /opt

# Debug
# $mcopy -pvnso $W_DIR/new_opt.img $M_CARD/  >> $W_LOG 2>&1;
# echo -n "Image copied " >> $W_LOG
# $date >> $W_LOG

#clear the temporary FS copy
if [ -d $W_DIR/new_opt ]; then
  $rm -rf $W_DIR/new_opt >> $W_LOG
fi

#$mcopy -pnso $W_LOG $M_CARD/

echo -n "Image created successfully" >> $W_LOG
echo -n "0 Image created successfully and can be flashed now." > $RESFILE
sync
sync
sync
sync
sync
sync
exit 0