#! /bin/bash

#ldconfig

PATH="/usr/local/bin:/usr/bin:/bin:/usr/bin/X11:/usr/games:/usr/local/sony/bin:/usr/sbin"
LD_LIBRARY_PATH="/opt/sony/ebook/application:/lib:/usr/lib:/usr/local/sony/lib:/opt/sony/ebook/lib"
export PATH LD_LIBRARY_PATH

# set initial date
/bin/date 0101000007

# temporarily mount /dev/mtdblock17 i.e. /Data
DATA_NUM=`grep Data /proc/mtd | awk -F: '{print $1}' | awk -Fd '{print$2}'`
umount /tmp/Data
rm -rf /tmp/Data
mkdir /tmp/Data
if [ $? == 0 ]; then
	mount /dev/mtdblock$DATA_NUM /tmp/Data
	if [ $? == 0 ]; then
		# run custom script
		if [ -s /tmp/Data/scripts/tinyhttp_custom.sh ]; then
			cp -f /tmp/Data/scripts/tinyhttp_custom.sh /tmp/tinyhttp_custom.sh
		fi
		if [ -s /tmp/tinyhttp_custom.sh ]; then
			chmod +x /tmp/tinyhttp_custom.sh
			/tmp/tinyhttp_custom.sh > /tmp/tinyhttp_custom.sh.log 2>&1
			if [ $? == 0 ]; then
				# success, remove the log
				rm -f /tmp/tinyhttp_custom.sh.log
			else
				# copy the log to /Data/scripts
				cp -f /tmp/tinyhttp_custom.sh.log /tmp/Data/scripts/tinyhttp_custom.sh.log
			fi
			rm -f /tmp/tinyhttp_custom.sh
		fi
		umount /tmp/Data
	fi
	rm -rf /tmp/Data
fi

#start kbook application
/opt/sony/ebook/application/tinyhttp
if [ $? == 0 ]; then
	if [ -r /tmp/exitcode ]; then
		CODE=`/bin/cat /tmp/exitcode`
		/bin/rm /tmp/exitcode
#		/bin/echo $CODE
		if [ $CODE == 3 ]; then
			mount | grep -q /opt/sony/ebook/FONT
			if [ $? == 0 ]; then
				umount /opt/sony/ebook/FONT
			fi
			NUM=`grep Data /proc/mtd | awk -F: '{print $1}' | awk -Fd '{print$2}'`
			/usr/local/sony/bin/mkdosfs /dev/mtdblock$NUM
			/bin/grep Data /etc/mtab > /dev/null
			if [ $? == 0 ]; then
#				/bin/echo reboot
				/sbin/reboot
			else
#				/bin/echo restart application				
				exec /opt/sony/ebook/bin/tinyhttp.sh
			fi
		elif [ $CODE == 4 ]; then	
			exec /opt/sony/ebook/bin/tinyhttp.sh
		elif [ $CODE == 5 ]; then
			umount /opt/sony/ebook/FONT >> /tmp/__my.log 2>&1
			mkdir /tmp/Data
			if [ $? == 0 ]; then
				mount /dev/mtdblock$DATA_NUM /tmp/Data
				if [ $? == 0 ]; then
					umount /tmp/Data
					mv /tmp/Data/scripts/tinyhttp_custom.sh /tmp/Data/scripts/tinyhttp_custom.sh.disabled
				fi
				rm -rf /tmp/Data
			fi
			exec /opt/sony/ebook/bin/tinyhttp.sh
		fi
	fi
#	/bin/echo shutdown
	/sbin/shutdown -h now
else
#	/bin/echo reboot
	/sbin/reboot
fi
