#!/bin/sh

# Starts or stops eth0(dhcp) together with dropbear ssh server
#
# The script may not work in all situations, for example
# if /etc/network/interfaces has been edited manually.
#
# TODO: don't tamper with /etc/network/interfaces, but
# instead start udhcpc manually and don't use ifup/ifdown
# but ifconfig and route...
#

# go to correct directory for './'s
scriptdir=`/usr/bin/dirname "$0"`
cd "$scriptdir"

# fix own perm
chmod a+x ./toggle_lan.sh

# install default allowed login key
if [ ! -f ~/.ssh/authorized_keys ]; then
	mkdir -p ~/.ssh
	chmod 700 ~/.ssh
	cp authorized_keys ~/.ssh/
	chmod 400 ~/.ssh/authorized_keys
fi

# generate host key
if [ ! -f /etc/dropbear/dropbear_dss_host_key ]; then
	mkdir -p /etc/dropbear/
	./dropbearkey -t dss -f /etc/dropbear/dropbear_dss_host_key
fi

# stop possibly running ssh server
killall dropbear 2>/dev/null

# make sure eth0 with dhcp is there
if [ ! -n "`grep '^iface eth0' /etc/network/interfaces`" ]; then
	echo "iface eth0 inet dhcp" >> /etc/network/interfaces
	echo "	pre-up modprobe smc91x" >> /etc/network/interfaces
	echo "	post-down rmmod smc91x" >> /etc/network/interfaces
fi
if [ ! -n "`grep '^auto lo' /etc/network/interfaces`" ]; then
	echo "auto lo" >> /etc/network/interfaces
	echo "iface lo inet loopback" >> /etc/network/interfaces
fi

# no automatic eth0 start
# --(removed since this can bomb...)
# sed -n "/auto eth0/d" /etc/network/interfaces > /var/tmp/ifc
# if [ -f /var/tmp/ifc ]; then mv /var/tmp/ifc /etc/network/interfaces; fi

# finally, toggle eth0 state
if [ -n "`/sbin/ifconfig | grep Ethernet | grep eth0`" ]; then
	killall udhcpc
	ifdown eth0
	cat manifest_noIP.xml > manifest.xml
else
	ifup eth0
	cat manifest_upper.xml > manifest.xml
	ipstr=`ifconfig eth0 | sed -n -e "s/\(.*\)inet addr:\(.*\)B.*$/\2/p"`
	echo " IP: $ipstr" >> manifest.xml
	cat manifest_lower.xml >> manifest.xml
	# dropbear: -s disable password logins, -g disable root password login,
	#           -w disallow root, -a allow remote hosts to connect to forwarded ports
	./dropbear
fi
