#!/usr/bin/perl -w

use strict;
use warnings;

use File::Basename;
use File::Copy;
use Getopt::Std;

my %opt;
my @suffix = ('.pdf','.PDF');
my @suffixPPM = ('.ppm','.PPM');
my @suffixTIF= ('.tif','.tiff','.TIF','.TIFF');
my $cur = 1;
opendir (TMPDIR, ".") or die "Error open dir [".$!."]\n";


my @aPDFiles
    = grep { 
            /(\.pdf|\.PDF)$/i  # Ends with ppm or pbm
            && -f "$_"          # and is a file
    } readdir(TMPDIR);

close TMPDIR;

foreach  my $file (sort @aPDFiles){
	$cur = 1;
    next unless -f "$file";
    print "File $file\n";
    my $bName = basename($file, @suffix);

    # Create PPM
	while(1){
		print"Convert $file: pg.[".$cur."].\n";

        # Create PPM
		system("/usr/bin/pdftoppm", "-r", "300", "-f", $cur, "-l", $cur, "$file", $bName);
    
        # Create TIFF 
    	opendir (TMPDIR, ".") or die "Error open dir [".$!."]\n";
        my @myPPM = grep { 
                /(\.ppm|\.pbm)$/i # Ends with pdf
                && -f "$_"        # and is a file
        } readdir(TMPDIR);
    	close TMPDIR;

		# If no PPM file then done going through PDF.
		# OCR next PDF.
		goto NEXT_PDF unless ($#myPPM gt -1); 

        foreach my $ppmName (@myPPM){
        	my $bNamePPM = basename($ppmName, @suffixPPM);
			print "PPM -> TIFF".$bNamePPM."\n";
        	system("ppm2tiff","-c","none","-R","300",$ppmName, $bNamePPM.".tif");
             unlink($ppmName);
        }
    
    
        # Create TEXT 
    	opendir (TMPDIR, ".") or die "Error open dir [".$!."]\n";
        my @myTIF
        = grep { 
                /(\.tiff|\.tif|\.TIF)$/i  # ith tif 
                && -f "$_"      # and is a file
        } readdir(TMPDIR);
    	close TMPDIR;
    
        foreach my $tifName (@myTIF){
    		my $bNameTXT = basename($tifName, @suffixTIF);
    		system("tesseract", $tifName, $bNameTXT); 
    		system("/usr/bin/convert", $tifName, $bNameTXT.".jpg"); 
            unlink($tifName);
        }
		$cur++;
	} 
NEXT_PDF:
}
