#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'

'''
holland.blogli.co.il
'''

from calibre.web.feeds.news import BasicNewsRecipe

class HebrewBlog(BasicNewsRecipe):
    title                 = 'Hebrew Blog'
    __author__            = 'Darko Miletic'
    description           = u'משפחה ישראלית נחתה בהולנד'
    publisher             = u''
    category              = u'news, Israel'    
    language              = _('Hebrew')
    lang                  = 'he'
    direction             = 'rtl'    
    oldest_article        = 20
    max_articles_per_feed = 100
    no_stylesheets        = True
    encoding              = 'utf8'
    remove_javascript     = True
    use_embedded_content  = False
    extra_css = '@font-face {font-family: "serif0";src:url(res:///Data/FONT/serif0.ttf)} body{direction: rtl; font-family: serif0, serif} .article_description{direction: rtl; font-family: serif0, serif} a.article{direction: rtl; font-family: serif0, serif} .calibre_feed_title{direction: rtl; font-family: serif0, serif} .calibre_feed_list{direction: rtl; font-family: serif0, serif} .calibre_feed_description{direction: rtl; font-family: serif0, serif} .feed{direction: rtl} .calibre_class_0{direction: rtl}'
    
    html2lrf_options = [
                          '--comment', description
                        , '--category', category
                        , '--publisher', publisher
                        , '--ignore-tables'
                        ]
    
    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"\nlinearize_tables=True'
     
    keep_only_tags = [
                        dict(name='div', attrs={'class':'post'})
                       ,dict(name='h3', attrs={'class':'post'})
                       ,dict(name='ol', attrs={'class':'commentlist'})
                     ]
    
    remove_tags = [
                     dict(name=['object','link','iframe','base'])
                  ]
    
                  
    feeds = [(u'HebrewBlog', u'http://holland.blogli.co.il/feed/')]

    def preprocess_html(self, soup):
        soup.html['xml:lang'] = self.lang
        soup.html['lang'    ] = self.lang
        soup.html['dir'     ] = self.direction
        for item in soup.findAll(style=True):
            del item['style']        
        return soup
