#!/bin/sh
set -x
cd `/usr/bin/dirname $0`

. ./utils.sh	# helper functions

if ! check_firmware; then
  adjust_manifest "Install $APP" "`date +%T`: Wrong firmware version" install.sh nok.png
  exit 1
fi

if ! ipkg install lua5.1-iliad-*.ipk lgob-iliad-*.ipk >>$LOG 2>&1; then
  adjust_manifest "Install $APP" "`date +%T`: Failed to install ipk's)" install.sh nok.png
  exit 1
else
  rm -f *.ipk
  adjust_manifest "Run $APP" "`date +%T`: Installation succesfull" run.sh ok.png
fi

exit 0	# okidoki

