#!/usr/local/bin/lua
--require 'lfs'
require 'lgob.gdk'
require 'lgob.gtk'
require("luacurl")

local app={}	-- application data

------- UTILS: LESS TYPING, MORE FUN --------------------------------------
-- extend the basic widget class
function gtk.Widget:cfg(tbl)
  if tbl then
    for k,v in pairs(tbl) do
      if type(v)=='function' then
        self:connect(k,v)
      elseif type(v)=='table' then
        self:connect(k,v[1],v[2])       -- function with user data
      else
        self:set(k,v)
      end
    end
  end
  return self
end

-- Shorcut for constructors
function gtk.button(tbl)
  return gtk.Button.new():cfg(tbl)
end
------- END OF UTILS --------------------------------------

-- progress function: is called by Curl once in a while
app.progressFunction = function (_, dltotal, dlnow, uptotal, upnow)

  -- refresh the progressbar while downloading
  local progress = 0
  if dltotal > 0 then progress = dlnow/dltotal end
  app.progresBar:cfg{
    fraction = progress,
    text = string.format('%2d%%', progress * 100)
  }
  
  -- Let gtk update the Gui
  while gtk.events_pending() do
    gtk.main_iteration()
  end

  -- abort if user cancelled the download
  local stop = 0
  if not app.download then 
    stop = 1
    app.cancel_download()
  end
  return stop
end

---------------------------------------------------------------------------
function doDownload(url, file)
  local c=curl.new()
  c:setopt(curl.OPT_WRITEFUNCTION, function (stream, buffer)
        if stream:write(buffer) then
                return string.len(buffer);
        end
  end);

  c:setopt(curl.OPT_WRITEDATA, io.open(file, "wb"));
  c:setopt(curl.OPT_PROGRESSFUNCTION, app.progressFunction)
  c:setopt(curl.OPT_FOLLOWLOCATION, true);
  c:setopt(curl.OPT_NOPROGRESS, false)
  c:setopt(curl.OPT_URL, url)
  c:setopt(curl.OPT_CONNECTTIMEOUT, 10)
  c:perform()
  --c:close()	-- Don't close, 2nd download crashes on GC ?!?!
  c=nil
end

------- Button callbacks -----------------------------------------
function do_quit() quit=true end
function do_it() print 'Do it!' end

app.start_download = function()
  app.start:set_sensitive(false); app.cancel:set_sensitive(true)
  app.download=true
end

app.cancel_download = function()
  app.start:set_sensitive(true); app.cancel:set_sensitive(false)
  app.download=false
end

------- GUI ---------------------------------------------------------------
local window = gtk.Window.new()

if false then
window:set_resizable(false)
--window:set_position(gtk.WIN_POS_NONE)
--window:move(0,0)
--window:set('decorated',false)
else
window:fullscreen()
window:set_keep_above(true)
end

local w_top=gtk.VBox.new();      window:add(w_top)
local w_buttons=gtk.HBox.new();  w_top:pack_start(w_buttons,false)

	local w_do_it = gtk.button {label="Do it!", clicked=do_it}
        w_buttons:add(w_do_it)

	local w_quit = gtk.button {label="Quit", clicked=do_quit}
        w_buttons:add(w_quit)

local w_download=gtk.HBox.new();  w_top:pack_start(w_download,false)
	app.start = gtk.button {
          label="Start download",
          clicked = app.start_download
        }
        w_download:pack_start(app.start, false)

	app.cancel = gtk.button {
          label="Cancel download",
          clicked = app.cancel_download
        }
        w_download:pack_start(app.cancel, false)

	app.progresBar = gtk.ProgressBar.new()
        w_download:pack_start(app.progresBar, true)
        app.progresBar:set_width_request(300)
        app.progresBar:modify_bg(gtk.STATE_NORMAL, gdk.color_parse('white'))
        window:modify_bg(gtk.STATE_NORMAL, gdk.color_parse('white'))
---------------------------------------------------------------------------

local w_info = gtk.Label.new()
w_info:set_label("This is Zorro\nUpgrade your Iliad")
w_top:pack_start(w_info, true)

window:connect("delete-event", do_quit)

app.cancel_download()
window:show_all()

-- Main loop --------------------------------------------------------------
local url  = 'http://ftp.gnome.org/pub/gnome/sources/glib/2.6/glib-2.6.6.tar.gz'
local file = 'glib.tgz'

while not quit do
  gtk.main_iteration()
  if app.download then
    doDownload(url, file)
    app.cancel_download()	-- just to enable the rightbuttons
  end
end

