#!/bin/sh
scriptdir=`/usr/bin/dirname "$0"`
Firmware_iLiad=`cat /etc/er_version_commercial`
cd "$scriptdir"
Firmware_Script=`cat Firmware_Script`

#remove this script from 'Recent Documents'`
RECENT=/var/recentdocuments/
HERE=`pwd`
LINK=$RECENT`(ls -l $RECENT | grep $HERE | awk '{print $9}')`
if [ ! $LINK = $RECENT ]; then
  rm $LINK
fi

if [ "$Firmware_iLiad" = "$Firmware_Script" ]; then
	# Backup registry
	if [ ! -f /mnt/settings/registry.xml.orig ]; then
	    cp /mnt/settings/registry/registry.xml /mnt/settings/registry.xml.orig
	fi

	# Russian localization
	ipkg install -force-overwrite -force-defaults russian_0.1_arm.ipk
	sed -n -i -f russian-registry-update.sed /mnt/settings/registry/registry.xml
	ipkg install -force-overwrite -force-defaults matchbox-keyboard_svn20090323_ruslat_arm.ipk

	# FBReader (also handles txt)
	ipkg install -force-overwrite -force-defaults pixbuf-loaders_0.1_arm.ipk
	ipkg install -force-overwrite -force-defaults fbreader_0.8.14-iliad.0.1_arm.ipk 
	sed -n -i -f fbreader-registry-update.sed /mnt/settings/registry/registry.xml
	cat ui.xml > /mnt/settings/.FBReader/ui.xml

	#JavaDJVU
	ipkg install -force-overwrite -force-defaults javadjvu_0.4_arm.ipk
	sed -n -i -f javadjvu-registry-update.sed /mnt/settings/registry/registry.xml

	sync
	reboot

else
	# wrong firmware version, error message
	mv manifest.xml install.xml
	cat wrong_fw.xml | sed -e "s/Firmware_Script_xml/$Firmware_Script/" | sed -e "s/Firmware_iLiad_xml/$Firmware_iLiad/" > manifest.xml
fi

