<?php
	/**
	*	~=< WELCOME TO FFLAG >=~
	*	Dependencies:
	*	  php5-cli (PHP 5.x commandline interpreter)
	*	  php5-curl (CURL module for PHP 5.x)
	*	  php5-tidy (HTML cleaner)
	*
	*   html2lrf (from Calibre) - for BBeB output only
	*
	*   Written by: erayd
	*   Windows version written by: rgibbo
	*	Mod by: aerischan
	*/

	//Setup environment
	ini_set('pcre.backtrack_limit', 1000000);

	//Change to current dir
	chdir(dirname(__FILE__));

	//Get the error console reference
	$errfile = fopen('php://stderr', 'w');

	//Config
	require_once('inc/args.inc.php');
	$config['source'] = 'ffnet';
	$config['format'] = 'news';
	$config['storyid'] = $_GET['storyid'];

	//Main includes
	require_once('inc/misc.inc.php');
	require_once("source/{$config['source']}.source.php");
	require_once('codec/html.codec.php');
	require_once("codec/{$config['format']}.codec.php");

	//Various function names
	$check_deps_func = "check_deps_{$config['format']}";
	$get_story_func = "{$config['source']}_get_story";
	$convert_func = "convert_story_{$config['format']}";

	//Check Dependencies
	check_deps_html();
	$check_deps_func();

	//Main Application Logic
	$story = $get_story_func($config['storyid']);
	$output = $convert_func($story);

	//Output the compiled file if it the story is valid
	if ($story['meta']['title'] != "") {
		//Output file
		echo $output;
	}

	//Cleanup
	fclose($errfile);

?>
