<?php

///provide information on codec
function html_codec_info() {
	return "\tStandard HTML";
}

///check dependencies
function check_deps_html() {
	//there are no external dependencies for html, so only check internal ones
	if(!function_exists('curl_exec')) printFatalErr('Dependency php5-curl is missing!');
	if(!function_exists('tidy_repair_string')) printFatalErr('Dependency php5-tidy is missing!');
}

///convert story format to HTML
function convert_story_html($story, $simpletos = false) {
	global $config;

	//load dependencies
	$csstext = file_get_contents(dirname(__FILE__) . '/../tpl/main.css');

	//head & cover
	$s = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n";
	$s .= "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
	$s .= "<html>\n";
	$s .= "\t<head>\n";
	$s .= "\t<meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />\n";
	$s .= "\t<meta name=\"storyid\" content=\"{$config['storyid']}\" />\n";
	$s .= "\t<meta name=\"author\" content=\"{$story['meta']['author']}\" />\n";
	if(!($story['meta']['category'] == '')) $s .= "\t<meta name=\"category\" content=\"{$story['meta']['category']}\" />\n";
	if(!($story['meta']['genre'] == '')) $s .= "\t<meta name=\"genre\" content=\"{$story['meta']['genre']}\" />\n";
	if(!($story['meta']['rating'] == '')) $s .= "\t<meta name=\"rating\" content=\"{$story['meta']['rating']}\" />\n";
	if(!($story['meta']['summary'] == '')) {
		$summary = str_replace("\x22", "&quot\x3B", $story['meta']['summary']);
		$s .= "\t<meta name=\"summary\" content=\"{$summary}\" />\n";
	}
	if(!($story['meta']['ficstatus'] == '')) $s .= "\t<meta name=\"ficstatus\" content=\"{$story['meta']['ficstatus']}\" />\n";
	$s .= "\t<title>{$story['meta']['title']}</title>\n";
	$s .= "\t<style type='text/css'>$csstext</style>\n";
	$s .= "\t</head>\n";
	$s .= "\t<body>\n";
	$s .= "\t\t<div class='cover'>\n";
	$s .= "\t\t\t<h1>{$story['meta']['title']}</h1>\n";
	$s .= "\t\t\t<h2>by ~ {$story['meta']['author']} ~</h2>\n";
	$s .= "\t\t\t<span class='meta'>\n";
	if(!($story['meta']['category'] == '')) $s .= "\t\t\t<b>Category:</b> {$story['meta']['category']}<br />\n";
	if(!($story['meta']['genre'] == '')) $s .= "\t\t\t<b>Genre:</b> {$story['meta']['genre']}<br />\n";
	if(!($story['meta']['rating'] == '')) $s .= "\t\t\t<b>Rating:</b> {$story['meta']['rating']}<br />\n";
	if(!($story['meta']['ficstatus'] == '')) $s .= "\t\t\t<b>Status:</b> {$story['meta']['ficstatus']}<br />\n";
	if(!($story['meta']['summary'] == '')) $s .= "\t\t\t<b>Summary:</b> {$story['meta']['summary']}<br />\n";

	$s .= "\t\t\t</span>\n";
	$s .= "\t\t</div>\n";

	if(!isset($config['notoc']) && count($story['meta']['chapters']) > 1) {
		$s .= "\t\t<div class='chapter'>\n";
		$s .= "\t\t\t<h3>Table of Contents</h3><hr />\n";
		$s .= "\t\t\t<div class='chaptercontent'>\n";

		if(!$simpletos) {
			$s .= "\t\t\t\t<table style='width: 100%;'>\n";
			foreach($story['meta']['chapters'] as $key => $title) {
				$s .= "\t\t\t\t\t<tr>\n";
				$s .= "\t\t\t\t\t\t<td>Chapter $key</td>\n";
				$s .= "\t\t\t\t\t\t<td class='ralign'><a href='#chap_$key'>$title</a></td>\n";
				$s .= "\t\t\t\t\t</tr>\n";
			}
			$s .= "\t\t\t\t</table>\n";
		}
		else {
			$s .= "\t\t\t\t<ol>\n";
			foreach($story['meta']['chapters'] as $title) {
				$s .= "\t\t\t\t<li>$title</li>\n";
			}
			$s .= "\t\t\t\t</ol>\n";
		}

		$s .= "\t\t\t</div>\n";
		$s .= "\t\t\t<hr />\n";
		$s .= "\t\t</div>\n";
	}

	//chapter content
	foreach($story['meta']['chapters'] as $key => $title) {
		$s .= "\t\t<div class='chapter'>\n";
		$s .= "\t\t\t<a name='chap_$key' />\n";
		$s .= "\t\t\t<h3>$key. $title</h3><hr />\n";
		$s .= "\t\t\t<div class='chaptercontent'>\n" . $story['pages'][$key] . "\n</div>\n";
		$s .= "\t\t\t<hr />\n";
		$s .= "\t\t</div>\n";
	}

	//tail
	$s .= "\t</body>\n";
	$s .= "</html>\n";

	$s = cleanString($s);
	$s = iconv('UTF-8', 'ISO-8859-15//TRANSLIT//IGNORE', $s);
	$tconf["wrap"] = 0;
	$s = tidy_repair_string($s, $tconf);

	return $s;
}

?>