<?php

//Provide info on codec
function epub_codec_info() {

	//Return the info
	return "\tOpen ebook format based on xml / zip";
}

//Check Dependencies
function check_deps_epub() {

	//No Internal Dependecies for epub, check the external ones
	if (!shell_exec('which html2epub') && !shell_exec('html2epub')) printFatalErr('Dependency html2epub (part of Calibre is missing - is Calibre installed?');
}

//Convert story format to EPUB
function convert_story_epub($story) {

	//Get global references
	global $config;

	//Set up file names
	$fname = 'fflag' . PID . $config['storyid'];
	$temp_fname = TEMP . '/' . $fname;

	//Get the converted HTML story
	file_put_contents("$temp_fname.html", convert_story_html($story));
	
	//Goto to the temp folder
	chdir(TEMP);

	//XPath for chapter detection
	$cli_chapter = "";
	$cli_chapter .= " --level1-toc \"//*[@class='chaptertitle']\"";
	$cli_chapter .= " --chapter \"//*[@class='chapter']\" --chapter-mark pagebreak";

	//metadata
	$cli_metadata = "";
	$cli_metadata .= " -t \"{$story['meta']['title']}\"";
	$cli_metadata .= " -a \"{$story['meta']['author']}\"";
	if(!($story['meta']['category'] == '')) $cli_metadata .= " --subjects \"{$story['meta']['category']}\"";
	$cli_metadata .= " --publisher \"{$story['source']}\"";
	$cli_metadata .= " --comment \"<b>Story id:</b> {$story['meta']['id']}";
	if(!($story['meta']['category'] == '')) $cli_metadata .= "<br><b>Category:</b> {$story['meta']['category']}";
	if(!($story['meta']['genre'] == '')) $cli_metadata .= "<br><b>Genre:</b> {$story['meta']['genre']}";
	if(!($story['meta']['rating'] == '')) $cli_metadata .= "<br><b>Rating:</b> {$story['meta']['rating']}";
	if(!($story['meta']['ficstatus'] == '')) $cli_metadata .= "<br><b>Status:</b> {$story['meta']['ficstatus']}";
	if(!($story['meta']['summary'] == '')) $cli_metadata .= "<br><b>Summary:</b> {$story['meta']['summary']}";
	$cli_metadata .= '"';

	//Create the epub content and store it in a temp file
	exec("html2epub $cli_chapter $cli_metadata \"$temp_fname.html\"");
	$result = file_get_contents("$temp_fname.epub");

	//Delete the files used
	unlink("$temp_fname.html");
	unlink("$temp_fname.epub");

	//Return the result
	return $result;
}

?>