import prc, sys, struct
from binascii import hexlify

def strSWord(s,off=0):
    return struct.unpack(">h",s[off:off+2])[0];

def strDWord(s,off=0):
    return struct.unpack(">L",s[off:off+4])[0];

def main(fname):
  try:
	db = prc.File(fname)
  except:
	print "NOT MOBI", fname
	return 1

  if db.getDBInfo()["creator"]!='MOBI':
    print "NOT MOBI", fname
    return 1
  rec0 = db.getRecord(0)[0]
  if len(rec0)<0x28 or rec0[0x10:0x14] != 'MOBI':
    print "NOT MOBI:", fname
    return 1
  enc = strSWord(rec0, 0xC)
  if enc!=2:
	print "DRM-free", fname 
  else:
	print "DRM     ", fname
  return 0

#print "kindlepid version 0.1 by Alan Wallcraft"
#print "Based on kindlefix by Igor Skochinsky"
if len(sys.argv)!=2:
  print "Checks for DRM in Kindle (AZW) ebooks"
  print "Usage: kindledrm.py file.azw"
else:  
  fname = sys.argv[1]
  sys.exit(main(fname))
