/*
 * xepdmgr_einkfb.h
 *
 * Access to the einkfb funtionality.
 *
 * Header file.
 *
 * History:
 *      20/11/2008 DRF Creation.
 *
 * Authors:
 *      DRf Dario Rodriguez dario@softhome.net
 *
 * This program is licensed under the terms of the GNU GPL v3
 */

#ifndef XEPDMGR_EINKFB_H
#define XEPDMGR_EINKFB_H
typedef void *sEink;

sEink *EinkInit(void);
void EinkFini(sEink *Eink);
int EinkWaveformUpload(sEink *Eink, char *Waveform); /* Waveform is 128 kbytes */
/* The following functions return usecs left to complete request, negative on error */
int EinkBlank(sEink *Eink);
int EinkUpdateFull(sEink *Eink, int UseTyping, int Fast);
int EinkUpdatePartial(sEink *Eink, int x1, int y1, int x2, int y2, int UseTyping, int Fast);
#endif

