#!/bin/sh

DIR=$scriptdir/..	# always called from a subdir
MAIN=$DIR/00_install	# main menu line
LOGFILE=$DIR/_install.log
DATE=`date '+%x  %r'`

START='/home/root/start.sh'	# the script that starts contentLister

#Set icon an description according to install result
log_success() {
	sed -e "s|_DESCR_|SUCCESS: $1  ($DATE)|" manifest.xml | \
	sed -e "s|_ICON_|icon_ok.png|"> $MAIN/manifest.xml
        echo "SUCCES: $1"
}

log_failed() {
	echo $1
	sed -e "s|_DESCR_|ERROR: $1  ($DATE)|" manifest.xml | \
	sed -e "s|_ICON_|icon_nok.png|"> $MAIN/manifest.xml
        echo "ERROR: $1"
}

# Dump everything from now on to the log file
exec 1>> $LOGFILE 2>> $LOGFILE

#remove this script from 'Recent Documents'`
RECENT=/var/recentdocuments/
HERE=`pwd`
LINK=$RECENT`(ls -l $RECENT | grep $HERE | awk '{print $9}')`
if [ ! $LINK = $RECENT ]; then
  rm $LINK
fi

cd $DIR/_files
# Assume the worst case (installation failed) and echo a start message
log_failed "Starting installation"

Firmware_iLiad=`cat /etc/er_version_commercial`
Firmware_Script=`cat Firmware_Script`

if echo $Firmware_iLiad | grep $Firmware_Script - ; then
        STATUS="OK"
	if do_it; then
		log_success  "$STATUS."
	else
		log_failed "$STATUS."
	fi
else
	# Wrong firmware version
	log_failed "Firmware $Firmware_Script is needed, your iLiad has got $Firmware_iLiad."
fi
