#!/bin/sh
scriptdir=`/usr/bin/dirname $0`
cd $scriptdir

MAIN=../install
# Log file
LOGDIR=../logfile
LOGFILE=$LOGDIR/install-log.txt
mkdir $LOGDIR
rm $LOGFILE

# Functions for updating the log file
log_success()
{
	cp manifest_ok.xml $LOGDIR/manifest.xml
	cp icon_ok.png $LOGDIR/icon.png
        echo "Install successful"
}

log_failed()
{
	echo $1
	cat manifest_failed.xml | sed -e "s/ERROR/$1/" > $LOGDIR/manifest.xml
	cp icon_failed.png $LOGDIR/icon.png
}

# Dump everything from now on to the log file
exec 1>> $LOGFILE 2>> $LOGFILE

# Assume the worst case (installation failed) and echo a start message
log_failed "Starting installation"

Firmware_iLiad=`cat /etc/er_version_commercial`
Firmware_Script=`cat Firmware_Script`

if [ "$Firmware_iLiad" = "$Firmware_Script" ]; then
	do_it()
	log_succes "Okidoki"
else
	# Wrong firmware version
	log_failed "Firmware $Firmware_Script is needed, your iLiad has got $Firmware_iLiad."
fi
