#!/bin/sh
scriptdir=`/usr/bin/dirname $0`
cd $scriptdir

# this function will be executed in ../_files 
do_it() {
  if [ ! -x $START ]; then
    STATUS="$START: no such script"
    return 1
  fi

  if ! grep -q NEWLISTER $START; then
    STATUS="No newLister in $START, not installed?"
    return 1
  fi

  if ! grep -q /usr/bin/contentLister $START; then
    STATUS="Cannot uninstall: no contentLister in $START"
    return 1
  fi

  echo "Edit start script..."
  awk -f newLister_uninstall.awk $START >$START.tmp
  chmod +x $START.tmp
  mv $START.tmp $START

  echo "Remove files"
  rm /usr/share/contentlister/newcursor.png
  rm /usr/share/contentlister/newLister.rc
  rm /usr/bin/newLister
  STATUS='newLister removed, contentLister restored'
  return 0	#OK
}
. ../_files/run_common.sh
