#!/usr/bin/python

import tarfile, gzip, array, md5, os.path, re
from binascii import hexlify

def md(s): #opposite of dm
  arr = array.array('B',s)
  for i in xrange(len(arr)):
    b = arr[i]
    b = (b>>4 | b<<4)&0xFF
    arr[i] = b^0x7A
  return arr.tostring()

def s_md5(s): #return md5 in string format
  m = md5.new()
  m.update(s)
  return hexlify(m.digest())

def make_bin(filename,basename, filelist):
    tgz_fname = "temp.tar.gz"
    tar = tarfile.open(tgz_fname,"w:gz")

    dat_list = ""
    for name in filelist:
      tarinfo = tar.gettarinfo(name)
      tarinfo.uid = tarinfo.gid = 0
      tarinfo.uname = tarinfo.gname = "root"
      if name.endswith(".ffs"):
        tarinfo.mode = 0100755 #rwxr-xr-x
        fid = 129
	prepend="update"
      else:
        tarinfo.mode = 0100644 #rw-r--r--
        fid = 128
	prepend="update_data"
      tarinfo.type = tarfile.REGTYPE
      inf = file(name,"rb")
      tar.addfile(tarinfo, inf)
      inf.seek(0)
      #129 a2592fe6898d468fd64f00c5b4b04ad7 test.sh 0 Test_script
      dat_list+="%d %s %s %d %s_%s\n"%(fid, s_md5(inf.read()), name, os.path.getsize(name)/64, prepend, re.sub('\..*$','',name))


    file(basename+".dat","wb").write(dat_list)
    tar.add(basename+".dat")
    tar.close()

    BLOCK_SIZE=131072
    BLOCK_SIZE=64
    f = file(tgz_fname, "rb").read()
    of = file(filename,"wb")
#   of.write("FB01"+"\0"*12)
# Changed header to write the version (291330095 / 303870012) and the device (2)
    #of.write("FC02"+"\0\0\0\x64"+"\0xFF\0xC9\0x9A\0x3B"+"\x02\x00"+"\x00\xae")
    of.write("FC02"+"\x2F\x58\x5D\x11"+"\x53\xA3\x9A\x3B"+"\x02\x00"+"\x00\x13")
#   of.write("FC02"+"\x3C\xB0\x1C\x12"+"\x53\xA3\x9A\x3B"+"\x02\x00"+"\x00\x13")
    of.write(md(s_md5(f)))
    of.write("\0"*(BLOCK_SIZE - of.tell()))
    of.write(md(f))

print "Kindle Firmware Update maker 0.1 Copyright (c) 2007 Igor Skochinsky"
print "and screwed up by dave maez to (very limitedly) work for the Kindle2 instead." 

#edit this if you want to add/remove files
filelist = ["291330095-999990099.ffs","fix_screen_dir"]
make_bin("Update_kindle2_user_screen_savers.bin","update-291330095-999990099", filelist)
filelist = ["uninstall.ffs"]
make_bin("Update_kindle2_restore_default_screen_savers.bin","update-291330095-999990099", filelist)
