#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'
'''
www.metronews.ca
'''

from calibre.web.feeds.news import BasicNewsRecipe

class MetroNews(BasicNewsRecipe):
    title                 = 'Metronews.ca'
    language              = _('English')
    __author__            = 'Darko Miletic'
    description           = 'news from Canada'    
    publisher             = 'Metronews.ca'
    category              = 'news, politics, Canada'    
    oldest_article        = 1000
    max_articles_per_feed = 100
    encoding              = 'utf-8'
    use_embedded_content  = True
    
    html2lrf_options = [
                          '--comment', description
                        , '--category', category
                        , '--publisher', publisher
                        ]
    
    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"' 

    feeds = [
               (u'Local news', u'http://www.metronews.ca/Toronto/local/rss')
               ,(u'World news', u'http://www.metronews.ca/Toronto/world/rss')
               ,(u'Canada', u'http://www.metronews.ca/Toronto/canada/rss')
               ,(u'Business', u'http://www.metronews.ca/Toronto/business/rss')
               ,(u'Sports', u'http://www.metronews.ca/Toronto/sports/rss')
               ,(u'Entertainment', u'http://www.metronews.ca/Toronto/entertainment/rss')
               ,(u'Comment news', u'http://www.metronews.ca/Toronto/comment/rss')
            ]
 
    def preprocess_html(self, soup):
        mtag = '<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>'
        soup.head.insert(0,mtag)    
        return soup
