/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_Float
implements Serializable {
    int increment_size = 25;
    int current_item = 0;
    int max_size = 25;
    private float[] items = new float[this.max_size];

    public Vector_Float() {
    }

    public Vector_Float(int n) {
        this.max_size = n;
        this.items = new float[this.max_size];
    }

    public void finalize() {
        this.items = null;
    }

    public final float[] get() {
        return this.items;
    }

    public final void removeElementAt(int n) {
        if (n >= 0) {
            for (int i = n; i < this.current_item - 1; ++i) {
                this.items[i] = this.items[i + 1];
            }
            this.items[this.current_item - 1] = 0.0f;
        } else {
            this.items[0] = 0.0f;
        }
        --this.current_item;
    }

    public final boolean contains(int n) {
        boolean bl = false;
        for (int i = 0; i < this.current_item; ++i) {
            if (this.items[i] != (float)n) continue;
            i = this.current_item + 1;
            bl = true;
        }
        return bl;
    }

    public final void addElement(float f) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = f;
        ++this.current_item;
    }

    public final void set(float[] fArray) {
        this.items = fArray;
    }

    public final float elementAt(int n) {
        if (n >= this.max_size) {
            this.checkSize(n);
        }
        return this.items[n];
    }

    public final void clear() {
        this.items = null;
        this.items = new float[this.max_size];
        this.current_item = 0;
    }

    public final void reuse() {
        this.current_item = 0;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void setElementAt(float f, int n) {
        if (n >= this.max_size) {
            this.checkSize(n);
        }
        this.items[n] = f;
    }

    private final void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            float[] fArray = this.items;
            this.items = new float[this.max_size];
            System.arraycopy(fArray, 0, this.items, 0, n2);
            if (this.increment_size < 500) {
                this.increment_size *= 2;
            }
        }
    }
}

