/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;

public class DecodePredictor {
    private boolean eof_ = false;
    private int pred_;
    private int colors_;
    private int bitsper_;
    private byte[] lastline_;
    private byte[] line_;
    private int linei_;
    private int col0_;
    private int rowlen_;

    public DecodePredictor(ByteArrayInputStream byteArrayInputStream, int n, Map map) {
        this.pred_ = n;
        this.colors_ = 1;
        String string = (String)map.get("Colors");
        if (string != null) {
            this.colors_ = Integer.parseInt(string);
        }
        this.bitsper_ = 8;
        string = (String)map.get("BitsPerComponent");
        if (string != null) {
            this.bitsper_ = Integer.parseInt(string);
        }
        int n2 = 1;
        string = (String)map.get("Columns");
        if (string != null) {
            n2 = Integer.parseInt(string);
        }
        this.col0_ = (this.colors_ * this.bitsper_ + 7) / 8;
        this.rowlen_ = (n2 * this.colors_ * this.bitsper_ + 7) / 8 + this.col0_;
        this.line_ = new byte[this.rowlen_];
        this.lastline_ = new byte[this.line_.length];
        this.nextRow(byteArrayInputStream);
    }

    private void nextRow(ByteArrayInputStream byteArrayInputStream) {
        int n;
        int n2;
        byte[] byArray = this.lastline_;
        this.lastline_ = this.line_;
        byte[] byArray2 = this.line_ = byArray;
        byte[] byArray3 = this.lastline_;
        this.linei_ = this.col0_;
        int n3 = this.pred_;
        if (n3 == 15) {
            n3 = byteArrayInputStream.read();
            if (n3 == -1) {
                this.eof_ = true;
                return;
            }
            n3 += 10;
        } else if (n3 >= 10) {
            byteArrayInputStream.read();
        }
        int n4 = this.rowlen_;
        for (n = 0 + this.col0_; n < n4; n += n2) {
            n2 = byteArrayInputStream.read(byArray2, n, n4 - n);
            if (n2 != -1) {
                continue;
            }
            this.eof_ = true;
            return;
        }
        n4 = (this.colors_ * this.bitsper_ + 7) / 8;
        switch (n3) {
            case 1: {
                break;
            }
            case 2: {
                for (n2 = 0 + this.col0_; n2 < n; ++n2) {
                    int n5 = n2;
                    byArray2[n5] = (byte)(byArray2[n5] + byArray2[n2 - n4]);
                }
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                for (n2 = 0 + this.col0_; n2 < n; ++n2) {
                    int n6 = n2;
                    byArray2[n6] = (byte)(byArray2[n6] + byArray2[n2 - n4]);
                }
                break;
            }
            case 12: {
                for (n2 = 0 + this.col0_; n2 < n; ++n2) {
                    int n7 = n2;
                    byArray2[n7] = (byte)(byArray2[n7] + byArray3[n2]);
                }
                break;
            }
            case 13: {
                for (n2 = 0 + this.col0_; n2 < n; ++n2) {
                    int n8 = n2;
                    byArray2[n8] = (byte)(byArray2[n8] + ((byArray2[n2 - n4] & 0xFF) + (byArray3[n2] & 0xFF)) / 2);
                }
                break;
            }
            case 14: {
                n2 = 0 + this.col0_;
                while (n2 < n) {
                    int n9 = byArray2[n2 - n4] & 0xFF;
                    int n10 = byArray3[n2] & 0xFF;
                    int n11 = byArray3[n2 - n4] & 0xFF;
                    int n12 = n9 + n10 - n11;
                    int n13 = Math.abs(n12 - n9);
                    int n14 = Math.abs(n12 - n10);
                    int n15 = Math.abs(n12 - n11);
                    int n16 = n13 <= n14 && n13 <= n15 ? n9 : (n14 <= n15 ? n10 : n11);
                    int n17 = n2++;
                    byArray2[n17] = (byte)(byArray2[n17] + (byte)n16);
                }
                break;
            }
        }
    }

    public int read(ByteArrayInputStream byteArrayInputStream, byte[] byArray, int n, int n2) throws IOException {
        if (this.eof_) {
            return -1;
        }
        if (this.linei_ == this.rowlen_) {
            this.nextRow(byteArrayInputStream);
            return this.read(byteArrayInputStream, byArray, n, n2);
        }
        n2 = Math.min(n2, this.rowlen_ - this.linei_);
        System.arraycopy(this.line_, this.linei_, byArray, n, n2);
        this.linei_ += n2;
        return n2;
    }

    public int read(ByteArrayInputStream byteArrayInputStream) throws IOException {
        int n;
        if (this.eof_) {
            n = -1;
        } else if (this.linei_ < this.rowlen_) {
            n = this.line_[this.linei_++] & 0xFF;
        } else {
            this.nextRow(byteArrayInputStream);
            return this.read(byteArrayInputStream);
        }
        return n;
    }
}

