/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import java.awt.image.BufferedImage;
import java.io.File;
import org.jpedal.PdfDecoder;
import org.jpedal.fonts.PdfFont;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.utils.LogWriter;

public class ExtractPagesAsThumbnails {
    private String user_dir = System.getProperty("user.dir");
    public static boolean outputMessages = false;
    public static boolean multipleSizes = true;
    String output_dir = "";
    String separator = System.getProperty("file.separator");
    PdfDecoder decode_pdf = null;
    private static String format = "png";
    private String[] ocr = new String[]{"TeleForm"};
    private static String test_file = "/mnt/shared/sample_pdfs/general/World Factbook.pdf";
    public static boolean isTest = false;

    public ExtractPagesAsThumbnails() {
    }

    public ExtractPagesAsThumbnails(String string, String string2) {
        PdfFont.setStandardFontMappings();
        this.output_dir = string2;
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(string, string2);
        } else {
            String[] stringArray = null;
            File file = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    if (outputMessages) {
                        System.out.println(string + stringArray[n]);
                    }
                    this.decodeFile(string + stringArray[n], string2);
                }
                ++n;
            }
        }
        if (outputMessages) {
            System.out.println("Thumbnails created");
        }
    }

    private void decodeFile(String string, String string2) {
        String string3 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n != -1) {
            string3 = string.substring(n + 1, string.length() - 4);
        }
        if (string2 == null) {
            string2 = this.user_dir + "thumbnails" + this.separator;
        }
        for (int i = 1; i < 3; ++i) {
            int n2 = i * 72;
            try {
                this.decode_pdf = new PdfDecoder();
                this.decode_pdf.setExtractionMode(0, 72, i);
                if (outputMessages) {
                    System.out.println("Opening file :" + string + " at " + n2 + " dpi");
                }
                this.decode_pdf.openPdfFile(string);
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " in pdf code");
            }
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isExtractionAllowed()) {
                if (outputMessages) {
                    System.out.println("Encrypted settings");
                    System.out.println("Please look at SimpleViewer for code sample to handle such files");
                }
            } else {
                File file = new File(string2);
                if (!file.exists()) {
                    file.mkdirs();
                }
                int n3 = 1;
                int n4 = this.decode_pdf.getPageCount();
                if (n4 > 10 && isTest) {
                    n4 = 10;
                }
                if (outputMessages) {
                    System.out.println("Thumbnails will be in  " + string2);
                }
                try {
                    for (int j = n3; j < n4 + 1; ++j) {
                        int n5;
                        if (outputMessages) {
                            System.out.println("Page " + j);
                        }
                        String string4 = string3 + "_" + n2 + "_page_" + j;
                        if (format.equals("jpg")) {
                            this.decode_pdf.setThumbnaiImageTransparency(false);
                        } else {
                            this.decode_pdf.setThumbnaiImageTransparency(true);
                        }
                        PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
                        String[] stringArray = pdfFileInformation.getFieldValues();
                        String[] stringArray2 = pdfFileInformation.getFieldNames();
                        for (int k = 0; k < stringArray2.length; ++k) {
                            if (!stringArray2[k].equals("Creator")) continue;
                            for (n5 = 0; n5 < this.ocr.length; ++n5) {
                                if (!stringArray[k].equals(this.ocr[n5])) continue;
                                this.decode_pdf.setRenderMode(2);
                                this.decode_pdf.setEnableLegacyJPEGConversion(true);
                            }
                        }
                        BufferedImage bufferedImage = this.decode_pdf.getPageAsImage(j);
                        if (bufferedImage == null) {
                            if (outputMessages) {
                                System.out.println("No image generated - are you using client mode?");
                            }
                        } else {
                            n5 = ObjectStore.saveStoredImage(string2 + j + string4, bufferedImage, true, false, format) ? 1 : 0;
                        }
                        this.decode_pdf.flushObjectValues(true);
                    }
                }
                catch (Exception exception) {
                    this.decode_pdf.closePdfFile();
                    System.err.println("Exception " + exception.getMessage() + " with thumbnails");
                }
            }
            if (multipleSizes) continue;
            i = 2;
        }
        this.decode_pdf.closePdfFile();
    }

    public static void main(String[] stringArray) {
        Object object;
        System.out.println("Simple demo to extract images from a page");
        String string = test_file;
        boolean bl = false;
        int n = stringArray.length;
        if (n == 0) {
            System.out.println("Default test file used");
        } else if (n == 2) {
            string = stringArray[0];
            System.out.println("File :" + string);
            object = stringArray[1].toLowerCase();
            if (((String)object).equals("jpg") | ((String)object).equals("jpeg")) {
                format = "jpg";
            } else if (((String)object).equals("tif") | ((String)object).equals("tiff")) {
                format = "tif";
            } else if (((String)object).equals("png")) {
                format = "png";
            } else {
                bl = true;
                System.out.println("value args[1] not recognised as valid parameter.");
                System.out.println("please enter \"jpg\", \"jpeg\", \"tif\", \"tiff\" or \"png\".");
            }
        } else if (n == 1) {
            string = stringArray[0];
            System.out.println("file name=" + string);
        } else {
            bl = true;
            System.out.println("too many arguments entered");
        }
        if (bl) {
            object = "";
            for (int i = 0; i < stringArray.length; ++i) {
                object = (String)object + stringArray[i] + "\n";
            }
            System.out.println("you entered:\n" + (String)object + "as the arguments");
        }
        if (!((File)(object = new File(string))).exists()) {
            System.out.println("File " + string + " not found");
            System.exit(1);
        }
        ExtractPagesAsThumbnails extractPagesAsThumbnails = new ExtractPagesAsThumbnails(string, null);
    }

    public String getOutputDir() {
        return this.output_dir;
    }
}

