/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.utils.LogWriter;

public class CalRGBColorSpace
extends GenericColorSpace {
    private int r;
    private int g;
    private int b;
    private float lastC = -255.0f;
    private float lastI = -255.0f;
    private float lastE = -255.0f;

    public CalRGBColorSpace(String string, String string2, String string3, String string4) {
        this.setCIEValues(string, string2, null, string3, string4);
        this.value = 5;
    }

    public final BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        int n3 = n * n2;
        try {
            for (int i = 0; i < n3 * 3; i += 3) {
                float f = dataBufferByte.getElemFloat(i);
                float f2 = dataBufferByte.getElemFloat(i + 1);
                float f3 = dataBufferByte.getElemFloat(i + 2);
                this.convertToRGB(f, f2, f3);
                ((DataBuffer)dataBufferByte).setElem(i, this.r);
                ((DataBuffer)dataBufferByte).setElem(i + 1, this.g);
                ((DataBuffer)dataBufferByte).setElem(i + 2, this.b);
            }
            int[] nArray = new int[]{0, 1, 2};
            bufferedImage = new BufferedImage(n, n2, 1);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
            bufferedImage.setData(writableRaster);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
        }
        return bufferedImage;
    }

    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f};
        if (n == 3) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = Float.parseFloat(stringArray[2 - i]);
            }
        }
        this.convertToRGB(fArray[0], fArray[1], fArray[2]);
        this.currentColor = new Color(this.r, this.g, this.b);
    }

    private final void convertToRGB(float f, float f2, float f3) {
        if (this.lastC != f || this.lastI != f2 || this.lastE != f3) {
            float f4 = (float)Math.pow(f, this.G[0]);
            float f5 = (float)Math.pow(f2, this.G[1]);
            float f6 = (float)Math.pow(f3, this.G[2]);
            float[] fArray = new float[]{this.calibrateValues(this.Ma[0] * f4 + this.Ma[3] * f5 + this.Ma[6] * f6, 0), this.calibrateValues(this.Ma[1] * f4 + this.Ma[4] * f5 + this.Ma[7] * f6, 1), this.calibrateValues(this.Ma[2] * f4 + this.Ma[5] * f5 + this.Ma[8] * f6, 2)};
            if ((double)(fArray = this.cs.toRGB(fArray))[0] > 0.95 && (double)fArray[1] > 0.95 && (double)fArray[2] > 0.95) {
                for (int i = 0; i < 3; ++i) {
                    fArray[i] = 1.0f;
                }
            }
            this.r = (int)(fArray[0] * 255.0f);
            this.g = (int)(fArray[1] * 255.0f);
            this.b = (int)(fArray[2] * 255.0f);
            this.lastC = f;
            this.lastI = f2;
            this.lastE = f3;
        }
    }

    public final byte[] convertIndexToRGB(byte[] byArray) {
        return byArray;
    }
}

