/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.Cmd;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceDecoder;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.CIDFontType0;
import org.jpedal.fonts.CIDFontType2;
import org.jpedal.fonts.GlyphFactory;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.PdfGlyph;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.TrueType;
import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.Type3;
import org.jpedal.images.ImageTransformer;
import org.jpedal.images.ImageTransformerDouble;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.TextState;
import org.jpedal.renderer.DynamicVectorRenderer;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Object;

public class PdfStreamDecoder {
    private boolean useShading = false;
    private boolean pageSuccessful = true;
    private String pageErrorMessages = "";
    private StatusBar statusBar = null;
    private final float currentThreshold = 0.6f;
    private Map rawColorspaceValues = new Hashtable();
    private Map rawShadingValues = new Hashtable();
    String last = "";
    private boolean multipleTJs = false;
    private PdfObjectReader currentPdfFile;
    private boolean isClip = false;
    private int depth = 0;
    private static final float THOUSAND = 1000.0f;
    private static final String[] hex = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;"};
    private String font_as_string = "";
    private GenericColorSpace strokeColorSpace = new DeviceRGBColorSpace();
    private GenericColorSpace nonstrokeColorSpace = new DeviceRGBColorSpace();
    private boolean createScaledVersion = true;
    private int tokenNumber = 0;
    private boolean isPageContent = true;
    private boolean isStackInitialised = false;
    private Vector_Object graphicsStateStack;
    private Vector_Object strokeColorStateStack;
    private Vector_Object nonstrokeColorStateStack;
    private Vector_Object clipStack;
    private Vector_Object textStateStack;
    private PageLines pageLines = new PageLines();
    private PdfShape currentDrawShape = new PdfShape();
    private final int MAXOPS = 50;
    private int currentOp = 0;
    private int operandCount = 0;
    private String[] operand = new String[50];
    private int moveCommand = 0;
    private String currentFont = "";
    private String currentImage = "";
    private Map currentXObjectValues = new Hashtable();
    private Map currentPatternValues = new Hashtable();
    private float charSpacing = 0.0f;
    private GraphicsState currentGraphicsState;
    private TextState currentTextState = new TextState();
    private PdfFont currentFontData;
    private Map fonts = new Hashtable();
    private int textLength = 0;
    private boolean useHiResImageForDisplay = false;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private PdfPageData pageData = new PdfPageData();
    private DynamicVectorRenderer current = new DynamicVectorRenderer();
    private GlyphFactory factory = null;
    private int pageNum;
    private byte[] binaryContent = null;
    private static String fontsInFile;
    private String currentColor = "<COLOR C='1' M='1' Y='1' K='1'>";
    private int T3maxWidth;
    private boolean legacyTextMode = false;
    private boolean extractRawCMYK = false;
    private boolean renderDirectly;
    private Graphics2D g2;
    private Shape defaultClip;
    private boolean hasEmbeddedFonts = false;
    private boolean includeImagesInData = false;
    private int lastFontSize = -1;
    public boolean ignoreColors = false;
    private boolean isPrinting;

    public PdfStreamDecoder() {
    }

    public PdfStreamDecoder(boolean bl) {
    }

    public void optimiseDisplayForPrinting() {
        this.isPrinting = true;
    }

    private final BufferedImage processImageXObject(String string, Map map, boolean bl, byte[] byArray) throws PdfException, PdfFontException {
        LogWriter.writeMethod("{processImageXObject}" + map, 0);
        boolean bl2 = false;
        String string2 = "";
        string = ObjectStore.getCurrentFilename() + "-" + string;
        String string3 = this.currentPdfFile.getValue((String)map.get("Filter"));
        String string4 = (String)map.get("ColorSpace");
        if (string4 != null) {
            string4 = Strip.removeArrayDeleminators(string4);
        }
        int n = Integer.parseInt((String)map.get("Width"));
        int n2 = Integer.parseInt((String)map.get("Height"));
        int n3 = Integer.parseInt((String)map.get("BitsPerComponent"));
        String string5 = (String)map.get("Decode");
        if (string5 != null) {
            string2 = string5;
        }
        if ((string5 = (String)map.get("ImageMask")) != null) {
            bl2 = new Boolean(string5);
        }
        GenericColorSpace genericColorSpace = new GenericColorSpace();
        if (string4 != null) {
            if (string4.startsWith("/")) {
                genericColorSpace = ColorspaceDecoder.getColorSpaceInstance(string4, null, this.currentPdfFile);
            } else {
                Map map2 = this.currentPdfFile.getSubDictionary(string4);
                string4 = (String)map2.get("rawValue");
                genericColorSpace = ColorspaceDecoder.getColorSpaceInstance(string4, map2, this.currentPdfFile);
            }
        }
        if (string4 == null) {
            string4 = "/RGB (Default)";
        }
        LogWriter.writeLog("Processing XObject: " + string + " width=" + n + " Height=" + n2 + " Depth=" + n3 + " filter=" + string3 + " colorspace=" + string4);
        return this.processImage(genericColorSpace, string4, byArray, string, n, n2, n3, string3, string2, bl2, bl);
    }

    private final BufferedImage processImage(GenericColorSpace genericColorSpace, String string, byte[] byArray, String string2, int n, int n2, int n3, String string3, String string4, boolean bl, boolean bl2) throws PdfException {
        int n4;
        Object object;
        int n5;
        if (LogWriter.debug) {
            LogWriter.writeMethod("{process_image}");
        }
        BufferedImage bufferedImage = null;
        String string5 = "jpg";
        if (string3 != null && string3.indexOf("DCTDecode") != -1) {
            string4 = "";
        }
        if (string4.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "[ ]");
            int n6 = stringTokenizer.countTokens();
            n5 = 0;
            object = new float[n6];
            while (stringTokenizer.hasMoreTokens()) {
                object[n5] = Float.parseFloat(stringTokenizer.nextToken());
                ++n5;
            }
            if (n3 != 2 || object[0] != 0.0f || object[1] != 1.0f) {
                int n7 = n3 << 1;
                int n8 = n7 - 1;
                for (int i = 0; i < byArray.length; ++i) {
                    byte by = byArray[i];
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 1;
                    for (int j = 7; j > -1; --j) {
                        int n13 = by >> j & 1;
                        if ((n13 = (int)(object[n11] + (float)n13 * ((object[n12] - object[n11]) / (float)n8))) > n7) {
                            n13 = n7;
                        }
                        if (n13 < 0) {
                            n13 = 0;
                        }
                        n13 = (n13 & 1) << j;
                        n10 += n13;
                        if ((n9 += 2) == n6) {
                            n9 = 0;
                            n11 = 0;
                            n12 = 1;
                            continue;
                        }
                        n11 += 2;
                        n12 += 2;
                    }
                    byArray[i] = (byte)n10;
                }
            }
        }
        if ((n4 = genericColorSpace.getID()) == 11) {
            LogWriter.writeLog("DeviceN colorspaces are not supported");
        } else if (n4 == 9) {
            LogWriter.writeLog("Pattern colorspaces are not supported");
        } else if (bl) {
            byte[] byArray2 = new byte[4];
            n5 = ((Color)this.nonstrokeColorSpace.getColor()).getRGB();
            byArray2[0] = (byte)(n5 >> 16 & 0xFF);
            byArray2[1] = (byte)(n5 >> 8 & 0xFF);
            byArray2[2] = (byte)(n5 & 0xFF);
            object = Raster.createPackedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n3, null);
            bufferedImage = new BufferedImage(new IndexColorModel(n3, 1, byArray2, 0, false), (WritableRaster)object, false, null);
        } else if (string3 == null) {
            LogWriter.writeLog("Image " + string2 + " " + n + "W * " + n2 + "H with No Compression at BPC " + n3 + " and Colorspace=" + string);
            bufferedImage = this.makeImage(genericColorSpace, n, n2, n3, byArray);
        } else if (string3.indexOf("DCT") != -1) {
            LogWriter.writeLog("JPeg Image " + string2 + " " + n + "W * " + n2 + "H");
            try {
                bufferedImage = genericColorSpace.JPEGToRGBImage(byArray, n, n2);
            }
            catch (Exception exception) {
                this.addPageFailureMessage("Problem converting " + string2 + " to JPEG");
                exception.printStackTrace();
                bufferedImage = null;
            }
            string5 = "jpg";
        } else if (string3.indexOf("JPXDecode") != -1) {
            LogWriter.writeLog("JPeg 2000 Image " + string2 + " " + n + "W * " + n2 + "H");
            bufferedImage = genericColorSpace.JPEG2000ToRGBImage(byArray);
            string5 = "jpg";
        } else {
            LogWriter.writeLog(string2 + " " + n + "W * " + n2 + "H  with " + string3 + " BPC=" + n3 + " CS=" + string);
            bufferedImage = this.makeImage(genericColorSpace, n, n2, n3, byArray);
            if (n3 == 8 | this.nonstrokeColorSpace.getID() == 2 | this.nonstrokeColorSpace.getID() == 7) {
                string5 = "jpg";
            }
        }
        if (bufferedImage != null) {
            byArray = null;
            if (bufferedImage.getSampleModel().getNumBands() == 1) {
                string5 = "tif";
            }
        }
        return bufferedImage;
    }

    public void init(boolean bl, boolean bl2, int n, int n2, PdfPageData pdfPageData, int n3, DynamicVectorRenderer dynamicVectorRenderer, PdfObjectReader pdfObjectReader, Map map, Map map2) throws PdfFontException {
        this.currentPdfFile = pdfObjectReader;
        if (dynamicVectorRenderer != null) {
            this.current = dynamicVectorRenderer;
        }
        this.pageNum = n3;
        this.pageData = pdfPageData;
        this.isPageContent = bl;
        this.currentFontData = new PdfFont(pdfObjectReader);
        this.strokeColorSpace = new DeviceRGBColorSpace();
        this.nonstrokeColorSpace = new DeviceRGBColorSpace();
        if (map != null) {
            this.readResources(map);
        }
        if (map2 != null) {
            this.readResources(map2);
        }
    }

    private final BufferedImage makeImage(GenericColorSpace genericColorSpace, int n, int n2, int n3, byte[] byArray) {
        LogWriter.writeMethod("{makeImage}", 0);
        ColorSpace colorSpace = genericColorSpace.getColorSpace();
        int n4 = genericColorSpace.getID();
        int n5 = colorSpace.getNumComponents();
        BufferedImage bufferedImage = null;
        byte[] byArray2 = genericColorSpace.getIndexedMap();
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        if (n3 == 1) {
            WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n3, null);
            bufferedImage = new BufferedImage(n, n2, 12);
            bufferedImage.setData(writableRaster);
        } else if (byArray2 != null) {
            if (n5 == 4) {
                n5 = 3;
            }
            byArray2 = genericColorSpace.convertIndexToRGB(byArray2);
            int n6 = genericColorSpace.getIndexSize() + 1;
            if (n3 == 4 && n6 > 16) {
                n6 = 16;
            }
            if (n6 != 256) {
                WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n3, null);
                IndexColorModel indexColorModel = new IndexColorModel(n3, n6, byArray2, 0, false);
                bufferedImage = new BufferedImage(indexColorModel, writableRaster, false, null);
            } else {
                int[] nArray = new int[]{0, 1, 2};
                byte[] byArray3 = new byte[byArray.length * 3];
                for (int i = 0; i < byArray.length - 1; ++i) {
                    int n7 = (byArray[i] & 0xFF) * 3;
                    byArray3[i * 3] = byArray2[n7];
                    byArray3[i * 3 + 1] = byArray2[n7 + 1];
                    byArray3[i * 3 + 2] = byArray2[n7 + 2];
                }
                dataBufferByte = new DataBufferByte(byArray3, byArray3.length);
                bufferedImage = new BufferedImage(n, n2, 1);
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
                bufferedImage.setData(writableRaster);
            }
        } else if (n4 == 10) {
            LogWriter.writeLog("Converting Separation colorspace to sRGB ");
            bufferedImage = genericColorSpace.dataToRGB(byArray, n, n2);
        } else if (n4 == 6) {
            LogWriter.writeLog("Converting lab colorspace to sRGB ");
            bufferedImage = genericColorSpace.dataToRGB(byArray, n, n2);
        } else if (n5 == 4) {
            bufferedImage = n4 == 3 ? ColorSpaceConvertor.algorithmicConvertCMYKImageToRGB(byArray, n, n2) : ColorSpaceConvertor.convertFromICCCMYK(n, n2, byArray, colorSpace);
        } else if (n5 == 3) {
            if (n * n2 == byArray.length) {
                if (n3 == 8) {
                    bufferedImage = new BufferedImage(n, n2, 13);
                }
                WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n3, null);
                bufferedImage.setData(writableRaster);
            } else {
                int[] nArray = new int[]{0, 1, 2};
                bufferedImage = new BufferedImage(n, n2, 1);
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
                bufferedImage.setData(writableRaster);
            }
        } else if (n5 == 1 & n3 == 8) {
            bufferedImage = new BufferedImage(n, n2, 10);
            int[] nArray = new int[]{0};
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n, 1, nArray, null);
            bufferedImage.setData(writableRaster);
        } else {
            LogWriter.writeLog("Image " + colorSpace.getType() + " not currently supported with components " + n5);
        }
        if (bufferedImage.getType() == 0) {
            bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
        }
        return bufferedImage;
    }

    private final void processXObjects(Map map) {
        LogWriter.writeMethod("{processXObjects}", 0);
        String string = "";
        String string2 = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = (String)map.get(string);
            this.currentXObjectValues.put(string, string2);
        }
    }

    private final void processPatterns(Map map) {
        LogWriter.writeMethod("{processPatterns}", 0);
        String string = "";
        String string2 = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = (String)map.get(string);
            this.currentPatternValues.put(string, string2);
        }
    }

    private final void readFonts(Map map) throws PdfFontException {
        LogWriter.writeMethod("{readFonts}", 0);
        Map map2 = new HashMap();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = null;
        PdfFont pdfFont = null;
        boolean bl = true;
        fontsInFile = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            Object v = map.get(string3);
            if (v instanceof String) {
                map2 = this.currentPdfFile.readObject((String)map.get(string3), false, null);
            } else if (v instanceof Map) {
                map2 = (Map)v;
            }
            string = (String)map2.get("Type");
            string4 = null;
            if (string == null) {
                return;
            }
            if (string.equals("/Font")) {
                Object object;
                Object object2;
                string2 = (String)map2.get("Subtype");
                Map map3 = null;
                boolean bl2 = false;
                if (PdfDecoder.fontSubstitutionTable != null) {
                    object2 = new HashMap();
                    object = map2.get("FontDescriptor");
                    if (object instanceof Map) {
                        object2 = (Map)object;
                    } else if (object instanceof String) {
                        object2 = this.currentPdfFile.readObject((String)object, false, null);
                    }
                    if (object2 != null) {
                        bl2 = object2.get("FontFile") != null | object2.get("FontFile2") != null | object2.get("FontFile3") != null;
                    }
                }
                if (PdfDecoder.fontSubstitutionTable != null && !bl2) {
                    String string5;
                    String string6;
                    int n;
                    object2 = (String)map2.get("BaseFont");
                    if (object2 == null) {
                        object2 = (String)map2.get("Name");
                    }
                    if (object2 == null) {
                        object2 = string3;
                    }
                    if (((String)(object = ((String)object2).toLowerCase())).startsWith("/")) {
                        object = ((String)object).substring(1);
                    }
                    if ((n = ((String)object).indexOf("+")) == 6) {
                        object = ((String)object).substring(7);
                    }
                    if ((string6 = (String)PdfDecoder.fontSubstitutionTable.get(string5 = ((String)object).toLowerCase())) == null && (string5 = (String)PdfDecoder.fontSubstitutionAliasTable.get(string5)) != null) {
                        string6 = (String)PdfDecoder.fontSubstitutionTable.get(string5);
                    }
                    if (string6 != null) {
                        string2 = string6;
                        string4 = (String)PdfDecoder.fontSubstitutionLocation.get(string5);
                    } else if (PdfDecoder.enforceFontSubstitution) {
                        LogWriter.writeLog("baseFont=" + (String)object + " fonts added= " + PdfDecoder.fontSubstitutionTable);
                        throw new PdfFontException("No substitute Font found for " + (String)object);
                    }
                }
                try {
                    if (string2.equals("/Type1") || string2.equals("/Type1C") || string2.equals("/MMType1")) {
                        pdfFont = new Type1C(this.currentPdfFile, string4);
                    } else if (string2.equals("/TrueType")) {
                        pdfFont = new TrueType(this.currentPdfFile, string4);
                    } else if (string2.equals("/Type3")) {
                        pdfFont = new Type3(this.currentPdfFile);
                    } else if (string2.equals("/Type0")) {
                        object2 = (String)map2.get("DescendantFonts");
                        if (object2 == null) {
                            LogWriter.writeLog("[PDF] No Descender font for CID font");
                        } else {
                            if (((String)object2).startsWith("[")) {
                                object2 = Strip.removeArrayDeleminators((String)object2);
                            }
                            if ((object = (String)(map3 = this.currentPdfFile.readObject((String)object2, false, null)).get("rawValue")) != null) {
                                map3 = this.currentPdfFile.readObject(Strip.removeArrayDeleminators((String)object), false, null);
                            }
                            pdfFont = (string2 = (String)map3.get("Subtype")).equals("/CIDFontType0") ? new CIDFontType0(this.currentPdfFile) : new CIDFontType2(this.currentPdfFile);
                        }
                    } else {
                        LogWriter.writeLog("Font type " + string2 + " not supported");
                        pdfFont = new PdfFont(this.currentPdfFile);
                    }
                    if (PdfDecoder.defaultFont != null) {
                        pdfFont.setDefaultDisplayFont(PdfDecoder.defaultFont);
                    }
                    pdfFont.createFont(map2, string3, bl, map3);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("[PDF] Problem " + exception + " reading Font  type " + string2 + " in " + ObjectStore.getCurrentFilename());
                    this.addPageFailureMessage("Problem " + exception + " reading Font type " + string2 + " in " + ObjectStore.getCurrentFilename());
                }
                this.fonts.put(string3, pdfFont);
                if (pdfFont.isFontSubstituted()) {
                    fontsInFile = string3 + "  " + pdfFont.getFontName() + "  " + string2.substring(1) + "  Substituted " + "\n" + fontsInFile;
                    continue;
                }
                if (pdfFont.isFontEmbedded) {
                    this.hasEmbeddedFonts = true;
                    if (pdfFont.is1C) {
                        fontsInFile = string3 + "  " + pdfFont.getFontName() + " Type1C  Embedded\n" + fontsInFile;
                        continue;
                    }
                    fontsInFile = string3 + "  " + pdfFont.getFontName() + "  " + string2.substring(1) + "  Embedded\n" + fontsInFile;
                    continue;
                }
                fontsInFile = string3 + "  " + pdfFont.getFontName() + "  " + string2.substring(1) + "\n" + fontsInFile;
                continue;
            }
            LogWriter.writeLog("Not a font object");
        }
    }

    private final void readResources(Map map) throws PdfFontException {
        LogWriter.writeMethod("{readResources}", 0);
        Map map2 = this.currentPdfFile.getSubDictionary(map.get("ColorSpace"));
        if (map2 != null) {
            this.readColorSpaceSettings(map2);
        }
        if ((map2 = this.currentPdfFile.getSubDictionary(map.get("Font"))) != null) {
            this.readFonts(map2);
        }
        if ((map2 = this.currentPdfFile.getSubDictionary(map.get("XObject"))) != null) {
            this.processXObjects(map2);
        }
        try {
            map2 = this.currentPdfFile.getSubDictionary(map.get("Shading"));
            if (map2 != null) {
                this.readShadingSettings(map2);
            }
            if ((map2 = this.currentPdfFile.getSubDictionary(map.get("Pattern"))) != null) {
                this.processPatterns(map2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void readColorSpaceSettings(Map map) {
        LogWriter.writeMethod("{readColorSpaces}", 0);
        String string = "";
        String string2 = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = (String)map.get(string);
            if (string2.endsWith(" R")) {
                this.rawColorspaceValues.put(string, this.currentPdfFile.readObject(string2, false, null));
                continue;
            }
            this.rawColorspaceValues.put(string, string2);
        }
    }

    private final void readShadingSettings(Map map) {
        LogWriter.writeMethod("{readShadingSettings}", 0);
        String string = "";
        String string2 = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = map.get(string);
            if (string2 instanceof String && string2.toString().endsWith(" R")) {
                this.rawShadingValues.put(string, this.currentPdfFile.readObject(string2, false, null));
                continue;
            }
            this.rawShadingValues.put(string, string2);
        }
    }

    public final int decodePageContent(String string, int n, int n2) {
        LogWriter.writeMethod("{decodePageContent " + string + "}", 0);
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
        }
        this.currentGraphicsState = new GraphicsState(n, n2);
        if (this.renderDirectly) {
            this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
        } else {
            this.current.drawClip(this.currentGraphicsState);
        }
        byte[] byArray = this.readPageIntoStream(string);
        this.binaryContent = byArray;
        if (byArray.length > 0) {
            this.decodeStreamIntoObjects(byArray);
        }
        return this.T3maxWidth;
    }

    public final byte[] getStreamAsBinary() {
        return this.binaryContent;
    }

    private final void decodeStreamIntoObjects(byte[] byArray) {
        int n;
        LogWriter.writeMethod("{decodeStreamIntoObjects}", 0);
        char[] cArray = new char[]{'<', '('};
        char[] cArray2 = new char[]{'>', ')'};
        int n2 = cArray.length;
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
            this.statusBar.resetStatus("stream");
        }
        int n3 = n = byArray.length;
        int n4 = 255;
        int n5 = 0;
        int n6 = 0;
        StringBuffer stringBuffer = new StringBuffer(n4);
        char c = (char)byArray[0];
        int n7 = 120;
        int n8 = -1;
        do {
            int n9;
            int n10;
            if (!this.renderDirectly && this.statusBar != null) {
                this.statusBar.percentageDone = 100 * n5 / n;
            }
            n7 = c;
            while (!((c = (char)byArray[n5]) != '\r' & c != '\n' & c != ' ') && ++n5 != n3) {
            }
            if (n5 == n3) break;
            boolean bl = false;
            int n11 = 0;
            if (c == '<' && byArray[n5 + 1] == 60) {
                n11 = 1;
            } else if (c == '[') {
                n11 = 2;
            } else if (c >= 'a' && c <= 'z') {
                n11 = 3;
            } else if (c >= 'A' && c <= 'Z') {
                n11 = 3;
            } else if (c == '\'' | c == '\"') {
                n11 = 3;
            } else if (c == ' ') {
                n11 = 4;
            }
            if (n11 == 3) {
                int n12;
                int n13;
                n10 = n5;
                while (++n5 != byArray.length) {
                    n7 = c;
                    c = (char)byArray[n5];
                    if (!(c == '\r' | c == '\n' | c == ' ' | c == '(' | c == '/' | c == '[')) continue;
                }
                n9 = n5 - 1;
                n8 = -1;
                if (n9 - n10 < 3) {
                    n13 = 0;
                    n12 = 0;
                    for (int i = n9; i > n10 - 1; --i) {
                        n13 += byArray[i] << n12;
                        n12 += 8;
                    }
                    n8 = Cmd.getCommandID(n13);
                }
                if (n8 == -1) {
                    n13 = n9 - n10 + 1;
                    stringBuffer = new StringBuffer();
                    stringBuffer.setLength(n13);
                    for (n12 = 0; n12 < n13; ++n12) {
                        stringBuffer.setCharAt(n12, (char)byArray[n10 + n12]);
                    }
                    this.operand[this.currentOp] = stringBuffer.toString();
                    ++this.currentOp;
                    if (this.currentOp == this.MAXOPS) {
                        this.currentOp = 0;
                    }
                    ++this.operandCount;
                } else {
                    try {
                        n6 = n5 = this.processToken(n8, byArray, n6, n5);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] " + exception);
                        LogWriter.writeLog("Processing token >" + Cmd.getCommandAsString(n8) + "<>" + ObjectStore.getCurrentFilename());
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.addPageFailureMessage("Memory error decoding token stream");
                        LogWriter.writeLog("[MEMORY] Memory error - trying to recover");
                        System.gc();
                    }
                    this.currentOp = 0;
                    this.operandCount = 0;
                }
            } else if (n11 != 4) {
                stringBuffer = new StringBuffer(n4);
                if (n11 == 1 | n11 == 2) {
                    n10 = 0;
                    bl = true;
                    stringBuffer.append(c);
                    do {
                        n7 = n7 == 92 && c == '\\' ? 120 : (int)c;
                        if (++n5 == byArray.length) break;
                        c = (char)byArray[n5];
                        if (c == '\r' | c == '\n') {
                            c = ' ';
                        }
                        if (c != ' ' | n7 != 32) {
                            stringBuffer.append(c);
                        }
                        n9 = 0;
                        if (c == '>' && n7 == 62 && n11 == 1) {
                            n9 = 1;
                        }
                        if (n11 != 2) continue;
                        if (c == '(' && n7 != 92) {
                            n10 = 1;
                        } else if (c == ')' && n7 != 92) {
                            n10 = 0;
                        }
                        if (n10 != 0 || c != ']' || n7 == 92) continue;
                        n9 = 1;
                    } while (n9 == 0);
                }
                if (!bl) {
                    for (n10 = 0; n10 < n2; ++n10) {
                        if (c != cArray[n10]) continue;
                        bl = true;
                        stringBuffer.append(c);
                        do {
                            n7 = n7 == 92 && c == '\\' ? 120 : (int)c;
                            if (++n5 == byArray.length) break;
                            c = (char)byArray[n5];
                            if (c == '\r' | c == '\n') {
                                c = ' ';
                            }
                            if (!(c != ' ' | n7 != 32)) continue;
                            stringBuffer.append(c);
                        } while (c != cArray2[n10] || n7 == 92);
                        n10 = n2;
                    }
                }
                if (!bl) {
                    stringBuffer.append(c);
                    while (++n5 != byArray.length) {
                        n7 = c;
                        c = (char)byArray[n5];
                        if (c == '\r' | c == '\n' | c == ' ' | c == '(' | c == '/' | c == '[') break;
                        stringBuffer.append(c);
                    }
                }
                this.operand[this.currentOp] = stringBuffer.toString();
                ++this.currentOp;
                if (this.currentOp == this.MAXOPS) {
                    this.currentOp = 0;
                }
                ++this.operandCount;
            }
            if (n5 >= n3 || !(byArray[n5] != 47 & byArray[n5] != 40 & byArray[n5] != 91)) continue;
            ++n5;
        } while (n3 > n5);
    }

    private final void d1() {
        this.ignoreColors = true;
        float f = Float.parseFloat(this.operand[0]);
        float f2 = Float.parseFloat(this.operand[1]);
        float f3 = Float.parseFloat(this.operand[2]);
        float f4 = Float.parseFloat(this.operand[3]);
        float f5 = Float.parseFloat(this.operand[4]);
        float f6 = Float.parseFloat(this.operand[5]);
        this.T3maxWidth = (int)f6;
        this.T3maxWidth = f6 == 0.0f ? (int)(f4 - f2) : (int)f6;
    }

    private final void d0() {
        this.ignoreColors = false;
        this.T3maxWidth = (int)Float.parseFloat(this.operand[0]);
    }

    private final void TD(boolean bl) {
        float f = Float.parseFloat(this.operand[1]);
        float f2 = Float.parseFloat(this.operand[0]);
        this.relativeMove(f, f2);
        if (!bl) {
            float f3 = -f2;
            this.currentTextState.setLeading(f3);
        }
        this.multipleTJs = false;
    }

    private final byte[] readPageIntoStream(String string) {
        Object object;
        LogWriter.writeMethod("{readPageIntoStream}", 0);
        byte[] byArray = new byte[]{};
        byte[] byArray2 = null;
        this.currentTextState = new TextState();
        if (!string.startsWith("[")) {
            object = this.currentPdfFile.readObject(string, false, null);
            byArray2 = this.currentPdfFile.readStream((Map)object, string);
            if (byArray2 == null) {
                string = (String)object.get("rawValue");
            } else {
                byArray = byArray2;
            }
        }
        if (string != null && byArray2 == null) {
            String string2;
            string = Strip.removeArrayDeleminators(string).trim();
            object = new StringTokenizer(string, "R");
            while (((StringTokenizer)object).hasMoreTokens() && (string2 = ((StringTokenizer)object).nextToken().trim()).length() != 0) {
                byArray2 = this.currentPdfFile.readStream(string2 + " R");
                if (byArray2 == null) continue;
                int n = byArray.length + 1;
                int n2 = byArray2.length;
                if (n2 <= 0) continue;
                while (byArray2[n2 - 1] == 0) {
                    --n2;
                }
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray, 0, byArray3, 0, n - 1);
                byArray3[n - 1] = 32;
                byArray = new byte[n + n2];
                System.arraycopy(byArray3, 0, byArray, 0, n);
                System.arraycopy(byArray2, 0, byArray, n, n2);
            }
        }
        return byArray;
    }

    private final void BT() {
        this.currentTextState.resetTm();
        this.currentTextState.setTMAtLineStart();
        this.currentFont = this.currentTextState.getFontName();
        this.currentTextState.setCurrentFontSize(0);
        this.lastFontSize = -1;
        if (this.renderDirectly) {
            this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
        } else {
            this.current.drawClip(this.currentGraphicsState);
        }
    }

    private final void restoreGraphicsState() {
        if (!this.isStackInitialised) {
            LogWriter.writeLog("No GraphicsState saved to retrieve");
        } else {
            this.currentGraphicsState = (GraphicsState)this.graphicsStateStack.pull();
            this.currentTextState = (TextState)this.textStateStack.pull();
            this.strokeColorSpace = (GenericColorSpace)this.strokeColorStateStack.pull();
            this.nonstrokeColorSpace = (GenericColorSpace)this.nonstrokeColorStateStack.pull();
            Object object = this.clipStack.pull();
            if (object == null) {
                this.currentGraphicsState.setClippingShape(null);
            } else {
                this.currentGraphicsState.setClippingShape((Area)object);
            }
            --this.depth;
            if (this.renderDirectly) {
                this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
            } else {
                this.current.drawClip(this.currentGraphicsState);
            }
        }
    }

    private final void L() {
        this.currentDrawShape.lineTo(Float.parseFloat(this.operand[1]), Float.parseFloat(this.operand[0]));
    }

    private final void F(boolean bl) {
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        this.currentDrawShape.closeShape();
        Shape shape = this.currentDrawShape.generateShapeFromPath(this.currentGraphicsState.CTM, this.isClip, this.pageLines, true);
        this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
        this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
        this.currentGraphicsState.setFillType(2);
        if (this.renderDirectly) {
            this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), shape, this.g2);
        } else {
            this.current.drawShape(shape, this.currentGraphicsState);
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void TC() {
        this.currentTextState.setCharacterSpacing(Float.parseFloat(this.operand[0]));
    }

    private final void CM() {
        float[][] fArray = new float[3][3];
        fArray[0][0] = Float.parseFloat(this.operand[5]);
        fArray[0][1] = Float.parseFloat(this.operand[4]);
        fArray[0][2] = 0.0f;
        fArray[1][0] = Float.parseFloat(this.operand[3]);
        fArray[1][1] = Float.parseFloat(this.operand[2]);
        fArray[1][2] = 0.0f;
        fArray[2][0] = Float.parseFloat(this.operand[1]);
        fArray[2][1] = Float.parseFloat(this.operand[0]);
        fArray[2][2] = 1.0f;
        this.currentGraphicsState.CTM = Matrix.multiply(fArray, this.currentGraphicsState.CTM);
        this.multipleTJs = false;
    }

    private final void relativeMove(float f, float f2) {
        float[][] fArray = new float[3][3];
        this.currentTextState.Tm = this.currentTextState.getTMAtLineStart();
        fArray[0][0] = 1.0f;
        fArray[0][1] = 0.0f;
        fArray[0][2] = 0.0f;
        fArray[1][0] = 0.0f;
        fArray[1][1] = 1.0f;
        fArray[1][2] = 0.0f;
        fArray[2][0] = f;
        fArray[2][1] = f2;
        fArray[2][2] = 1.0f;
        this.currentTextState.Tm = Matrix.multiply(fArray, this.currentTextState.Tm);
        this.currentTextState.setTMAtLineStart();
        this.moveCommand = 2;
    }

    private final void S(boolean bl) {
        Shape shape;
        boolean bl2 = true;
        if (bl) {
            this.currentDrawShape.closeShape();
        }
        if ((shape = this.currentDrawShape.generateShapeFromPath(this.currentGraphicsState.CTM, this.isClip, this.pageLines, false)) != null) {
            this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
            this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            this.currentGraphicsState.setFillType(1);
            if (this.renderDirectly) {
                this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), shape, this.g2);
            } else {
                this.current.drawShape(shape, this.currentGraphicsState);
            }
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void I() {
    }

    private final void C() {
        float f = Float.parseFloat(this.operand[1]);
        float f2 = Float.parseFloat(this.operand[0]);
        float f3 = Float.parseFloat(this.operand[3]);
        float f4 = Float.parseFloat(this.operand[2]);
        float f5 = Float.parseFloat(this.operand[5]);
        float f6 = Float.parseFloat(this.operand[4]);
        this.currentDrawShape.addBezierCurveC(f5, f6, f3, f4, f, f2);
    }

    private final void D() {
        String string = "";
        int n = this.operandCount;
        if (n == 1) {
            string = this.operand[0];
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n - 1; i > -1; --i) {
                stringBuffer.append(this.operand[i]);
                stringBuffer.append(" ");
            }
            string = stringBuffer.toString();
        }
        if (string.equals("[ ] 0 ") | string.equals("[]0") | string.equals("[] 0 ")) {
            this.currentGraphicsState.setDashPhase(0);
            this.currentGraphicsState.setDashArray(new float[0]);
        } else {
            int n2 = string.indexOf("]");
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1, string.length()).trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "[ ]");
            int n3 = stringTokenizer.countTokens();
            float[] fArray = new float[n3];
            for (int i = 0; i < n3; ++i) {
                fArray[i] = Float.parseFloat(stringTokenizer.nextToken());
            }
            this.currentGraphicsState.setDashArray(fArray);
            this.currentGraphicsState.setDashPhase((int)Float.parseFloat(string3));
        }
    }

    private final void SCN(boolean bl) {
        if (bl) {
            this.nonstrokeColorSpace.setColor(this.operand, this.operandCount);
        } else {
            this.strokeColorSpace.setColor(this.operand, this.operandCount);
        }
    }

    private final void B(boolean bl, boolean bl2) {
        Shape shape;
        boolean bl3 = true;
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        if (bl2) {
            this.currentDrawShape.closeShape();
            bl3 = false;
        }
        if ((shape = this.currentDrawShape.generateShapeFromPath(this.currentGraphicsState.CTM, this.isClip, this.pageLines, false)) != null) {
            this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
            this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            this.currentGraphicsState.setFillType(3);
            if (this.renderDirectly) {
                this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), shape, this.g2);
            } else {
                this.current.drawShape(shape, this.currentGraphicsState);
            }
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void mm() {
        int n = (int)Float.parseFloat(this.operand[0]);
        this.currentGraphicsState.setMitreLimit(n);
    }

    private final void M() {
        float f = Float.parseFloat(this.operand[1]);
        float f2 = Float.parseFloat(this.operand[0]);
        this.currentDrawShape.moveTo(f, f2);
    }

    private final void J(boolean bl) {
        int n = Integer.parseInt(this.operand[0]);
        int n2 = 0;
        if (!bl) {
            if (n == 0) {
                n2 = 0;
            }
            if (n == 1) {
                n2 = 1;
            }
            if (n == 2) {
                n2 = 2;
            }
            this.currentGraphicsState.setJoinStyle(n2);
        } else {
            if (n == 0) {
                n2 = 0;
            }
            if (n == 1) {
                n2 = 1;
            }
            if (n == 2) {
                n2 = 2;
            }
            this.currentGraphicsState.setCapStyle(n2);
        }
    }

    private final void RG(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !bl;
        if (bl2) {
            if (this.strokeColorSpace.getID() != 2) {
                this.strokeColorSpace = new DeviceRGBColorSpace();
            }
            this.strokeColorSpace.setColor(this.operand, this.operandCount);
        } else {
            if (this.nonstrokeColorSpace.getID() != 2) {
                this.nonstrokeColorSpace = new DeviceRGBColorSpace();
            }
            this.nonstrokeColorSpace.setColor(this.operand, this.operandCount);
        }
    }

    private final void Y() {
        float f = Float.parseFloat(this.operand[1]);
        float f2 = Float.parseFloat(this.operand[0]);
        float f3 = Float.parseFloat(this.operand[3]);
        float f4 = Float.parseFloat(this.operand[2]);
        this.currentDrawShape.addBezierCurveY(f3, f4, f, f2);
    }

    private final void TZ() {
        this.currentTextState.setHorizontalScaling(Float.parseFloat(this.operand[0]) / 100.0f);
    }

    private final void RE() {
        float f = Float.parseFloat(this.operand[3]);
        float f2 = Float.parseFloat(this.operand[2]);
        float f3 = Float.parseFloat(this.operand[1]);
        float f4 = Float.parseFloat(this.operand[0]);
        this.currentDrawShape.appendRectangle(f, f2, f3, f4);
    }

    private final void ET() {
    }

    private final void pushGraphicsState() {
        if (!this.isStackInitialised) {
            this.isStackInitialised = true;
            this.graphicsStateStack = new Vector_Object(10);
            this.textStateStack = new Vector_Object(10);
            this.strokeColorStateStack = new Vector_Object(20);
            this.nonstrokeColorStateStack = new Vector_Object(20);
            this.clipStack = new Vector_Object(20);
        }
        this.graphicsStateStack.push(this.currentGraphicsState.clone());
        Area area = this.currentGraphicsState.getClippingShape();
        if (area == null) {
            this.clipStack.push(null);
        } else {
            this.clipStack.push(area.clone());
        }
        this.textStateStack.push(this.currentTextState.clone());
        this.nonstrokeColorStateStack.push(this.nonstrokeColorSpace.clone());
        this.strokeColorStateStack.push(this.strokeColorSpace.clone());
        ++this.depth;
    }

    private final void EMC() {
    }

    private final void TJ(byte[] byArray, int n, int n2) {
        this.processTextArray(byArray, n, n2);
        this.moveCommand = -1;
    }

    private final void G(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !bl;
        if (bl2) {
            if (this.strokeColorSpace.getID() != 1) {
                this.strokeColorSpace = new DeviceGrayColorSpace();
            }
            this.strokeColorSpace.setColor(this.operand, this.operandCount);
        } else {
            if (this.nonstrokeColorSpace.getID() != 1) {
                this.nonstrokeColorSpace = new DeviceGrayColorSpace();
            }
            this.nonstrokeColorSpace.setColor(this.operand, this.operandCount);
        }
    }

    private final void TL() {
        this.currentTextState.setLeading(Float.parseFloat(this.operand[0]));
    }

    private final void BMC() {
    }

    private final void TM() {
        this.currentTextState.Tm[0][0] = Float.parseFloat(this.operand[5]);
        this.currentTextState.Tm[0][1] = Float.parseFloat(this.operand[4]);
        this.currentTextState.Tm[0][2] = 0.0f;
        this.currentTextState.Tm[1][0] = Float.parseFloat(this.operand[3]);
        this.currentTextState.Tm[1][1] = Float.parseFloat(this.operand[2]);
        this.currentTextState.Tm[1][2] = 0.0f;
        this.currentTextState.Tm[2][0] = Float.parseFloat(this.operand[1]);
        this.currentTextState.Tm[2][1] = Float.parseFloat(this.operand[0]);
        this.currentTextState.Tm[2][2] = 1.0f;
        this.currentTextState.setTMAtLineStart();
        this.multipleTJs = false;
        this.moveCommand = 1;
    }

    private final void H() {
        this.currentDrawShape.closeShape();
    }

    private final void TR() {
        int n = Integer.parseInt(this.operand[0]);
        if (n == 0) {
            n = 2;
        } else if (n == 1) {
            n = 1;
        } else if (n == 2) {
            n = 3;
        }
        this.currentGraphicsState.setTextRenderType(n);
    }

    private final void Q(boolean bl) {
        if (bl) {
            this.pushGraphicsState();
        } else {
            this.restoreGraphicsState();
            String string = this.currentTextState.getFontID();
            Object v = this.fonts.get(string);
            if (v != null) {
                this.currentFontData = (PdfFont)v;
            }
        }
    }

    private final int ID(byte[] byArray, int n) throws Exception {
        Object object;
        Cloneable cloneable;
        Object object2;
        Object object3;
        int n2;
        boolean bl = true;
        String string = null;
        String string2 = "";
        String string3 = null;
        boolean bl2 = false;
        String string4 = "";
        String string5 = "/DeviceRGB";
        int n3 = n + 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n3;
        int n8 = byArray.length;
        while (!(n8 - n7 > 3 && byArray[n7] == 10 | byArray[n7] == 13 && byArray[n7 + 1] == 69 && byArray[n7 + 2] == 73 && byArray[n7 + 3] == 32 | byArray[n7 + 3] == 10 | byArray[n7 + 3] == 13 || ++n7 == n8)) {
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.operandCount > 0) {
            String[] stringArray = new String[50];
            int n9 = 0;
            for (n2 = this.currentOp - 1; n2 > -1; --n2) {
                stringArray[n9] = this.operand[n2];
                if (n9 == this.operandCount) {
                    n2 = -1;
                }
                ++n9;
            }
            if (n9 == this.operandCount) {
                --this.currentOp;
                for (n2 = this.MAXOPS - 1; n2 > this.currentOp; --n2) {
                    stringArray[n9] = this.operand[n2];
                    if (n9 == this.operandCount) {
                        n2 = this.currentOp;
                    }
                    ++n9;
                }
                ++this.currentOp;
            }
            this.operand = stringArray;
        }
        int n10 = this.operandCount;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n10; ++n2) {
            int n11 = this.operand[n2].indexOf("<<");
            if (n11 > 0) {
                stringBuffer.append(this.operand[n2].substring(0, n11));
                stringBuffer.append(' ');
                stringBuffer.append(this.operand[n2].substring(n11));
            } else {
                n11 = this.operand[n2].indexOf(">>");
                if (n11 != -1 && this.operand[n2].indexOf(" >>") == -1) {
                    stringBuffer.append(this.operand[n2].substring(0, n11));
                    stringBuffer.append(' ');
                    stringBuffer.append(this.operand[n2].substring(n11));
                } else {
                    stringBuffer.append(this.operand[n2]);
                }
            }
            stringBuffer.append(' ');
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString().trim(), "[]/ ", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            if (string6.equals("/")) {
                arrayList.add(string6 + stringTokenizer.nextToken());
                continue;
            }
            if (string6.equals("[")) {
                while (string6.indexOf("]") == -1) {
                    object3 = stringTokenizer.nextToken();
                    if (((String)object3).equals("/")) {
                        string6 = string6 + " " + (String)object3;
                        continue;
                    }
                    string6 = string6 + (String)object3;
                }
                arrayList.add(string6);
                continue;
            }
            if (string6.equals(" ")) continue;
            arrayList.add(string6);
        }
        ArrayList<String> arrayList2 = arrayList;
        object3 = new Hashtable();
        n10 = arrayList2.size();
        for (int i = 0; i < n10; ++i) {
            string2 = (String)arrayList2.get(i);
            if (string2.equals("/W")) {
                n4 = Integer.parseInt((String)arrayList2.get(++i));
                continue;
            }
            if (string2.equals("/IM")) {
                if (((String)arrayList2.get(++i)).indexOf("true") == -1) continue;
                bl2 = true;
                continue;
            }
            if (string2.equals("/D")) {
                string4 = (String)arrayList2.get(++i);
                continue;
            }
            if (string2.equals("/H")) {
                n5 = Integer.parseInt((String)arrayList2.get(++i));
                continue;
            }
            if (string2.equals("/BPC")) {
                n6 = Integer.parseInt((String)arrayList2.get(++i));
                continue;
            }
            if (string2.equals("/CS")) {
                if (!(string5 = (String)arrayList2.get(++i)).startsWith("[")) continue;
                while (!string5.endsWith("]")) {
                    string5 = string5 + arrayList2.get(i);
                    ++i;
                }
                string5 = Strip.removeArrayDeleminators(string5);
                continue;
            }
            if (string2.equals("/F")) {
                string = "";
                if ((string = (String)arrayList2.get(++i)).indexOf("[") == -1) continue;
                while (string.indexOf("]") == -1) {
                    object2 = (String)arrayList2.get(++i);
                    string = string + " " + (String)object2;
                }
                string = Strip.removeArrayDeleminators(string);
                continue;
            }
            if (!string2.equals("/DP")) continue;
            object2 = (String)arrayList2.get(++i);
            cloneable = new Hashtable();
            if (((String)object2).startsWith("[")) {
                while (((String)object2).indexOf("]") == -1) {
                    object2 = (String)object2 + " " + arrayList2.get(++i);
                }
                object3.put("DecodeParms", object2);
            }
            if (!((String)object2).startsWith("<<")) continue;
            ++i;
            while (!((String)(object = (String)arrayList2.get(i))).equals(">>")) {
                if (((String)object).startsWith("/")) {
                    cloneable.put(((String)object).substring(1), arrayList2.get(i + 1));
                    ++i;
                }
                ++i;
            }
            object3.put("DecodeParms", cloneable);
        }
        string3 = string;
        String string7 = ObjectStore.getCurrentFilename() + "-IN-" + this.tokenNumber;
        object2 = new byte[n7 - n3];
        System.arraycopy(byArray, n3, object2, 0, n7 - n3);
        if (string3 != null && !string3.startsWith("/JPXDecode") && !string3.startsWith("/DCT")) {
            object2 = this.currentPdfFile.decodeFilters((byte[])object2, string3, (Map)object3, n4, n5);
        }
        cloneable = new GenericColorSpace();
        if (string5 != null) {
            Object v;
            object = null;
            if (string5.startsWith("/")) {
                object = string5.substring(1);
            }
            cloneable = (v = this.rawColorspaceValues.get(object)) == null ? ColorspaceDecoder.getColorSpaceInstance(string5, null, this.currentPdfFile) : (v instanceof String ? ColorspaceDecoder.getColorSpaceInstance((String)v, null, this.currentPdfFile) : ColorspaceDecoder.getColorSpaceInstance(null, (Hashtable)v, this.currentPdfFile));
        }
        object = this.processImage((GenericColorSpace)cloneable, string5, (byte[])object2, string7, n4, n5, n6, string3, string4, bl2, bl);
        this.currentImage = string7;
        if (object != null) {
            if (this.renderDirectly | this.useHiResImageForDisplay) {
                if (this.useHiResImageForDisplay) {
                    this.generateClippedHires((BufferedImage)object);
                }
                if (this.isPrinting) {
                    object = ColorSpaceConvertor.convertToARGB((BufferedImage)object);
                }
                this.currentGraphicsState.x = this.currentGraphicsState.CTM[2][0];
                this.currentGraphicsState.y = this.currentGraphicsState.CTM[2][1];
                if (this.renderDirectly) {
                    this.current.renderImage(null, (BufferedImage)object, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y);
                } else {
                    this.current.drawImage((BufferedImage)object, this.currentGraphicsState);
                }
            } else {
                this.generateTransformedImageSingle((BufferedImage)object);
            }
        }
        n = n7 + 3;
        return n;
    }

    private final void TS() {
        this.currentTextState.setTextRise(Float.parseFloat(this.operand[0]));
    }

    private final void double_quote(byte[] byArray, int n, int n2) {
        int n3 = 1;
        this.currentTextState.setCharacterSpacing(Float.parseFloat(this.operand[n3]));
        this.currentTextState.setWordSpacing(Float.parseFloat(this.operand[1 + n3]));
        this.TSTAR();
        this.TJ(byArray, n, n2);
    }

    private final void TSTAR() {
        this.relativeMove(0.0f, -this.currentTextState.getLeading());
        this.moveCommand = 0;
        this.multipleTJs = false;
    }

    private final void K(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !bl;
        if (this.operandCount > 3) {
            if (bl2) {
                if (this.strokeColorSpace.getID() != 3) {
                    this.strokeColorSpace = new DeviceCMYKColorSpace();
                }
                this.strokeColorSpace.setColor(this.operand, this.operandCount);
            } else {
                if (this.nonstrokeColorSpace.getID() != 3) {
                    this.nonstrokeColorSpace = new DeviceCMYKColorSpace();
                }
                this.nonstrokeColorSpace.setColor(this.operand, this.operandCount);
            }
        }
    }

    private final void W(boolean bl) {
        if (bl) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        this.isClip = true;
    }

    private final void width() {
        float f = Float.parseFloat(this.operand[0]);
        this.currentGraphicsState.setLineWidth(f);
    }

    private final void one_quote(byte[] byArray, int n, int n2) {
        this.TSTAR();
        this.TJ(byArray, n, n2);
    }

    private final void GS() {
    }

    private final void N() {
        if (this.isClip) {
            this.currentDrawShape.closeShape();
            this.currentGraphicsState.updateClip(new Area(this.currentDrawShape.generateShapeFromPath(this.currentGraphicsState.CTM, false, null, false)));
            this.currentGraphicsState.checkWholePageClip(this.pageData.getMediaBoxHeight(this.pageNum) + this.pageData.getMediaBoxY(this.pageNum));
            this.isClip = false;
            if (this.renderDirectly) {
                this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
            } else {
                this.current.drawClip(this.currentGraphicsState);
            }
        }
        this.currentDrawShape.resetPath();
    }

    private final void sh() {
        if (this.useShading) {
            String string = this.operand[0].substring(1);
            System.out.println("sh=" + this.operand[0]);
            Object object = this.rawShadingValues.get(string);
            if (object == null) {
                object = string;
            }
            System.out.println(object + " " + this.rawShadingValues);
            this.currentDrawShape.closeShape();
            Shape shape = this.currentDrawShape.generateShapeFromPath(this.currentGraphicsState.CTM, this.isClip, this.pageLines, true);
            System.out.println(shape.getBounds());
            this.currentGraphicsState.setFillType(2);
            if (this.renderDirectly) {
                this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), shape, this.g2);
            } else {
                this.current.drawShape(shape, this.currentGraphicsState);
            }
            this.isClip = false;
            this.currentDrawShape.resetPath();
        }
    }

    private final void TW() {
        this.currentTextState.setWordSpacing(Float.parseFloat(this.operand[0]));
    }

    private final void CS(boolean bl) {
        Object object;
        String string = this.operand[0];
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((object = this.rawColorspaceValues.get(string)) == null) {
            object = string;
        }
        boolean bl2 = !bl;
        GenericColorSpace genericColorSpace = object instanceof String ? ColorspaceDecoder.getColorSpaceInstance((String)object, null, this.currentPdfFile) : ColorspaceDecoder.getColorSpaceInstance(null, (Hashtable)object, this.currentPdfFile);
        if (genericColorSpace.getID() == 9) {
            genericColorSpace.setPattern(this.currentPatternValues);
        }
        if (bl2) {
            this.strokeColorSpace = genericColorSpace;
        } else {
            this.nonstrokeColorSpace = genericColorSpace;
        }
    }

    private final void V() {
        float f = Float.parseFloat(this.operand[1]);
        float f2 = Float.parseFloat(this.operand[0]);
        float f3 = Float.parseFloat(this.operand[3]);
        float f4 = Float.parseFloat(this.operand[2]);
        this.currentDrawShape.addBezierCurveV(f3, f4, f, f2);
    }

    private final void TF() {
        float f = Float.parseFloat(this.operand[0]);
        String string = this.operand[1].substring(1);
        this.currentTextState.setFontTfs(f);
        Object v = this.fonts.get(string);
        if (v != null) {
            this.currentFontData = (PdfFont)v;
        }
        this.currentFont = this.currentFontData.getFontName();
        this.currentTextState.setFont(this.currentFont, string);
        this.font_as_string = Fonts.createFontToken(this.currentFont, this.currentTextState.getCurrentFontSize());
    }

    private final int processToken(int n, byte[] byArray, int n2, int n3) throws PdfFontException, Exception {
        if (this.operandCount > 0) {
            int n4;
            String[] stringArray = new String[50];
            int n5 = 0;
            for (n4 = this.currentOp - 1; n4 > -1; --n4) {
                stringArray[n5] = this.operand[n4];
                if (n5 == this.operandCount) {
                    n4 = -1;
                }
                ++n5;
            }
            if (n5 == this.operandCount) {
                --this.currentOp;
                for (n4 = this.MAXOPS - 1; n4 > this.currentOp; --n4) {
                    stringArray[n5] = this.operand[n4];
                    if (n5 == this.operandCount) {
                        n4 = this.currentOp;
                    }
                    ++n5;
                }
                ++this.currentOp;
            }
            this.operand = stringArray;
        }
        boolean bl = true;
        bl = false;
        switch (n) {
            case 21603: {
                this.TC();
                break;
            }
            case 21623: {
                this.TW();
                break;
            }
            case 21626: {
                this.TZ();
                break;
            }
            case 21580: {
                this.TL();
                break;
            }
            case 21606: {
                this.TF();
                break;
            }
            case 21618: {
                this.TR();
                break;
            }
            case 21619: {
                this.TS();
                break;
            }
            case 21572: {
                this.TD(false);
                break;
            }
            case 21604: {
                this.TD(true);
                break;
            }
            case 21613: {
                this.TM();
                break;
            }
            case 21546: {
                this.TSTAR();
                break;
            }
            case 21610: {
                this.TJ(byArray, n2, n3);
                break;
            }
            case 21578: {
                this.TJ(byArray, n2, n3);
                break;
            }
            case 39: {
                this.one_quote(byArray, n2, n3);
                break;
            }
            case 34: {
                this.double_quote(byArray, n2, n3);
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            switch (n) {
                case 18756: {
                    n3 = this.ID(byArray, n3);
                    break;
                }
                case 66: {
                    this.B(false, false);
                    break;
                }
                case 98: {
                    this.B(false, true);
                    break;
                }
                case 25130: {
                    this.B(true, true);
                    break;
                }
                case 16938: {
                    this.B(true, false);
                    break;
                }
                case 99: {
                    this.C();
                    break;
                }
                case 100: {
                    this.D();
                    break;
                }
                case 70: {
                    this.F(false);
                    break;
                }
                case 102: {
                    this.F(false);
                    break;
                }
                case 17962: {
                    this.F(true);
                    break;
                }
                case 26154: {
                    this.F(true);
                    break;
                }
                case 104: {
                    this.H();
                    break;
                }
                case 108: {
                    this.L();
                    break;
                }
                case 109: {
                    this.M();
                    break;
                }
                case 110: {
                    this.N();
                    break;
                }
                case 83: {
                    this.S(false);
                    break;
                }
                case 115: {
                    this.S(true);
                    break;
                }
                case 118: {
                    this.V();
                    break;
                }
                case 22314: {
                    this.W(true);
                    break;
                }
                case 87: {
                    this.W(false);
                    break;
                }
                case 121: {
                    this.Y();
                    break;
                }
                case 29285: {
                    this.RE();
                    break;
                }
                case 103: {
                    this.G(true);
                    break;
                }
                case 71: {
                    this.G(false);
                    break;
                }
                case 107: {
                    this.K(true);
                    break;
                }
                case 75: {
                    this.K(false);
                    break;
                }
                case 25453: {
                    this.CM();
                    break;
                }
                case 26483: {
                    this.GS();
                    break;
                }
                case 105: {
                    this.I();
                    break;
                }
                case 74: {
                    this.J(false);
                    break;
                }
                case 106: {
                    this.J(true);
                    break;
                }
                case 113: {
                    this.Q(true);
                    break;
                }
                case 81: {
                    this.Q(false);
                    break;
                }
                case 4345155: {
                    this.BMC();
                    break;
                }
                case 25648: {
                    this.d0();
                    break;
                }
                case 25649: {
                    this.d1();
                    break;
                }
                case 4541763: {
                    this.EMC();
                    break;
                }
                case 29287: {
                    this.RG(true);
                    break;
                }
                case 21063: {
                    this.RG(false);
                    break;
                }
                case 5456718: {
                    this.SCN(false);
                    break;
                }
                case 7562094: {
                    this.SCN(true);
                    break;
                }
                case 21315: {
                    this.SCN(false);
                    break;
                }
                case 29539: {
                    this.SCN(true);
                    break;
                }
                case 25459: {
                    this.CS(true);
                    break;
                }
                case 17235: {
                    this.CS(false);
                    break;
                }
                case 16980: {
                    this.BT();
                    break;
                }
                case 17748: {
                    this.ET();
                    break;
                }
                case 17519: {
                    this.DO();
                    break;
                }
                case 77: {
                    this.mm();
                    break;
                }
                case 119: {
                    this.width();
                    break;
                }
                case 29544: {
                    this.sh();
                }
            }
        }
        this.currentOp = 0;
        this.operandCount = 0;
        ++this.tokenNumber;
        return n3;
    }

    private final void DO() throws PdfFontException, PdfException {
        Map map = new Hashtable();
        String string = this.operand[0];
        string = string.substring(1);
        this.currentImage = ObjectStore.getCurrentFilename() + "-" + string;
        String string2 = (String)this.currentXObjectValues.get(string);
        map = string2 == null ? null : this.currentPdfFile.readObject(string2, false, null);
        try {
            if (map != null) {
                String string3 = (String)map.get("Subtype");
                if (string3.equals("/Form")) {
                    if (!this.renderDirectly && this.statusBar != null) {
                        this.statusBar.inSubroutine(true);
                    }
                    byte[] byArray = this.currentPdfFile.readStream(map, string2);
                    this.currentOp = 0;
                    this.operandCount = 0;
                    if (byArray != null) {
                        this.processXForm(map, byArray);
                    }
                    if (!this.renderDirectly && this.statusBar != null) {
                        this.statusBar.inSubroutine(false);
                    }
                } else if (string3.equals("/Image")) {
                    BufferedImage bufferedImage;
                    byte[] byArray = this.currentPdfFile.readStream(map, string2);
                    if (byArray != null && (bufferedImage = this.processImageXObject(string, map, true, byArray)) != null) {
                        if (this.renderDirectly | this.useHiResImageForDisplay) {
                            if (this.useHiResImageForDisplay && !this.isPrinting) {
                                bufferedImage = this.generateClippedHires(bufferedImage);
                            }
                            if (this.isPrinting) {
                                bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
                            }
                            this.currentGraphicsState.x = this.currentGraphicsState.CTM[2][0];
                            this.currentGraphicsState.y = this.currentGraphicsState.CTM[2][1];
                            if (this.renderDirectly) {
                                this.current.renderImage(null, bufferedImage, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y);
                            } else {
                                this.current.drawImage(bufferedImage, this.currentGraphicsState);
                            }
                        } else {
                            this.generateTransformedImageSingle(bufferedImage);
                        }
                    }
                } else {
                    LogWriter.writeLog("[PDF] " + string3 + " not supported");
                }
            }
        }
        catch (Error error) {
            this.addPageFailureMessage("Error with image " + map);
        }
    }

    private void processXForm(Map map, byte[] byArray) throws PdfFontException {
        String string = (String)map.get("Matrix");
        if (string != null && string.indexOf("1 0 0 1 0 0") == -1 && string.indexOf("1.0 0.0 0.0 1.0 0.0 0.0") == -1) {
            LogWriter.writeLog("Only 1-1 form mappings currently supported. Value=" + string);
        } else {
            GenericColorSpace genericColorSpace = (GenericColorSpace)this.strokeColorSpace.clone();
            GenericColorSpace genericColorSpace2 = (GenericColorSpace)this.nonstrokeColorSpace.clone();
            Map map2 = this.currentPdfFile.getSubDictionary(map.get("Resources"));
            if (map2 != null) {
                this.readResources(map2);
            }
            this.decodeStreamIntoObjects(byArray);
            this.strokeColorSpace = genericColorSpace;
            this.nonstrokeColorSpace = genericColorSpace2;
        }
    }

    private final void generateTransformedImageSingle(BufferedImage bufferedImage) {
        LogWriter.writeMethod("{generateTransformedImageSingle}", 0);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl = true;
        if (bufferedImage != null) {
            boolean bl2;
            Area area = this.currentGraphicsState.getClippingShape();
            ImageTransformer imageTransformer = new ImageTransformer(PdfDecoder.dpi, this.currentGraphicsState, bufferedImage, true, PdfDecoder.isDraft);
            f = imageTransformer.getImageX();
            f2 = imageTransformer.getImageY();
            f3 = imageTransformer.getImageW();
            f4 = imageTransformer.getImageH();
            bufferedImage = imageTransformer.getImage();
            if (bufferedImage != null && area != null && area.getBounds().getWidth() > 1.0 && area.getBounds().getHeight() > 1.0 && !(bl2 = area.contains(f, f2, f3, f4))) {
                imageTransformer.clipImage(area);
                f = imageTransformer.getImageX();
                f2 = imageTransformer.getImageY();
                f3 = imageTransformer.getImageW();
                f4 = imageTransformer.getImageH();
            }
            bufferedImage = imageTransformer.getImage();
            imageTransformer = null;
            if (bufferedImage != null) {
                if (this.currentGraphicsState.CTM[0][1] > 0.0f & this.currentGraphicsState.CTM[1][0] > 0.0f) {
                    double d = 1.0;
                    double d2 = 1.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    if (this.currentGraphicsState.CTM[0][1] > 0.0f) {
                        d = -1.0;
                        d3 = bufferedImage.getWidth();
                    }
                    if (this.currentGraphicsState.CTM[1][0] > 0.0f) {
                        d2 = -1.0;
                        d4 = bufferedImage.getHeight();
                    }
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.scale(d, d2);
                    affineTransform.translate(-d3, -d4);
                    AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
                    bufferedImage = affineTransformOp.filter(bufferedImage, null);
                }
                if (bufferedImage != null) {
                    this.currentGraphicsState.x = f;
                    this.currentGraphicsState.y = f2;
                    if (this.renderDirectly) {
                        this.current.renderImage(null, bufferedImage, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y);
                    } else {
                        this.current.drawImage(bufferedImage, this.currentGraphicsState);
                    }
                }
            }
        } else {
            LogWriter.writeLog("NO image written");
        }
    }

    private final BufferedImage generateClippedHires(BufferedImage bufferedImage) {
        LogWriter.writeMethod("{generateClippedHires}", 0);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (bufferedImage != null) {
            ImageTransformerDouble imageTransformerDouble = new ImageTransformerDouble(PdfDecoder.dpi, this.currentGraphicsState, bufferedImage, this.createScaledVersion);
            imageTransformerDouble.createClippedHiresScreenImage();
            bufferedImage = imageTransformerDouble.getImage();
            if (this.currentPdfFile.isExtractionAllowed()) {
                Object object;
                int n = 1;
                int n2 = 1;
                int n3 = 0;
                int n4 = 0;
                if (this.currentGraphicsState.CTM[0][0] < 0.0f) {
                    n = -n;
                    n3 = bufferedImage.getWidth();
                }
                if (this.currentGraphicsState.CTM[1][1] < 0.0f) {
                    n2 = -n2;
                    n4 = bufferedImage.getHeight();
                }
                if (n2 < 0 | n < 0) {
                    object = new AffineTransform();
                    ((AffineTransform)object).scale(n, n2);
                    ((AffineTransform)object).translate(-n3, -n4);
                    AffineTransformOp affineTransformOp = new AffineTransformOp((AffineTransform)object, ColorSpaces.hints);
                    bufferedImage = affineTransformOp.filter(bufferedImage, null);
                }
                if ((object = ObjectStore.getImageType(this.currentImage)) == null) {
                    object = "tif";
                }
            }
            imageTransformerDouble.completeImage();
            f = imageTransformerDouble.getImageX();
            f2 = imageTransformerDouble.getImageY();
            f3 = imageTransformerDouble.getImageW();
            f4 = imageTransformerDouble.getImageH();
            bufferedImage = imageTransformerDouble.getImage();
            imageTransformerDouble = null;
        } else {
            LogWriter.writeLog("NO image written");
        }
        return bufferedImage;
    }

    protected void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    private final void processTextArray(byte[] byArray, int n, int n2) {
        while (byArray[n] == 91 | byArray[n] == 10 | byArray[n] == 13 | byArray[n] == 32) {
            ++n;
        }
        this.textLength = 0;
        int n3 = ((Color)this.nonstrokeColorSpace.getColor()).getRGB();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        float[][] fArray = new float[3][3];
        float[][] fArray2 = new float[3][3];
        float[][] fArray3 = new float[3][3];
        int n4 = 32;
        int n5 = 32;
        int n6 = 32;
        int n7 = 120;
        int n8 = 0;
        int n9 = 0;
        boolean bl4 = false;
        float f = 0.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        String string = "";
        float f6 = this.currentTextState.getTfs();
        this.charSpacing = this.currentTextState.getCharacterSpacing() / f6;
        float f7 = this.currentTextState.getWordSpacing() / f6;
        int n10 = this.currentFontData.getFontType();
        boolean bl5 = this.currentFontData.isCIDFont();
        this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
        this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
        int n11 = 2;
        if (bl5) {
            n11 = 4;
        }
        fArray = Matrix.multiply(this.currentTextState.Tm, this.currentGraphicsState.CTM);
        fArray[0][0] = fArray[0][0];
        fArray[0][1] = fArray[0][1];
        fArray[1][0] = fArray[1][0];
        fArray[1][1] = fArray[1][1];
        if (this.multipleTJs) {
            fArray[2][0] = this.currentTextState.Tm[2][0];
            fArray[2][1] = this.currentTextState.Tm[2][1];
        }
        fArray2[0][0] = f6 * this.currentTextState.getHorizontalScaling();
        fArray2[1][1] = f6;
        fArray2[2][1] = this.currentTextState.getTextRise();
        fArray2[2][2] = 1.0f;
        fArray = Matrix.multiply(fArray2, fArray);
        this.multipleTJs = true;
        if (fArray[1][1] != 0.0f) {
            bl2 = true;
            n8 = Math.round(fArray[1][1]);
            if (n8 == 0) {
                n8 = Math.round(fArray[0][1]);
            }
            f2 = fArray[0][0];
        } else {
            bl2 = false;
            n8 = Math.round(fArray[1][0]);
            if (n8 == 0) {
                n8 = Math.round(fArray[0][0]);
            }
            if (n8 < 0) {
                n8 = -n8;
            }
            f2 = fArray[0][1];
        }
        if (n8 == 0) {
            n8 = 1;
        }
        float f8 = fArray[2][0];
        float f9 = fArray[2][1];
        float f10 = n8 / 2;
        if (bl5) {
            f10 = fArray[1][1];
        }
        for (int i = n; i < n2; ++i) {
            int n12;
            while (true) {
                n5 = n5 == 92 && n4 == 92 ? 120 : n4;
                n9 = byArray[i];
                if (n9 < 0) {
                    n9 = 256 + n9;
                }
                if ((n4 = (int)((char)n9)) == 92 && byArray[i + 1] == 13 | byArray[i + 1] == 10) {
                    ++i;
                } else if (n4 != 10 & n4 != 13) break;
                ++i;
            }
            if (bl3) {
                if (n5 != 92 && n4 == 41) {
                    bl3 = false;
                } else if (n6 == 60 && n4 == 62) {
                    bl3 = false;
                }
            }
            if (bl3) {
                block72: {
                    Object object;
                    n7 = n4;
                    if (n6 == 60) {
                        object = new StringBuffer(4);
                        ((StringBuffer)object).append((char)n4);
                        for (int j = 1; j < n11; ++j) {
                            int n13 = byArray[i + j];
                            if (n13 == 62) {
                                j = 4;
                                n11 = 2;
                                continue;
                            }
                            if (n13 == 10 | n13 == 13) {
                                ++i;
                                --j;
                                continue;
                            }
                            if (n13 < 0) {
                                n13 = 256 + n13;
                            }
                            n4 = (char)n13;
                            ((StringBuffer)object).append((char)n4);
                        }
                        i = i + n11 - 1;
                        n9 = Integer.parseInt(((StringBuffer)object).toString(), 16);
                        n4 = (char)n9;
                        string = this.currentFontData.getGlyphValue(n9);
                    } else if (n4 == 92) {
                        n5 = n4;
                        n9 = byArray[++i];
                        n4 = (char)n9;
                        if (byArray.length > i + 2 && Character.isDigit((char)byArray[i]) && Character.isDigit((char)byArray[i + 1]) && Character.isDigit((char)byArray[i + 2])) {
                            n9 = this.readEscapeValue(i, 3, 8, byArray);
                            i += 2;
                            string = this.currentFontData.getGlyphValue(n9);
                            n4 = (char)n9;
                            if (n4 == 92) {
                                n4 = 120;
                            }
                        } else {
                            n9 = byArray[i];
                            n4 = (char)n9;
                            if (n4 == 117) {
                                n9 = this.readEscapeValue(i + 1, 4, 16, byArray);
                                i += 4;
                                string = this.currentFontData.getGlyphValue(n9);
                            } else {
                                if (n4 == 110) {
                                    n9 = 10;
                                    n4 = 10;
                                } else if (n4 == 98) {
                                    n9 = 8;
                                    n4 = 8;
                                } else if (n4 == 116) {
                                    n9 = 9;
                                    n4 = 9;
                                } else if (n4 == 114) {
                                    n9 = 13;
                                    n4 = 13;
                                } else if (n4 == 102) {
                                    n9 = 12;
                                    n4 = 12;
                                }
                                string = this.currentFontData.getGlyphValue(n9);
                                if (string.length() > 0) {
                                    n4 = string.charAt(0);
                                }
                            }
                        }
                    } else {
                        string = bl5 ? "" + (char)n4 : this.currentFontData.getGlyphValue(n9);
                    }
                    fArray2[0][0] = 1.0f;
                    fArray2[0][1] = 0.0f;
                    fArray2[0][2] = 0.0f;
                    fArray2[1][0] = 0.0f;
                    fArray2[1][1] = 1.0f;
                    fArray2[1][2] = 0.0f;
                    fArray2[2][0] = f4 + f5;
                    fArray2[2][1] = 0.0f;
                    fArray2[2][2] = 1.0f;
                    fArray = Matrix.multiply(fArray2, fArray);
                    if (n4 == 32 && n5 != 32) {
                        fArray3 = fArray;
                    }
                    f5 = 0.0f;
                    f4 = this.currentFontData.getWidth(n9);
                    if (string.length() > 0) {
                        if (this.currentFontData.getFontType() == 3) {
                            object = "notdef";
                            try {
                                object = this.currentFontData.getMappedChar(n9, false);
                                PdfGlyph pdfGlyph = this.currentFontData.getEmbeddedGlyph(this.factory, (String)object, fArray, n9, string, f4);
                                if (n10 == 3) {
                                    if (pdfGlyph != null && pdfGlyph.getmaxWidth() == 0) {
                                        pdfGlyph = null;
                                    } else if (pdfGlyph.ignoreColors()) {
                                        pdfGlyph.lockColors(this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getNonstrokeColor());
                                    }
                                }
                                if (pdfGlyph == null) break block72;
                                AffineTransform affineTransform = new AffineTransform(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]);
                                if (n10 == 3 && this.renderDirectly) {
                                    affineTransform.scale(f4 / (float)pdfGlyph.getmaxWidth(), this.currentFontData.FontMatrix[3]);
                                } else {
                                    affineTransform.scale(this.currentFontData.FontMatrix[0], this.currentFontData.FontMatrix[3]);
                                }
                                n12 = n10;
                                n12 = n10 == 2 | n10 == 5 | this.currentFontData.isFontSubstituted() ? 4 : (n10 == 3 ? 6 : 5);
                                if (this.renderDirectly) {
                                    Paint paint = null;
                                    int n14 = this.currentGraphicsState.getTextRenderType();
                                    if ((n14 & 2) == 2) {
                                        paint = this.currentGraphicsState.getNonstrokeColor();
                                    }
                                    if ((n14 & 1) == 1) {
                                        paint = this.currentGraphicsState.getStrokeColor();
                                    }
                                    this.current.renderEmbeddedText(pdfGlyph, n12, this.g2, affineTransform, false, paint);
                                    break block72;
                                }
                                this.current.drawEmbeddedText(fArray, n8, pdfGlyph, n12, this.currentGraphicsState, affineTransform);
                            }
                            catch (Exception exception) {
                                this.addPageFailureMessage("Exception " + exception + " on embedded font renderer");
                            }
                        } else if (string.length() > 0 && !string.startsWith("&#") && (object = PdfDecoder.isRunningOnMac | StandardFonts.isStandardFont(this.currentFontData.getRawFontName()) ? this.currentFontData.getStandardGlyph(fArray, n9, string, f4) : this.currentFontData.getApproximateGlyph(fArray, n9, string, f4)) != null) {
                            AffineTransform affineTransform = AffineTransform.getTranslateInstance(fArray[2][0], fArray[2][1]);
                            ((Area)object).transform(affineTransform);
                            if (this.renderDirectly) {
                                Paint paint = null;
                                n12 = this.currentGraphicsState.getTextRenderType();
                                if ((n12 & 2) == 2) {
                                    paint = this.currentGraphicsState.getNonstrokeColor();
                                }
                                if ((n12 & 1) == 1) {
                                    paint = this.currentGraphicsState.getStrokeColor();
                                }
                                this.current.renderText((Area)object, this.g2, false, paint);
                            } else {
                                this.current.drawText((Area)object, this.currentGraphicsState);
                            }
                        }
                    }
                }
                f4 += this.charSpacing;
                if (n4 != 32) continue;
                f4 += f7;
                continue;
            }
            if (n4 == 40 | n4 == 60) {
                bl3 = true;
                n6 = n4;
                continue;
            }
            if (!(n4 == 41 | (n4 == 62 && n6 == 60))) continue;
            float f11 = 0.0f;
            ++i;
            while (byArray[i] == 32) {
                ++i;
            }
            char c = (char)byArray[i];
            if (c == '(' | c == '<') {
                --i;
            } else if (c != '(' && c != ']' && c != '<') {
                StringBuffer stringBuffer = new StringBuffer(6);
                int n15 = i;
                n12 = 0;
                while (n12 == 0) {
                    n4 = c;
                    stringBuffer.append((char)n4);
                    c = (char)byArray[i + 1];
                    if (c == '(' | c == '<') break;
                    if (!(c == '-' | c == '.' | c == ' ' | Character.isDigit(c))) {
                        n12 = 1;
                    }
                    ++i;
                }
                if (n12 != 0) {
                    i = n15;
                } else {
                    f11 = -Float.parseFloat(stringBuffer.toString()) / 1000.0f;
                }
            }
            f += f11;
            f5 += f11;
        }
        fArray2[0][0] = 1.0f;
        fArray2[0][1] = 0.0f;
        fArray2[0][2] = 0.0f;
        fArray2[1][0] = 0.0f;
        fArray2[1][1] = 1.0f;
        fArray2[1][2] = 0.0f;
        fArray2[2][0] = f4 + f5;
        fArray2[2][1] = 0.0f;
        fArray2[2][2] = 1.0f;
        fArray = Matrix.multiply(fArray2, fArray);
        this.currentTextState.Tm[2][0] = fArray[2][0];
        this.currentTextState.Tm[2][1] = fArray[2][1];
    }

    private final int readEscapeValue(int n, int n2, int n3, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append((char)byArray[n + i]);
        }
        return Integer.parseInt(stringBuffer.toString(), n3);
    }

    public static String getFontsInFile() {
        return fontsInFile;
    }

    public void setDirectRendering(Graphics2D graphics2D) {
        this.renderDirectly = true;
        this.g2 = graphics2D;
        this.defaultClip = graphics2D.getClip();
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public void includeImages() {
        this.includeImagesInData = true;
    }

    public PageLines getPageLines() {
        this.pageLines.lookForCompositeLines();
        return this.pageLines;
    }

    protected boolean isPageSuccessful() {
        return this.pageSuccessful;
    }

    protected String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    protected void addPageFailureMessage(String string) {
        this.pageSuccessful = false;
        this.pageErrorMessages = this.pageErrorMessages + string + "\n";
    }
}

