/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.renderer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jpedal.PdfPanel;
import org.jpedal.color.ColorSpaces;
import org.jpedal.fonts.PdfGlyph;
import org.jpedal.fonts.T3Glyph;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;

public final class DynamicVectorRenderer {
    private Paint fillCol = null;
    private Paint strokeCol = null;
    public static boolean debugPaint = false;
    private boolean useHiResImageForDisplay = false;
    private static RenderingHints hints = null;
    private int w = 0;
    private int h = 0;
    private Color backgroundColor = Color.white;
    private Vector_Float x_coord;
    private Vector_Float y_coord;
    private Vector_Object text_color;
    private Vector_Object stroke_color;
    private Vector_Object fill_color;
    private Vector_Object stroke;
    private Vector_Object pageObjects;
    private Vector_Int shapeType;
    private Vector_Rectangle areas;
    private Vector_Double af1;
    private Vector_Double af2;
    private Vector_Double af3;
    private Vector_Double af4;
    private Vector_Shape clips;
    private Vector_Int objectType;
    private Vector_Float alphas;
    private static final int TEXT = 1;
    private static final int SHAPE = 2;
    private static final int IMAGE = 3;
    public static final int TRUETYPE = 4;
    public static final int TYPE1C = 5;
    public static final int TYPE3 = 6;
    public static final int CLIP = 7;
    public static final int COLOR = 8;
    public static final int AF = 9;
    public static final int TEXTCOLOR = 10;
    public static final int FILLCOLOR = 11;
    public static final int STROKECOLOR = 12;
    public static final int STROKE = 14;
    private boolean addBackground = true;
    private boolean pageDrawing = false;
    private int currentItem = 0;
    private int lastTextCol;
    private int lastFillCol;
    private int lastStrokeCol;
    private Stroke lastStroke = null;
    private double[] lastAf = new double[4];
    int xx = 0;
    int yy = 0;
    private double minX = -1.0;
    private double minY = -1.0;
    private double maxX = -1.0;
    private double maxY = -1.0;
    private AffineTransform aff = new AffineTransform();
    private int rotation = 0;
    private boolean colorsLocked;
    private boolean optimiseDrawing;
    boolean hasClips = false;
    Area lastClip = null;
    private File tmpFile;

    public DynamicVectorRenderer(boolean bl, int n) {
        this.addBackground = bl;
        this.setupArrays(n);
    }

    private void setupArrays(int n) {
        this.x_coord = new Vector_Float(n);
        this.y_coord = new Vector_Float(n);
        this.text_color = new Vector_Object(n);
        this.stroke_color = new Vector_Object(n);
        this.fill_color = new Vector_Object(n);
        this.stroke = new Vector_Object(n);
        this.pageObjects = new Vector_Object(n);
        this.shapeType = new Vector_Int(n);
        this.areas = new Vector_Rectangle(n);
        this.af1 = new Vector_Double(n);
        this.af2 = new Vector_Double(n);
        this.af3 = new Vector_Double(n);
        this.af4 = new Vector_Double(n);
        this.clips = new Vector_Shape(n);
        this.objectType = new Vector_Int(n);
        this.alphas = new Vector_Float(n);
    }

    public DynamicVectorRenderer() {
        this.init();
    }

    private void init() {
        this.x_coord = new Vector_Float(2000);
        this.y_coord = new Vector_Float(2000);
        this.text_color = new Vector_Object(2000);
        this.stroke_color = new Vector_Object(2000);
        this.fill_color = new Vector_Object(2000);
        this.stroke = new Vector_Object(200);
        this.pageObjects = new Vector_Object(2000);
        this.shapeType = new Vector_Int(200);
        this.areas = new Vector_Rectangle(2000);
        this.af1 = new Vector_Double(2000);
        this.af2 = new Vector_Double(2000);
        this.af3 = new Vector_Double(2000);
        this.af4 = new Vector_Double(2000);
        this.clips = new Vector_Shape(200);
        this.objectType = new Vector_Int(2000);
        this.alphas = new Vector_Float(20);
    }

    public final void renderText(Area area, Graphics2D graphics2D, boolean bl, Paint paint) {
        Color color = (Color)paint;
        if (bl) {
            int n;
            int n2;
            int n3 = 150 - color.getRed();
            if (n3 < 0) {
                n3 = -n3;
            }
            if ((n2 = 150 - color.getGreen()) < 0) {
                n2 = -n2;
            }
            if ((n = 150 - color.getBlue()) < 0) {
                n = -n;
            }
            if (n3 > 120 && n3 < 136 && n2 > 120 && n2 < 136 && n > 120 & n < 136) {
                graphics2D.setPaint(Color.black);
            } else {
                graphics2D.setPaint(new Color(n3, n2, n));
            }
        } else {
            graphics2D.setPaint(color);
        }
        graphics2D.fill(area);
    }

    public final void renderEmbeddedText(Object object, int n, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl, Paint paint) {
        T3Glyph t3Glyph = null;
        Color color = (Color)paint;
        if (n == 6) {
            t3Glyph = (T3Glyph)object;
        }
        if (bl) {
            int n2;
            int n3;
            int n4 = 150 - color.getRed();
            if (n4 < 0) {
                n4 = -n4;
            }
            if ((n3 = 150 - color.getGreen()) < 0) {
                n3 = -n3;
            }
            if ((n2 = 150 - color.getBlue()) < 0) {
                n2 = -n2;
            }
            if (n4 > 120 && n4 < 136 && n3 > 120 && n3 < 136 && n2 > 120 & n2 < 136) {
                graphics2D.setPaint(Color.black);
            } else {
                graphics2D.setPaint(new Color(n4, n3, n2));
            }
        } else {
            graphics2D.setPaint(color);
        }
        if (t3Glyph != null) {
            AffineTransform affineTransform2 = graphics2D.getTransform();
            graphics2D.transform(affineTransform);
            try {
                t3Glyph.render(graphics2D, false);
            }
            catch (Exception exception) {
                System.out.println("Exception " + exception + " rendering glyph");
                exception.printStackTrace();
            }
            graphics2D.setTransform(affineTransform2);
        }
    }

    public final void renderImage(AffineTransform affineTransform, BufferedImage bufferedImage, float f, GraphicsState graphicsState, Graphics2D graphics2D, float f2, float f3) {
        boolean bl = graphicsState != null;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        AffineTransform affineTransform2 = new AffineTransform();
        if (bl | this.useHiResImageForDisplay) {
            if (bl) {
                affineTransform2 = new AffineTransform(graphicsState.CTM[0][0] / (float)n, graphicsState.CTM[0][1] / (float)n, graphicsState.CTM[1][0] / (float)n2, graphicsState.CTM[1][1] / (float)n2, graphicsState.CTM[2][0], graphicsState.CTM[2][1]);
                affineTransform2.translate(n, n2);
                affineTransform2.scale(1.0, -1.0);
                affineTransform2.translate(-n, 0.0);
            } else {
                affineTransform2 = affineTransform;
            }
        } else if (n2 > 1) {
            affineTransform2.translate(n, n2);
            affineTransform2.scale(1.0, -1.0);
            affineTransform2.translate(-n, 0.0);
        }
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform2, ColorSpaces.hints);
        Composite composite = graphics2D.getComposite();
        if (f != -1.0f) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        }
        if (bl | this.useHiResImageForDisplay) {
            try {
                graphics2D.drawImage(bufferedImage, affineTransform2, null);
            }
            catch (Exception exception) {}
        } else {
            bufferedImage = affineTransformOp.filter(bufferedImage, null);
            graphics2D.drawImage((Image)bufferedImage, (int)f2, (int)f3, null);
        }
        graphics2D.setComposite(composite);
    }

    public final void renderShape(int n, Paint paint, Paint paint2, Stroke stroke, Shape shape, Graphics2D graphics2D) {
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setStroke(stroke);
        if (n == 2 | n == 3) {
            graphics2D.setPaint(paint2);
            graphics2D.fill(shape);
        }
        if (n == 1 | n == 3) {
            graphics2D.setPaint(paint);
            graphics2D.draw(shape);
        }
        graphics2D.setStroke(stroke2);
    }

    public synchronized void flush() {
        PdfPanel.isFlushing = true;
        if (this.shapeType != null) {
            this.shapeType.clear();
            this.pageObjects.clear();
            this.objectType.clear();
            this.areas.clear();
            this.clips.clear();
            this.x_coord.clear();
            this.y_coord.clear();
            this.alphas.clear();
            this.text_color.clear();
            this.fill_color.clear();
            this.stroke_color.clear();
            this.stroke.clear();
            this.af1.clear();
            this.af2.clear();
            this.af3.clear();
            this.af4.clear();
        }
        this.lastTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.currentItem = 0;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            this.addBackground = false;
        } else {
            this.backgroundColor = color;
        }
    }

    public void paint(Graphics2D graphics2D, Rectangle[] rectangleArray, int n, int n2) {
        this.xx = n < 0 ? n : 0;
        this.yy = n2 < 0 ? n2 : 0;
        this.paint(graphics2D, rectangleArray, null);
    }

    public synchronized Rectangle paint(Graphics2D graphics2D, Rectangle[] rectangleArray, AffineTransform affineTransform) {
        PdfPanel.isFlushing = false;
        int n = 0;
        if (!this.pageDrawing) {
            this.pageDrawing = true;
            Rectangle rectangle = null;
            int[] nArray = this.objectType.get();
            int n2 = nArray.length;
            Area[] areaArray = this.clips.get();
            double[] dArray = this.af1.get();
            double[] dArray2 = this.af2.get();
            double[] dArray3 = this.af3.get();
            double[] dArray4 = this.af4.get();
            Rectangle[] rectangleArray2 = this.areas.get();
            float[] fArray = this.alphas.get();
            float[] fArray2 = this.x_coord.get();
            float[] fArray3 = this.y_coord.get();
            Object[] objectArray = this.text_color.get();
            Object[] objectArray2 = this.fill_color.get();
            Object[] objectArray3 = this.stroke_color.get();
            Object[] objectArray4 = this.pageObjects.get();
            Object[] objectArray5 = this.stroke.get();
            int[] nArray2 = this.shapeType.get();
            Shape shape = graphics2D.getClip();
            if (shape != null) {
                rectangle = shape.getBounds();
            }
            boolean bl = false;
            Shape shape2 = graphics2D.getClip();
            Area area = null;
            boolean bl2 = false;
            if (this.addBackground) {
                graphics2D.setColor(this.backgroundColor);
                if (rectangle == null) {
                    graphics2D.fill(new Rectangle(this.xx, this.yy, this.w, this.h));
                } else {
                    graphics2D.fill(rectangle);
                }
            }
            AffineTransform affineTransform2 = graphics2D.getTransform();
            if (affineTransform != null) {
                graphics2D.transform(affineTransform);
                shape2 = graphics2D.getClip();
            }
            this.minX = -1.0;
            this.minY = -1.0;
            this.maxX = -1.0;
            this.maxY = -1.0;
            int n3 = 0;
            float f = 0.0f;
            float f2 = 0.0f;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = -1;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            Color color = null;
            Paint paint = null;
            Paint paint2 = null;
            Stroke stroke = null;
            if (this.colorsLocked) {
                paint2 = this.strokeCol;
                paint = this.fillCol;
            }
            block27: for (int i = 0; i < n2; ++i) {
                boolean bl3 = false;
                boolean bl4 = false;
                n3 = nArray[i];
                if (n3 <= 0) continue;
                if (this.optimiseDrawing && this.rotation == 0 && rectangle != null && n3 != 7 && rectangleArray2[i] != null && !rectangle.intersects(rectangleArray2[i])) {
                    bl3 = true;
                }
                if (bl3) {
                    switch (n3) {
                        case 2: {
                            ++n6;
                            break;
                        }
                        case 3: {
                            ++n4;
                            break;
                        }
                        case 7: {
                            ++n5;
                        }
                        case 4: {
                            ++n7;
                            break;
                        }
                        case 5: {
                            ++n7;
                            break;
                        }
                        case 6: {
                            ++n7;
                            break;
                        }
                        case 9: {
                            ++n8;
                            break;
                        }
                        case 10: {
                            n9 += 2;
                            break;
                        }
                        case 11: {
                            n11 += 2;
                            break;
                        }
                        case 12: {
                            n12 += 2;
                            break;
                        }
                        case 14: {
                            ++n10;
                        }
                    }
                    continue;
                }
                if (!bl) {
                    graphics2D.setRenderingHints(hints);
                    bl = true;
                }
                ++n;
                Object object = objectArray4[i];
                f = fArray2[i];
                f2 = fArray3[i];
                double[] dArray5 = new double[6];
                switch (n3) {
                    case 2: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        this.renderShape(nArray2[n6], paint2, paint, stroke, (Shape)object, graphics2D);
                        ++n6;
                        continue block27;
                    }
                    case 1: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        if (rectangleArray != null) {
                            bl4 = this.setHighlightForGlyph(rectangleArray2[i], nArray, graphics2D, rectangleArray, i, bl4, color);
                        }
                        this.renderText((Area)object, graphics2D, bl4, color);
                        continue block27;
                    }
                    case 4: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        if (rectangleArray != null) {
                            bl4 = this.setHighlightForGlyph(rectangleArray2[i], nArray, graphics2D, rectangleArray, i, bl4, color);
                        }
                        this.aff = new AffineTransform(dArray[n8], dArray2[n8], dArray3[n8], dArray4[n8], (double)f, (double)f2);
                        this.renderEmbeddedText(object, 4, graphics2D, this.aff, bl4, color);
                        ++n7;
                        continue block27;
                    }
                    case 5: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        if (rectangleArray != null) {
                            bl4 = this.setHighlightForGlyph(rectangleArray2[i], nArray, graphics2D, rectangleArray, i, bl4, color);
                        }
                        this.aff = new AffineTransform(dArray[n8], dArray2[n8], dArray3[n8], dArray4[n8], (double)f, (double)f2);
                        this.renderEmbeddedText(object, 5, graphics2D, this.aff, bl4, color);
                        ++n7;
                        continue block27;
                    }
                    case 6: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        if (rectangleArray != null) {
                            bl4 = this.setHighlightForGlyph(rectangleArray2[i], nArray, graphics2D, rectangleArray, i, bl4, color);
                        }
                        this.aff = new AffineTransform(dArray[n8], dArray2[n8], dArray3[n8], dArray4[n8], (double)f, (double)f2);
                        this.renderEmbeddedText(object, 6, graphics2D, this.aff, bl4, color);
                        ++n7;
                        continue block27;
                    }
                    case 3: {
                        if (bl2) {
                            this.renderClip(area, rectangle, shape2, graphics2D);
                            bl2 = false;
                        }
                        if (!this.useHiResImageForDisplay) {
                            this.renderImage(null, (BufferedImage)object, fArray[n4], null, graphics2D, f, f2);
                        }
                        ++n4;
                        continue block27;
                    }
                    case 7: {
                        area = areaArray[n5];
                        bl2 = true;
                        ++n5;
                        continue block27;
                    }
                    case 9: {
                        ++n8;
                        continue block27;
                    }
                    case 10: {
                        color = (Color)objectArray[n9];
                        ++n9;
                        continue block27;
                    }
                    case 11: {
                        if (!this.colorsLocked) {
                            paint = (Color)objectArray2[n11];
                        }
                        ++n11;
                        continue block27;
                    }
                    case 12: {
                        if (!this.colorsLocked) {
                            paint2 = (Color)objectArray3[n12];
                        }
                        ++n12;
                        continue block27;
                    }
                    case 14: {
                        stroke = (Stroke)objectArray5[n10];
                        ++n10;
                    }
                }
            }
            graphics2D.setClip(shape2);
            graphics2D.setTransform(affineTransform2);
        }
        if (debugPaint) {
            System.err.println("Painted " + n);
        }
        this.pageDrawing = false;
        if (this.minX == -1.0) {
            return null;
        }
        return new Rectangle((int)this.minX, (int)this.minY, (int)(this.maxX - this.minX), (int)(this.maxY - this.minY));
    }

    public void renderClip(Area area, Rectangle rectangle, Shape shape, Graphics2D graphics2D) {
        if (area != null) {
            graphics2D.setClip(area);
            if (rectangle != null) {
                graphics2D.clip(rectangle);
            }
        } else {
            graphics2D.setClip(shape);
        }
    }

    private boolean setHighlightForGlyph(Rectangle rectangle, int[] nArray, Graphics2D graphics2D, Rectangle[] rectangleArray, int n, boolean bl, Paint paint) {
        int n2 = rectangleArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[n];
            if (rectangle == null || !(n3 == 1 | n3 == 4 | n3 == 5 | n3 == 6) || rectangleArray[i] == null || !rectangleArray[i].intersects(rectangle) || !(rectangleArray[i].getMinX() <= rectangle.getMinX()) || !(rectangleArray[i].getMinY() <= rectangle.getMinY())) continue;
            i = n2;
            bl = true;
            Rectangle2D rectangle2D = rectangle.getBounds2D();
            if (this.minX == -1.0) {
                this.minX = rectangle2D.getMinX();
                this.minY = rectangle2D.getMinY();
                this.maxX = rectangle2D.getMaxX();
                this.maxY = rectangle2D.getMaxY();
                continue;
            }
            double d = rectangle2D.getMinX();
            if (d < this.minX) {
                this.minX = d;
            }
            if ((d = rectangle2D.getMinY()) < this.minY) {
                this.minY = d;
            }
            if ((d = rectangle2D.getMaxX()) > this.maxX) {
                this.maxX = d;
            }
            if (!((d = rectangle2D.getMaxY()) > this.maxY)) continue;
            this.maxY = d;
        }
        return bl;
    }

    public final synchronized void drawText(Area area, GraphicsState graphicsState) {
        int n;
        Paint paint = null;
        int n2 = graphicsState.getTextRenderType();
        if ((n2 & 2) == 2) {
            paint = graphicsState.getNonstrokeColor();
        }
        if ((n2 & 1) == 1) {
            paint = graphicsState.getStrokeColor();
        }
        if (this.lastTextCol != (n = ((Color)paint).getRGB())) {
            this.lastTextCol = n;
            this.drawColor((Color)paint);
        }
        this.pageObjects.addElement(area);
        this.objectType.addElement(1);
        this.areas.addElement(area.getBounds());
        this.x_coord.addElement(graphicsState.x);
        this.y_coord.addElement(graphicsState.y);
        ++this.currentItem;
    }

    public final void init(int n, int n2, int n3) {
        this.w = n;
        this.h = n2;
        this.rotation = n3;
    }

    public final synchronized BufferedImage getPageAsImage(float f, int n, int n2, int n3, int n4, int n5, AffineTransform affineTransform, int n6) {
        if (n3 < 0) {
            n3 = this.w;
            n4 = this.h;
        } else {
            n3 = (int)((float)n3 * f);
            n4 = (int)((float)n4 * f);
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, n6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AffineTransform affineTransform2 = graphics2D.getTransform();
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        this.paint(graphics2D, null, n, n2);
        graphics2D.setTransform(affineTransform2);
        return bufferedImage;
    }

    public final synchronized void drawImage(BufferedImage bufferedImage, GraphicsState graphicsState) {
        if (this.useHiResImageForDisplay) {
            // empty if block
        }
        this.x_coord.addElement(graphicsState.x);
        this.y_coord.addElement(graphicsState.y);
        this.objectType.addElement(3);
        this.areas.addElement(new Rectangle((int)graphicsState.x, (int)graphicsState.y, bufferedImage.getWidth(), bufferedImage.getHeight()));
        this.alphas.addElement(graphicsState.getNonStrokeAlpha());
        if (this.useHiResImageForDisplay) {
            bufferedImage = null;
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(bufferedImage);
        }
        ++this.currentItem;
    }

    public final synchronized void drawShape(Shape shape, GraphicsState graphicsState) {
        Paint paint;
        int n;
        int n2 = graphicsState.getFillType();
        if (n2 == 2 | n2 == 3 && this.lastFillCol != (n = ((Color)(paint = graphicsState.getNonstrokeColor())).getRGB())) {
            this.lastFillCol = n;
            this.drawFillColor((Color)paint);
        }
        if (n2 == 1 | n2 == 3 && this.lastStrokeCol != (n = ((Color)(paint = graphicsState.getStrokeColor())).getRGB())) {
            this.lastStrokeCol = n;
            this.drawStrokeColor((Color)paint);
        }
        Stroke stroke = graphicsState.getStroke();
        if (this.lastStroke == null || !this.lastStroke.equals(stroke)) {
            this.lastStroke = stroke;
            this.drawStroke(stroke);
        }
        this.pageObjects.addElement(shape);
        this.objectType.addElement(2);
        this.areas.addElement(shape.getBounds());
        this.x_coord.addElement(graphicsState.x);
        this.y_coord.addElement(graphicsState.y);
        this.shapeType.addElement(n2);
        ++this.currentItem;
    }

    public final synchronized void drawColor(Color color) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(10);
        this.areas.addElement(null);
        this.text_color.addElement(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        this.x_coord.addElement(0.0f);
        this.y_coord.addElement(0.0f);
        ++this.currentItem;
    }

    public final synchronized void drawFillColor(Color color) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(11);
        this.areas.addElement(null);
        this.fill_color.addElement(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        this.x_coord.addElement(0.0f);
        this.y_coord.addElement(0.0f);
        ++this.currentItem;
    }

    public final synchronized void drawStrokeColor(Color color) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(12);
        this.areas.addElement(null);
        this.stroke_color.addElement(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        this.x_coord.addElement(0.0f);
        this.y_coord.addElement(0.0f);
        ++this.currentItem;
    }

    public final synchronized void drawStroke(Stroke stroke) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(14);
        this.areas.addElement(null);
        this.stroke.addElement(stroke);
        this.x_coord.addElement(0.0f);
        this.y_coord.addElement(0.0f);
        ++this.currentItem;
    }

    public final synchronized void drawClip(GraphicsState graphicsState) {
        Area area = graphicsState.getClippingShape();
        if (!this.hasClips || this.lastClip != null || area != null) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(7);
            this.areas.addElement(null);
            this.lastClip = area;
            if (area == null) {
                this.clips.addElement(null);
            } else {
                this.clips.addElement((Area)area.clone());
            }
            this.x_coord.addElement(graphicsState.x);
            this.y_coord.addElement(graphicsState.y);
            ++this.currentItem;
        }
        this.hasClips = true;
    }

    public synchronized void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, int n2, GraphicsState graphicsState, AffineTransform affineTransform) {
        int n3;
        Paint paint = null;
        int n4 = graphicsState.getTextRenderType();
        if ((n4 & 2) == 2) {
            paint = graphicsState.getNonstrokeColor();
        }
        if ((n4 & 1) == 1) {
            paint = graphicsState.getStrokeColor();
        }
        if (this.lastTextCol != (n3 = ((Color)paint).getRGB())) {
            this.lastTextCol = n3;
            this.drawColor((Color)paint);
        }
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        if (this.lastAf[0] != dArray[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3]) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        this.pageObjects.addElement(pdfGlyph);
        this.objectType.addElement(n2);
        this.x_coord.addElement((float)affineTransform.getTranslateX());
        this.y_coord.addElement((float)affineTransform.getTranslateY());
        this.areas.addElement(new Rectangle((int)fArray[2][0], (int)fArray[2][1], n, n));
        ++this.currentItem;
    }

    public synchronized void drawAffine(double[] dArray) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(9);
        this.areas.addElement(null);
        this.af1.addElement(dArray[0]);
        this.af2.addElement(dArray[1]);
        this.af3.addElement(dArray[2]);
        this.af4.addElement(dArray[3]);
        this.x_coord.addElement((float)dArray[4]);
        this.y_coord.addElement((float)dArray[5]);
        ++this.currentItem;
    }

    public void renderAffine(AffineTransform affineTransform) {
        this.aff = affineTransform;
    }

    public boolean addBackground() {
        return this.addBackground;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void lockColors(Paint paint, Paint paint2) {
        this.colorsLocked = true;
        Color color = (Color)paint;
        Color color2 = (Color)paint2;
        this.strokeCol = new Color(color.getRed(), color.getGreen(), color.getBlue());
        this.fillCol = new Color(color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    public void setHiResImageForDisplayMode(boolean bl) {
    }

    public void dumpImagesFromMemory() {
        if (this.tmpFile == null) {
            try {
                int n = this.pageObjects.size();
                for (int i = 0; i < n; ++i) {
                    Object object = this.pageObjects.elementAt(i);
                    if (object == null || !(object instanceof BufferedImage)) continue;
                    this.pageObjects.setElementAt(null, i);
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " trying to save remove object.");
                System.out.println(exception + " trying to save remove object.");
            }
        }
    }

    public void setOptimiseDrawing(boolean bl) {
        this.optimiseDrawing = bl;
    }

    static {
        hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

