/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.util.StringTokenizer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_String;

public class PdfPageData {
    private int raw_rotation = 0;
    private Vector_Int rotation = new Vector_Int(20);
    private Vector_String mediaString = new Vector_String(20);
    private Vector_String cropString = new Vector_String(20);
    private Vector_Int mediaBoxWidths = new Vector_Int(20);
    private Vector_Int mediaBoxHeights = new Vector_Int(20);
    private Vector_Int mediaBoxXs = new Vector_Int(20);
    private Vector_Int mediaBoxYs = new Vector_Int(20);
    private Vector_Int cropBoxWidths = new Vector_Int(20);
    private Vector_Int cropBoxHeights = new Vector_Int(20);
    private Vector_Int cropBoxXs = new Vector_Int(20);
    private Vector_Int cropBoxYs = new Vector_Int(20);
    private int cropBoxX = -99999;
    private int cropBoxY = -1;
    private int cropBoxW = -1;
    private int cropBoxH = -1;
    private int mediaBoxX = -1;
    private int mediaBoxY;
    private int mediaBoxW;
    private int mediaBoxH;
    private String cropValue = "";
    private String mediaValue = "";

    public void checkSizeSet(int n) {
        if (this.mediaBoxW == 0 | this.mediaBoxH == 0) {
            LogWriter.writeLog("NO page co-ords set - using 800 * 800");
            this.mediaBoxW = 800;
            this.mediaBoxH = 800;
            this.cropBoxW = 800;
            this.cropBoxH = 800;
        }
        this.mediaBoxXs.setElementAt(this.mediaBoxX, n);
        this.mediaBoxYs.setElementAt(this.mediaBoxY, n);
        this.mediaBoxWidths.setElementAt(this.mediaBoxW, n);
        this.mediaBoxHeights.setElementAt(this.mediaBoxH, n);
        this.cropBoxXs.setElementAt(this.cropBoxX, n);
        this.cropBoxYs.setElementAt(this.cropBoxY, n);
        this.cropBoxWidths.setElementAt(this.cropBoxW, n);
        this.cropBoxHeights.setElementAt(this.cropBoxH, n);
        this.cropString.setElementAt(this.cropValue, n);
        this.mediaString.setElementAt(this.mediaValue, n);
    }

    public final int getMediaBoxHeight(int n) {
        return this.mediaBoxHeights.elementAt(n);
    }

    public final int getRotation(int n) {
        return this.rotation.elementAt(n);
    }

    public final int getMediaBoxY(int n) {
        return this.mediaBoxYs.elementAt(n);
    }

    public final int getMediaBoxX(int n) {
        return this.mediaBoxXs.elementAt(n);
    }

    public void setMediaBox(String string) {
        String string2 = Strip.removeArrayDeleminators(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        this.mediaValue = string2;
        this.cropValue = string2;
        this.mediaBoxX = (int)Float.parseFloat(stringTokenizer.nextToken());
        this.mediaBoxY = (int)Float.parseFloat(stringTokenizer.nextToken());
        this.mediaBoxW = (int)Float.parseFloat(stringTokenizer.nextToken()) - this.mediaBoxX;
        this.mediaBoxH = (int)Float.parseFloat(stringTokenizer.nextToken()) - this.mediaBoxY;
        this.cropBoxX = this.mediaBoxX;
        this.cropBoxY = this.mediaBoxY;
        this.cropBoxW = this.mediaBoxW;
        this.cropBoxH = this.mediaBoxH;
    }

    public void setCropBox(String string) {
        String string2 = Strip.removeArrayDeleminators(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        this.cropValue = string2;
        this.cropBoxX = (int)Float.parseFloat(stringTokenizer.nextToken());
        this.cropBoxY = (int)Float.parseFloat(stringTokenizer.nextToken());
        this.cropBoxW = (int)Float.parseFloat(stringTokenizer.nextToken()) - this.cropBoxX;
        this.cropBoxH = (int)Float.parseFloat(stringTokenizer.nextToken()) - this.cropBoxY;
    }

    public int setPageRotation(String string, int n) {
        this.raw_rotation = 0;
        try {
            this.raw_rotation = Integer.parseInt(string);
            if (this.raw_rotation < 0) {
                this.raw_rotation = 360 + this.raw_rotation;
            }
            this.rotation.setElementAt(this.raw_rotation, n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading rotation");
        }
        return this.raw_rotation;
    }

    public final int getMediaBoxWidth(int n) {
        return this.mediaBoxWidths.elementAt(n);
    }

    public String getMediaValue(int n) {
        return this.mediaString.elementAt(n);
    }

    public String getCropValue(int n) {
        return this.cropString.elementAt(n);
    }

    public int getCropBoxX(int n) {
        return this.cropBoxXs.elementAt(n);
    }

    public int getCropBoxWidth(int n) {
        return this.cropBoxWidths.elementAt(n);
    }

    public int getCropBoxY(int n) {
        return this.cropBoxYs.elementAt(n);
    }

    public int getCropBoxHeight(int n) {
        return this.cropBoxHeights.elementAt(n);
    }
}

