/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.Inflater;
import org.jpedal.io.DecodePredictor;
import org.jpedal.io.PdfFileReader;
import org.jpedal.sun.LZWDecoder;
import org.jpedal.sun.TIFFFaxDecoder;
import org.jpedal.sun.TIFFLZWDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class PdfFilteredReader
extends PdfFileReader {
    private static final long[] base_85_indices = new long[]{52200625L, 614125L, 7225L, 85L, 1L};
    private static final long[] hex_indices = new long[]{0x1000000L, 65536L, 256L, 1L};

    public final byte[] decodeFilters(byte[] byArray, String string, Map map, int n, int n2) throws Exception {
        StringTokenizer stringTokenizer;
        Object object;
        Hashtable hashtable = new Hashtable();
        if (map != null && (object = map.get("DecodeParms")) != null) {
            if (object instanceof String) {
                stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators((String)object));
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.startsWith("<<")) {
                        string2 = string2.substring(2).trim();
                    }
                    if (!string2.startsWith("/")) continue;
                    String string3 = string2.substring(1);
                    string2 = stringTokenizer.nextToken();
                    if (string2.endsWith(">>")) {
                        string2 = string2.substring(0, string2.length() - 2).trim();
                    }
                    hashtable.put(string3, string2);
                }
            } else {
                hashtable = (Hashtable)object;
            }
        }
        if (string.startsWith("[")) {
            string = string.endsWith("]") ? string.substring(1, string.length() - 1) : string.substring(1);
        } else if (string.endsWith("]")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() > 0) {
            stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (!((String)object).startsWith("/")) continue;
                if (((String)object).indexOf("/FlateDecode") != -1 | ((String)object).indexOf("/Fl") != -1) {
                    byArray = this.flateDecode(byArray, hashtable);
                    continue;
                }
                if (((String)object).indexOf("/ASCII85Decode") != -1 | ((String)object).indexOf("/A85") != -1) {
                    byArray = this.ascii85Decode(byArray);
                    continue;
                }
                if (((String)object).indexOf("/CCITT") != -1 | ((String)object).indexOf("/CCF") != -1) {
                    byArray = this.ccittDecode(byArray, hashtable, n, n2);
                    continue;
                }
                if (((String)object).indexOf("/LZW") != -1) {
                    byArray = this.lzwDecode(byArray, hashtable, n, n2);
                    continue;
                }
                if (((String)object).indexOf("/RunLengthDecode") != -1 | ((String)object).indexOf("/RL") != -1) {
                    byArray = this.runLengthDecode(byArray);
                    continue;
                }
                if (((String)object).indexOf("/ASCIIHexDecode") != -1 | ((String)object).indexOf("/AHx") != -1) {
                    byArray = this.asciiHexDecode(byArray);
                    continue;
                }
                if (((String)object).indexOf("/DCTDecode") != -1 || ((String)object).indexOf("/JPXDecode") != -1) continue;
                LogWriter.writeLog("[PDF] Unsupported decompression stream " + (String)object);
                byArray = null;
            }
        }
        return byArray;
    }

    private byte[] runLengthDecode(byte[] byArray) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            int n;
            int n2 = byArray[i];
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            if (n2 == 128) {
                i = byArray.length;
                continue;
            }
            if (n2 > 128) {
                ++i;
                n2 = 257 - n2;
                for (n = 0; n < n2; ++n) {
                    byteArrayOutputStream.write(byArray[i]);
                }
                continue;
            }
            ++i;
            ++n2;
            for (n = 0; n < n2; ++n) {
                byteArrayOutputStream.write(byArray[i + n]);
            }
            i = i + n2 - 1;
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private final byte[] lzwDecode(byte[] byArray, Map map, int n, int n2) throws Exception {
        int n3 = 1;
        int n4 = 8;
        int n5 = 1;
        int n6 = n2;
        int n7 = n;
        String string = (String)map.get("Predictor");
        if (string != null) {
            n3 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("Rows")) != null) {
            n6 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("Columns")) != null) {
            n7 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("EarlyChange")) != null) {
            n5 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("BitsPerComponent")) != null) {
            n4 = Integer.parseInt(string);
        }
        if (n6 * n7 == 1) {
            byte[] byArray2 = new byte[n4 * n6 * (n7 + 7 >> 3)];
            TIFFLZWDecoder tIFFLZWDecoder = new TIFFLZWDecoder(n7, n3, n4);
            tIFFLZWDecoder.decode(byArray, byArray2, n6);
            return this.applyPredictor(n3, map, byArray2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZWDecoder lZWDecoder = new LZWDecoder();
        lZWDecoder.decode(byArray, byteArrayOutputStream);
        return this.applyPredictor(n3, map, byteArrayOutputStream.toByteArray());
    }

    private final byte[] ccittDecode(byte[] byArray, Map map, int n, int n2) throws Exception {
        boolean bl = false;
        int n3 = 1728;
        int n4 = n2;
        int n5 = 0;
        boolean bl2 = false;
        String string = (String)map.get("K");
        if (string != null) {
            n5 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("EncodedByteAlign")) != null) {
            bl2 = Boolean.valueOf(string);
        }
        if ((string = (String)map.get("BlackIs1")) != null) {
            bl = Boolean.valueOf(string);
        }
        if ((string = (String)map.get("Rows")) != null) {
            n4 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("Columns")) != null) {
            n3 = Integer.parseInt(string);
        }
        byte[] byArray2 = new byte[n4 * (n3 + 7 >> 3)];
        try {
            TIFFFaxDecoder tIFFFaxDecoder = new TIFFFaxDecoder(1, n3, n4);
            if (n5 == 0) {
                tIFFFaxDecoder.decode1D(byArray2, byArray, 0, n4);
            } else if (n5 > 0) {
                tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n4, 0L);
            } else if (n5 < 0) {
                tIFFFaxDecoder.decodeT6(byArray2, byArray, 0, n4, 0L, bl2);
            }
            if (!bl) {
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray2[i] = (byte)(255 - byArray2[i]);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing CCITT filter " + exception);
        }
        return byArray2;
    }

    private final byte[] ascii85Decode(byte[] byArray) {
        int n;
        int n2 = 0;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
            if (bufferedReader != null) {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading ASCII stream ");
        }
        int n3 = stringBuffer.length();
        for (n = 0; n < n3; ++n) {
            if (stringBuffer.charAt(n) != 'z') continue;
            ++n2;
        }
        n = 0;
        long l = 0L;
        byte[] byArray2 = new byte[n3 + 1 + n2 * 3];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5;
            l = 0L;
            if (stringBuffer.charAt(i) == 'z') {
                for (n5 = 0; n5 < 4; ++n5) {
                    byArray2[n] = 0;
                    ++n;
                }
                continue;
            }
            if (n3 - i <= 4 || !(stringBuffer.charAt(i) > ' ' & stringBuffer.charAt(i) < 'v')) continue;
            for (n4 = 0; n4 < 5; ++n4) {
                l += (long)(stringBuffer.charAt(i + n4) - 33) * base_85_indices[n4];
            }
            for (n5 = 0; n5 < 4; ++n5) {
                byArray2[n] = (byte)(l / hex_indices[n5] & 0xFFL);
                ++n;
            }
            i += 4;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    private final byte[] asciiHexDecode(byte[] byArray) throws IOException {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
            if (bufferedReader != null) {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer2.append(string);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading ASCII stream ");
        }
        int n = stringBuffer2.length();
        int n2 = 0;
        int n3 = 0;
        char c = ' ';
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        do {
            if (!((c = (char)stringBuffer2.charAt(n2)) >= '0' & c <= '9' | c >= 'a' & c <= 'f' | c >= 'A' & c <= 'F')) continue;
            stringBuffer.append(c);
            if (n3 == 1) {
                byteArrayOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
                n3 = 0;
                stringBuffer = new StringBuffer();
                continue;
            }
            ++n3;
        } while (c != '>' && ++n2 != n);
        if (n3 == 1) {
            stringBuffer.append('0');
            byteArrayOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private final byte[] flateDecode(byte[] byArray, Map map) throws Exception {
        int n = 1;
        String string = (String)map.get("Predictor");
        if (string != null) {
            n = Integer.parseInt(string);
        }
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        int n2 = byArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        int n3 = 512000;
        if (n2 < n3) {
            n3 = n2;
        }
        byte[] byArray2 = new byte[n3];
        int n4 = 20;
        while (!inflater.finished()) {
            int n5 = inflater.inflate(byArray2);
            byteArrayOutputStream.write(byArray2, 0, n5);
            if (inflater.getRemaining() != 0) continue;
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return this.applyPredictor(n, map, byteArrayOutputStream.toByteArray());
    }

    private byte[] applyPredictor(int n, Map map, byte[] byArray) throws Exception {
        if (n != 1 & n != 10) {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DecodePredictor decodePredictor = new DecodePredictor(byteArrayInputStream, n, map);
            while ((n2 = decodePredictor.read(byteArrayInputStream)) != -1) {
                byteArrayOutputStream.write(n2);
            }
            byteArrayOutputStream.close();
            decodePredictor = null;
            byteArrayInputStream.close();
            byteArrayInputStream = null;
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }
}

